import React from 'react';
import PropTypes from 'prop-types';
import Svg, { G, Path } from 'react-native-svg';
/* SVGR has dropped some elements not supported by react-native-svg: title */

const DieGruenen = props => (
  <Svg width={562} height={(props.width / 562) * 308} viewBox="0 0 562 308" {...props}>
    <G fill="none" fillRule="evenodd">
      <Path fill="#4DBD38" d="M0 307.485h561.761V57.388H0z" />
      <Path
        d="M520.643 108.276c-.101-.642-1.714-1.214-2.791-2.104-3.666-3.06-16.777-15.962-42.573-15.126-3.261.105-6.241.414-8.953.88 5.494-1.786 8.342-2.853 9.995-3.512 2-.791 15.163-5.305 22.249-28.434.602-1.973 2.312-6.744 1.885-7.101-.523-.444-4.949.345-9.423 3.066-4.492 2.734-19.573 5.112-21.361 5.398-1.05.167-5.481-.496-12.096 2.98 7.454-7.656 15.366-18.54 17.489-33.819 1.015-7.323.584-10.31.268-10.288-.44.03-.69.035-1.235.198-1.662.49-3.345 1.895-8.826 5.56-5.49 3.67-11.31 7.736-11.31 7.736s1.996-19.948 1.376-20.413c-.606-.453-11.933-.342-29.323 19.015 0 0 1.98-16.584-1.282-22.837 0 0-.905-4.524-1.614-6.893-.355-1.183-1.284-2.435-1.43-2.325-.184.127-1.724.378-4.19 3.212-3.835 4.392-21.662 9.768-24.615 32.828-2.232-9.304-6.97-21.751-18.671-28.054-6.607-6.472-9.541-8.4-9.881-8.233-.298.151-.169 3.029-1.173 9.503-1.128 7.256-2.141 9.555-2.141 9.555s-12.259-10.78-12.571-11.093c-.58-.572-8.055 23.1-5.857 34.915 0 0-3.884-3-10.943-6.627-8.018-4.119-21.496-4.832-21.407-4.198.158 1.07 11.38 22.988 16.102 30.683 0 0-30.229-5.189-29.697-3.3.174.625.898 1.806 2.092 6.852 0 0-11.864-.256-11.71.727.167 1.098 8.992 15.677 9.67 16.473 0 0-9.177 1.774-11.112 1.88-1.313.07 6.13 20.624 26.535 25.758a83.976 83.976 0 0 0 8.37 1.657l7.589.724c12.144.484 20.114-2.637 18.737-7.132 0 0-.397-1.662-12.848-6.212 0 0 .343-1.485 1.176-1.682.836-.205 13.782 4.54 12.865 3.778-.924-.764-5.662-6.034-4.81-5.985.86.034 6.937 2.607 8.954.714 1.929-1.804 3.148-5.136 4.413-5.858 1.272-.726-3.386-5.028 2.752-3.049 0 0 4.16-2.333.885-6.15-3.274-3.829-13.667-16.113 3.282-1.283 4.052 3.553 14.187-7.266 13.354-13.15 0 0 4.052 4.083 4.906 4.523.86.438 6.534 1.11 7.82-.855.594-.898-2.075-9.276-.36-12.956 0 0 .723-.07 1.404.718.682.785.76 9.52 3.838 11.175 0 0 3.454-2.02 4.038-3.533.588-1.516-.936 9.441 9.43 4.716 0 0 5.049-4.486 6.496-4.62 1.44-.136-1.082 5.322.192 7.266 1.28 1.947 5.525 3.252 6.873.817 1.36-2.43 7.824-7.291 8.33-7.098.507.207-3.29 10.33-3.725 11.318-.63 1.446-1.079 3.587-1.079 3.587s.492 2.826 4.028 3.607c0 0 6.669-3.892 13.61-8.954-.73.876-1.459 1.783-2.206 2.756 0 0-8.974 9.222-8.98 10.56.013 1.335 3.083 4.33 5.595 2.636 2.519-1.687 8.593-4.204 9.125-3.772.523.44 1.49 1.69.229 2.414-1.27.727-8.333 4.422-8.333 4.422s8.073.549 17.945-1.446c-10.69 4.338-14.394 10.94-14.298 11.565.317 2.119 16.927-2.184 17.384-1.14 2.382 5.41-5.266 2.072-8.62 2.634-3.349.55-11.961.747-4.034 7.537 0 0 1.468.11-2.449 2.42-3.911 2.305 8.725 3.682 10.22 5.356 1.494 1.683-12.523-.163-12.25 4.06.268 4.226-2.409 1.561 6.905 11.499 0 0-5.595-1.297-6.246-.51-.66.791 12.246 11.488 12.166 14.532 0 0-2.624 1.823-3.744.235-1.117-1.605-8.919-10.233-10.18-10.487-.954-.184-2.773.254-3.616 1.928 0 0 3.405 7.944 2.341 8.164-1.074.223-6.405-3.528-6.405-3.528s-3.5 1.537-2.344 4.704c1.142 3.173 10.644 13.955 10.103 14.611 0 0-.809 1.774-2.033 1.648-1.228-.128-7.804-12.032-9.426-12.485-1.623-.455 1.888 11.12 1.888 11.12s-5.932-6.244-7.511-7.554c-1.576-1.305-1.808 1.382-1.808 1.382l1.714 13.203s-18.483-27.548-13.959 5.306c0 0-.43 1.859-1.039 1.803-.615-.066-4.54-10.872-4.09-13.826.454-2.966-3.241 8.185-3.241 8.185s-5.795-23.015-17.796.572c0 0-.841-8.907-2.687-10.439-1.837-1.524-3.293-2.06-3.832-2.069-.386-.008-2.82-.1-4.998 4.021-8.456 10.968-13.885 25.08-15.413 37.288-.27 8.482.69 23.749.19 27.023-.293 1.92.145 2.122.445 2.752.095.198 3.258-2.407 4.258-3.073 1.494-.99 16.926-21.745 17.896-26.934 0 0 8.23 36.154 11.023 40.025.604.842 1.105 1.778 1.526 1.122.82-1.29 2.048-4.662 2.97-4.945 1.19-.357 4.666-.795 6.495-5.95 1.829-5.159 5.122-10.19 6.662-23.572 0 0 17.495 22.306 19.77 24.383.902.824 5.657-7.087 7.747-19.787 2.103-12.706-2.41-29.78-5.266-30.364 0 0-1.184-1.872 2.13-.687 1.884.678 9.167 13.315 25.958 22.912 2.826 1.609 8.834 1.645 8.87 1.533 1.349-3.77-11.828-38.249-11.828-38.249s.33-.395 2.984.69c2.646 1.092 27.81 17.363 43.074 9.737 3.099-1.542 3.275-1.871 3.275-1.871 1.749-7.517-11.696-21.728-19.955-28.184 0 0 21.686-.886 25.014-6.632 0 0 3.995-1.438 6.056-4.284.36-.507-2.334-5.453-5.459-7.625-8.188-5.674-9.964-7.813-9.964-7.813s2.29-2.77 5.595-3.809c3.306-1.037 13.995-7.625 11.143-10.876 0 0 3.437-2.99 3.318-3.772"
        fill="#FEE702"
      />
      <Path
        d="M107.313 113.531c-1.235 0-2.36.416-3.376 1.25-1.016.834-1.61 1.845-1.812 3.031-.194 1.18.078 2.196.813 3.032.738.83 1.737 1.25 2.968 1.25 1.217 0 2.33-.42 3.344-1.25 1.034-.855 1.65-1.872 1.844-3.031.198-1.187-.077-2.198-.813-3.032-.718-.834-1.717-1.25-2.969-1.25zm12.374 0c-1.25 0-2.391.416-3.406 1.25-1.011.834-1.62 1.857-1.812 3.031-.198 1.19.074 2.196.812 3.032.735.83 1.732 1.25 3 1.25 1.231 0 2.364-.42 3.375-1.25 1.016-.836 1.624-1.824 1.813-2.969.202-1.209-.073-2.224-.813-3.063-.75-.847-1.734-1.28-2.969-1.28zm-55.656 12.125l-6.906 41.469h16.469c3.93 0 7.288-1.092 10.062-3.281 2.782-2.164 4.469-5.036 5.063-8.594.47-2.833.124-4.998-1.063-6.5-1.191-1.51-3.3-2.477-6.312-2.906 5.487-.43 8.666-3.246 9.531-8.438.582-3.488-.213-6.327-2.344-8.531-2.106-2.148-5.7-3.219-10.812-3.219H64.03zm33.969 0l-4.625 27.75c-.884 5.319.192 9.182 3.25 11.594 2.41 1.902 5.63 2.844 9.656 2.844 3.549 0 6.705-.845 9.469-2.563 2.059-1.292 3.63-2.75 4.688-4.344 1.06-1.522 1.778-3.513 2.187-5.968l4.906-29.313H115.75l-4.438 26.781c-.312 1.863-.757 3.137-1.312 3.875-.55.696-1.377 1.063-2.5 1.063-1.096 0-1.823-.378-2.156-1.125-.338-.752-.333-2.032-.031-3.844l4.437-26.75H98zm35.469 0l-6.906 41.469h11.343l1.75-10.594c.268-1.634.48-3.515.625-5.687.146-2.164.236-4.707.25-7.625.156 1.29.373 2.64.625 4.062.256 1.425.532 2.963.875 4.594l3.313 15.25h11.344l6.875-41.469H152.25l-1.563 9.313c-.29 1.735-.52 3.88-.718 6.437-.2 2.562-.398 5.654-.563 9.25l-.594-3.656c-.243-1.446-.478-2.73-.687-3.844-.218-1.107-.422-2.077-.594-2.937l-3.375-14.563H133.47zm35.531 0l-6.906 41.469h11c6.07 0 10.908-1.593 14.5-4.781 4.215-3.743 6.916-9.065 8.062-15.938 1.16-6.99-.084-12.396-3.687-16.281-2.739-2.97-7.001-4.469-12.813-4.469H169zm33.688 0l-6.907 41.469h11.344l1.75-10.594c.273-1.634.48-3.515.625-5.687.141-2.164.231-4.707.25-7.625.153 1.29.338 2.64.594 4.062.26 1.425.563 2.963.906 4.594l3.313 15.25h11.343l6.875-41.469H221.47l-1.563 9.313c-.292 1.735-.52 3.88-.719 6.437a279.054 279.054 0 0 0-.562 9.25l-.594-3.656c-.242-1.446-.471-2.73-.687-3.844-.21-1.107-.422-2.077-.594-2.937l-3.375-14.563h-10.688zm35.53 0l-6.905 41.469h11.78l6.876-41.469h-11.75zm29.282 0c-3.142 0-5.959.863-8.469 2.594-.905.6-1.718 1.307-2.469 2.094-.753.791-1.47 1.642-2.093 2.594-1.284 2.038-2.07 4.005-2.375 5.875-.18 1.09-.225 2.104-.125 3.093a9.45 9.45 0 0 0 .781 2.875c.408.927.99 1.812 1.75 2.688.756.876 1.684 1.74 2.813 2.625l1.687 1.375c1.22 1.012 1.74 2.055 1.563 3.125-.126.747-.531 1.39-1.25 1.875-.727.498-1.58.719-2.594.719-2.689 0-4.942-1.496-6.75-4.5l-2.125 12.75c2.97 1.13 5.83 1.687 8.594 1.687 4.008 0 7.525-1.286 10.562-3.844 3.04-2.555 4.882-5.787 5.531-9.719.392-2.317.179-4.333-.625-6.062-.788-1.726-2.26-3.418-4.469-5.063l-1.656-1.28c-1.423-1.062-2.055-2.115-1.875-3.188.11-.655.511-1.221 1.188-1.688.668-.484 1.442-.719 2.344-.719 1.186 0 2.319.406 3.406 1.22 1.087.817 1.997 1.933 2.719 3.343l2.062-12.406c-2.61-1.376-5.325-2.063-8.125-2.063zm42.188 0c-4.521 0-8.417 1.341-11.657 4.063-3.258 2.755-5.221 6.284-5.937 10.594-.592 3.574-.086 6.646 1.562 9.187 1.68 2.498 4.007 3.75 7 3.75 1.205 0 2.647-.398 4.344-1.188-.563.65-1.073 1.236-1.531 1.782a34.57 34.57 0 0 0-1.188 1.5l-8.937 11.781H306l5.156-7.125c6.092-8.356 9.532-14.874 10.313-19.594.733-4.407.035-7.981-2.125-10.687-2.167-2.708-5.39-4.063-9.656-4.063zm33.843 0c-4.759 0-8.845 1.835-12.25 5.5-3.394 3.647-5.612 8.6-6.656 14.875-1.102 6.645-.573 11.8 1.594 15.5 2.183 3.717 5.743 5.594 10.687 5.594 4.567 0 8.524-1.843 11.844-5.531 3.319-3.7 5.49-8.68 6.531-14.938 1.094-6.57.6-11.718-1.469-15.437-2.068-3.712-5.485-5.563-10.28-5.563zm-268.469 8.625c.198-.009.37 0 .5 0 2.765 0 3.961 1.19 3.563 3.594-.185 1.125-.764 2.004-1.688 2.625-.918.626-2.09.938-3.5.938h-.78l1.187-7.094c.287-.017.521-.054.719-.063zm232.782.094c2.211 0 2.987 1.816 2.375 5.5-.586 3.54-1.97 5.312-4.156 5.312-2.306 0-3.174-1.735-2.594-5.25.616-3.713 2.093-5.562 4.375-5.562zm33.875 1.187c2.535 0 3.187 3.69 1.969 11.032-.61 3.648-1.368 6.317-2.282 8.031-.918 1.722-2.039 2.562-3.375 2.562-2.469 0-3.055-3.9-1.75-11.75 1.096-6.572 2.912-9.875 5.438-9.875zm-162.688.532h.375c1.826 0 3.092.971 3.844 2.906.75 1.916.862 4.525.313 7.844-1.118 6.716-3.817 10.146-8.063 10.343l3.531-21.093zM71.72 150.156h.937c1.527 0 2.654.373 3.406 1.094.756.72 1.02 1.698.813 2.969-.216 1.274-.813 2.303-1.813 3.062-1 .752-2.25 1.125-3.718 1.125-.114 0-.235.007-.406 0-.167-.013-.373-.045-.594-.062l1.375-8.188zm158.281 20c-1.233 0-2.334.414-3.344 1.25-1.016.83-1.646 1.847-1.844 3.031-.193 1.177.075 2.168.813 3 .733.833 1.736 1.25 2.969 1.25 1.215 0 2.332-.417 3.344-1.25 1.032-.85 1.651-1.84 1.843-3 .198-1.184-.074-2.202-.812-3.03-.716-.837-1.716-1.25-2.969-1.25zm12.375 0c-1.254 0-2.391.414-3.406 1.25-1.015.83-1.62 1.828-1.813 3-.2 1.192.075 2.199.813 3.031.738.833 1.727 1.25 3 1.25 1.224 0 2.36-.417 3.375-1.25 1.011-.832 1.618-1.799 1.812-2.937.202-1.209-.07-2.226-.812-3.063-.747-.85-1.74-1.28-2.969-1.28zM54.937 181.97l-6.906 41.468h11c6.07 0 10.905-1.596 14.5-4.78 4.215-3.739 6.914-9.03 8.063-15.907 1.162-6.983-.084-12.424-3.688-16.313-2.738-2.97-7.002-4.468-12.812-4.468H54.938zm34.438 0l-6.906 41.468H94.25l6.875-41.468h-11.75zm17.156 0l-6.875 41.468H121.5l1.656-9.906h-10.094l.97-5.844h9.03l1.657-9.906h-9.063l1-5.875h10.094l1.656-9.937h-21.875zm60.875 0c-5.192 0-9.608 1.894-13.219 5.625-3.614 3.737-5.953 8.83-7.03 15.312-1.065 6.398-.422 11.428 1.937 15.094 2.381 3.633 6.227 5.437 11.469 5.437 5.343 0 9.68-1.85 13.03-5.562 3.062-3.408 5.245-8.97 6.532-16.719l.281-1.656H163.97l-1.438 8.687h4.344c-.134.807-.349 1.562-.656 2.22a6.65 6.65 0 0 1-1.125 1.687c-.426.458-.888.813-1.438 1.062a4.112 4.112 0 0 1-1.75.375c-1.559 0-2.574-.776-3.031-2.312-.462-1.533-.409-3.984.156-7.375 1.322-7.967 3.578-11.938 6.813-11.938.923 0 1.637.366 2.125 1.125.486.76.7 1.815.656 3.125l12.063-4c-1.973-6.79-6.404-10.187-13.282-10.187zm20.219 0l-6.875 41.468h11.688l2.437-14.5.375-2.718c.11.575.174 1.057.25 1.468.07.407.14.755.156 1l3.344 14.75h12.719l-5.875-17.218c4.807-1.913 7.633-5.39 8.469-10.407.777-4.687-.297-8.299-3.22-10.843-2.304-1.988-6.103-3-11.405-3h-12.063zm68.406 0l-6.875 41.468h11.313l1.781-10.562c.271-1.631.451-3.549.594-5.719.142-2.168.233-4.701.25-7.625.154 1.293.37 2.669.625 4.094.256 1.42.536 2.928.875 4.562l3.312 15.25h11.344l6.906-41.468h-11.344l-1.562 9.343c-.288 1.733-.518 3.875-.719 6.438-.197 2.562-.4 5.653-.562 9.25l-.594-3.656a153.01 153.01 0 0 0-.688-3.844c-.209-1.113-.39-2.112-.562-2.969l-3.406-14.562H256.03zm35.531 0l-6.875 41.468h21.844l1.656-9.906h-10.093l.969-5.844h9.03l1.657-9.906h-9.063l1-5.875h10.094l1.656-9.937h-21.875zm26.75 0l-6.906 41.468h11.344l1.75-10.562c.266-1.631.488-3.549.625-5.719.14-2.168.233-4.701.25-7.625a68.55 68.55 0 0 0 .594 4.094c.252 1.42.563 2.928.906 4.562l3.313 15.25h11.343l6.875-41.468h-11.312l-1.563 9.343c-.286 1.733-.516 3.875-.719 6.438-.2 2.562-.399 5.653-.562 9.25l-.594-3.656a241.46 241.46 0 0 0-.687-3.844c-.215-1.113-.424-2.112-.594-2.969L329 181.97h-10.688zm-97.625.281L216.063 210c-.887 5.319.191 9.178 3.25 11.594 2.413 1.897 5.63 2.875 9.657 2.875 3.549 0 6.732-.88 9.5-2.594 2.058-1.296 3.602-2.72 4.656-4.313 1.06-1.523 1.78-3.513 2.188-5.968l4.875-29.344h-11.75L234 209.031c-.307 1.867-.76 3.173-1.313 3.906-.549.701-1.37 1.032-2.5 1.032-1.09 0-1.816-.373-2.156-1.125-.336-.75-.33-2.033-.031-3.844l4.438-26.75h-11.75zm-22.718 8.437h.406c3.403 0 4.857 1.561 4.344 4.657-.254 1.523-.936 2.766-2 3.75-1.068.987-2.277 1.468-3.625 1.468h-.781l1.656-9.875zm-133 1.72h.375c1.82 0 3.09.969 3.844 2.905.752 1.915.861 4.534.312 7.844-1.12 6.717-3.817 10.176-8.063 10.375l3.532-21.125z"
        fill="#FFF"
        fillRule="nonzero"
      />
      <Path fill="#166AB8" d="M41.004 266.493H334.61l4.546-28.097H45.558l-4.554 28.097" />
      <Path
        d="M47.468 262.026h6.964c4.623 0 6.536-3.1 6.91-5.465.407-2.567-.692-4.141-3.2-4.344l.009-.051c2.184 0 3.85-1.678 4.192-3.838.654-4.141-2.695-5.463-5.741-5.463h-6.099l-3.035 19.16zm5.837-4.143l.587-3.686h.407c1.192 0 2.099.535 1.896 1.832-.208 1.29-1.312 1.854-2.453 1.854h-.437zm1.2-7.572l.524-3.301h.512c1.066 0 1.773.477 1.593 1.627-.197 1.241-1.257 1.674-2.32 1.674h-.309zm20.971-7.446l-1.913 12.07c-.072.484-.152 1.14-.39 1.677-.205.507-.6.916-1.34.916-.708 0-.976-.41-1.042-.941-.074-.512.058-1.168.137-1.678l1.906-12.044h-5.18l-1.984 12.528c-.369 2.31-.597 6.962 5.397 6.962 6.002 0 7.244-4.653 7.61-6.962l1.982-12.528h-5.183zm6.849 19.16h4.979l.892-5.619c.286-1.803.339-3.58.498-5.382l.055-.057 2.115 11.059h4.982l3.031-19.161h-4.98l-.773 4.88c-.349 2.21-.313 4.395-.462 6.606l-.058.051-2.315-11.537h-4.927l-3.037 19.16zm18.345 0h4.524c3.15 0 8.842-.815 10.242-9.657.918-5.796-1.673-9.503-7.565-9.503h-4.167l-3.034 19.16zm7.46-14.383c2.364 0 2.311 2.897 1.982 4.979-.287 1.802-1.16 4.752-3.526 4.781l1.544-9.76zm10.044 14.384h9.629l.717-4.524h-4.445l.462-2.924h3.987l.715-4.524h-3.984l.42-2.665h4.449l.716-4.524h-9.63l-3.036 19.16zm14.046-.46a9.34 9.34 0 0 0 3.762.79c3.609 0 6.55-2.845 7.113-6.405.227-1.445.06-2.464-.415-3.33-.448-.859-1.199-1.571-2.17-2.336-.24-.231-.584-.484-.813-.79-.233-.3-.405-.655-.338-1.064.113-.733.917-1.17 1.53-1.17 1.195 0 2.266 1.093 2.723 2.058l.918-5.815a7.185 7.185 0 0 0-3.528-.97c-4.421 0-6.488 4.069-6.844 6.306-.22 1.394.018 2.458.515 3.351.512.915 1.288 1.648 2.18 2.438.29.232.563.459.743.733.21.285.312.615.24 1.07-.136.841-1.015 1.27-1.727 1.27-1.322 0-2.395-1.067-2.94-2.128l-.949 5.992zm21.27.46l2.293-14.484h2.972l.744-4.677h-11.002l-.744 4.677h2.849l-2.294 14.484h5.181zm19.105 0l-1.026-19.161h-6.331l-7.632 19.16h5.337l.822-2.468h3.48l-.009 2.469h5.36zm-7.503-6.535l1.415-4.441c.396-1.197.718-2.413 1.056-3.61h.052c-.06 1.197-.153 2.413-.19 3.61l-.147 4.441h-2.186zm19.32-4.545l-.64 4.04h1.904c-.149 1.117-.84 2.742-2.211 2.742-2.007 0-1.375-3.351-1.234-4.721.228-1.45.724-5.846 3.11-5.846.916 0 1.237 1.193 1.166 1.953l5.297-1.854c-.678-2.769-2.684-4.726-5.78-4.726-5.613 0-8.252 5.262-9.008 10.015-.764 4.853.277 9.806 5.917 9.806 5.999 0 7.841-5.866 8.595-10.593l.1-.816h-7.217zm9.14 10.62a9.341 9.341 0 0 0 3.764.79c3.607 0 6.546-2.845 7.11-6.405.23-1.445.06-2.464-.413-3.33-.448-.859-1.2-1.571-2.172-2.336-.24-.231-.583-.484-.814-.79-.231-.3-.403-.655-.336-1.064.113-.733.918-1.17 1.528-1.17 1.195 0 2.268 1.093 2.725 2.058l.918-5.815a7.184 7.184 0 0 0-3.526-.97c-4.425 0-6.489 4.069-6.845 6.306-.22 1.394.017 2.458.514 3.351.514.915 1.288 1.648 2.179 2.438.29.232.564.459.747.733.208.285.31.615.239 1.07-.136.841-1.017 1.27-1.727 1.27-1.324 0-2.395-1.067-2.941-2.128l-.95 5.992zm19.365.46l1.163-7.345h3.706l.718-4.524h-3.709l.44-2.768h3.964l.718-4.524h-9.148l-3.037 19.16h5.185zm22.456 0l-2.596-7.98c2.187-.81 3.401-2.696 3.736-4.803.8-5.056-2.248-6.378-6.744-6.378h-5l-3.039 19.16h5.184l.808-5.109c.15-.94.25-1.878.373-2.823l.058-.047 1.607 7.98h5.613zm-6.825-10.319l.747-4.722c1.437-.082 2.34.63 2.075 2.31-.197 1.244-1.122 2.441-2.497 2.441l-.325-.029zm23.977 10.319l-1.034-19.161h-6.325l-7.63 19.16h5.331l.826-2.468h3.477l-.01 2.469h5.364zm-7.503-6.535l1.415-4.441c.39-1.197.712-2.413 1.055-3.61h.052c-.065 1.197-.153 2.413-.194 3.61l-.142 4.441h-2.186zm24.983 6.535l-3.056-9.912 5.604-9.25h-5.458l-4.14 8.16h-.075l-.01.048.057-.048h-.022.022l1.292-8.16h-5.18l-3.034 19.162h5.181l1.395-8.79h.048-.02l1.831 8.79h5.565zm10.975 0l2.295-14.484h2.97l.742-4.677h-11l-.742 4.677h2.845l-2.293 14.484h5.183zm12.016 0l3.032-19.161h-5.181l-3.031 19.16h5.18zm5.757-9.58c-.739 4.673.493 9.91 5.752 9.91 5.259 0 8.141-5.237 8.885-9.91.738-4.676-.486-9.912-5.747-9.912-5.259 0-8.148 5.236-8.89 9.911zm5.288 0c.189-1.194.879-5.083 2.836-5.083 1.954 0 1.419 3.889 1.228 5.082-.187 1.194-.88 5.083-2.837 5.083-1.957 0-1.416-3.89-1.227-5.083zm12.101 9.58h4.98l.887-5.62c.287-1.803.34-3.58.497-5.382l.06-.057 2.112 11.059h4.98l3.035-19.161h-4.984l-.768 4.88c-.353 2.21-.32 4.395-.465 6.606l-.06.051-2.313-11.537h-4.927l-3.034 19.16z"
        fill="#FFF"
        fillRule="nonzero"
      />
    </G>
  </Svg>
);

DieGruenen.propTypes = {
  width: PropTypes.number.isRequired,
};

DieGruenen.defaultProps = {};

export default DieGruenen;
