/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.File;
import junit.framework.TestCase;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.CharacterData;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.dom4j.util.NodeComparator;

public class AbstractTestCase
extends TestCase {
    protected Document document;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected AbstractTestCase() {
    }

    protected AbstractTestCase(String name) {
        super(name);
    }

    protected void log(String text) {
        System.out.println(text);
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Document getDocument(String path) throws Exception {
        return this.getDocument(path, new SAXReader());
    }

    protected Document getDocument(String path, SAXReader reader) throws Exception {
        return reader.read(this.getFile(path));
    }

    protected File getFile(String path) {
        return new File(System.getProperty("user.dir"), path);
    }

    public void assertDocumentsEqual(Document doc1, Document doc2) throws Exception {
        try {
            AbstractTestCase.assertTrue((String)"Doc1 not null", (doc1 != null ? 1 : 0) != 0);
            AbstractTestCase.assertTrue((String)"Doc2 not null", (doc2 != null ? 1 : 0) != 0);
            doc1.normalize();
            doc2.normalize();
            this.assertNodesEqual(doc1, doc2);
            NodeComparator comparator = new NodeComparator();
            AbstractTestCase.assertTrue((String)"Documents are equal", (comparator.compare(doc1, doc2) == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            this.log("Failed during comparison of: " + doc1 + " and: " + doc2);
            throw e;
        }
    }

    public void assertNodesEqual(Document n1, Document n2) {
        this.assertNodesEqual(n1.getDocType(), n2.getDocType());
        this.assertNodesEqualContent(n1, n2);
    }

    public void assertNodesEqual(Element n1, Element n2) {
        this.assertNodesEqual(n1.getQName(), n2.getQName());
        int c1 = n1.attributeCount();
        int c2 = n2.attributeCount();
        AbstractTestCase.assertEquals((String)("Elements have same number of attributes (" + c1 + ", " + c2 + " for: " + n1 + " and " + n2), (int)c1, (int)c2);
        int i = 0;
        while (i < c1) {
            Attribute a1 = n1.attribute(i);
            Attribute a2 = n2.attribute(a1.getQName());
            this.assertNodesEqual(a1, a2);
            ++i;
        }
        this.assertNodesEqualContent(n1, n2);
    }

    public void assertNodesEqual(Attribute n1, Attribute n2) {
        this.assertNodesEqual(n1.getQName(), n2.getQName());
        AbstractTestCase.assertEquals((String)("Attribute values for: " + n1 + " and " + n2), (String)n1.getValue(), (String)n2.getValue());
    }

    public void assertNodesEqual(QName n1, QName n2) {
        AbstractTestCase.assertEquals((String)("URIs equal for: " + n1.getQualifiedName() + " and " + n2.getQualifiedName()), (String)n1.getNamespaceURI(), (String)n2.getNamespaceURI());
        AbstractTestCase.assertEquals((String)"qualified names equal", (String)n1.getQualifiedName(), (String)n2.getQualifiedName());
    }

    public void assertNodesEqual(CharacterData t1, CharacterData t2) {
        AbstractTestCase.assertEquals((String)("Text equal for: " + t1 + " and " + t2), (String)t1.getText(), (String)t2.getText());
    }

    public void assertNodesEqual(DocumentType o1, DocumentType o2) {
        if (o1 != o2) {
            if (o1 == null) {
                AbstractTestCase.assertTrue((String)("Missing DocType: " + o2), (boolean)false);
            } else if (o2 == null) {
                AbstractTestCase.assertTrue((String)("Missing DocType: " + o1), (boolean)false);
            } else {
                AbstractTestCase.assertEquals((String)"DocType name equal", (String)o1.getName(), (String)o2.getName());
                AbstractTestCase.assertEquals((String)"DocType publicID equal", (String)o1.getPublicID(), (String)o2.getPublicID());
                AbstractTestCase.assertEquals((String)"DocType systemID equal", (String)o1.getSystemID(), (String)o2.getSystemID());
            }
        }
    }

    public void assertNodesEqual(Entity o1, Entity o2) {
        AbstractTestCase.assertEquals((String)"Entity names equal", (String)o1.getName(), (String)o2.getName());
        AbstractTestCase.assertEquals((String)"Entity values equal", (String)o1.getText(), (String)o2.getText());
    }

    public void assertNodesEqual(ProcessingInstruction n1, ProcessingInstruction n2) {
        AbstractTestCase.assertEquals((String)"PI targets equal", (String)n1.getTarget(), (String)n2.getTarget());
        AbstractTestCase.assertEquals((String)"PI text equal", (String)n1.getText(), (String)n2.getText());
    }

    public void assertNodesEqual(Namespace n1, Namespace n2) {
        AbstractTestCase.assertEquals((String)"Namespace prefixes not equal", (String)n1.getPrefix(), (String)n2.getPrefix());
        AbstractTestCase.assertEquals((String)"Namespace URIs not equal", (String)n1.getURI(), (String)n2.getURI());
    }

    public void assertNodesEqualContent(Branch b1, Branch b2) {
        int c2;
        int c1 = b1.nodeCount();
        if (c1 != (c2 = b2.nodeCount())) {
            this.log("Content of: " + b1);
            this.log("is: " + b1.content());
            this.log("Content of: " + b2);
            this.log("is: " + b2.content());
        }
        AbstractTestCase.assertEquals((String)("Branches have same number of children (" + c1 + ", " + c2 + " for: " + b1 + " and " + b2), (int)c1, (int)c2);
        int i = 0;
        while (i < c1) {
            Node n1 = b1.node(i);
            Node n2 = b2.node(i);
            this.assertNodesEqual(n1, n2);
            ++i;
        }
    }

    public void assertNodesEqual(Node n1, Node n2) {
        short nodeType2;
        short nodeType1 = n1.getNodeType();
        AbstractTestCase.assertTrue((String)"Nodes are of same type: ", (nodeType1 == (nodeType2 = n2.getNodeType()) ? 1 : 0) != 0);
        switch (nodeType1) {
            case 1: {
                this.assertNodesEqual((Element)n1, (Element)n2);
                break;
            }
            case 9: {
                this.assertNodesEqual((Document)n1, (Document)n2);
                break;
            }
            case 2: {
                this.assertNodesEqual((Attribute)n1, (Attribute)n2);
                break;
            }
            case 3: {
                this.assertNodesEqual((Text)n1, (Text)n2);
                break;
            }
            case 4: {
                this.assertNodesEqual((CDATA)n1, (CDATA)n2);
                break;
            }
            case 5: {
                this.assertNodesEqual((Entity)n1, (Entity)n2);
                break;
            }
            case 7: {
                this.assertNodesEqual((ProcessingInstruction)n1, (ProcessingInstruction)n2);
                break;
            }
            case 8: {
                this.assertNodesEqual((Comment)n1, (Comment)n2);
                break;
            }
            case 10: {
                this.assertNodesEqual((DocumentType)n1, (DocumentType)n2);
                break;
            }
            case 13: {
                this.assertNodesEqual((Namespace)n1, (Namespace)n2);
                break;
            }
            default: {
                AbstractTestCase.assertTrue((String)("Invalid node types. node1: " + n1 + " and node2: " + n2), (boolean)false);
            }
        }
    }

    protected void setUp() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.setProperty("javax.xml.parsers.SAXParserFactory", clazz.getName());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.apache.xalan.processor.TransformerFactoryImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.setProperty("javax.xml.transform.TransformerFactory", clazz2.getName());
        this.document = DocumentHelper.createDocument();
        Element root = this.document.addElement("root");
        Element author1 = root.addElement("author").addAttribute("name", "James").addAttribute("location", "UK").addText("James Strachan");
        Element url1 = author1.addElement("url");
        url1.addText("http://sourceforge.net/users/jstrachan/");
        Element author2 = root.addElement("author").addAttribute("name", "Bob").addAttribute("location", "Canada").addText("Bob McWhirter");
        Element url2 = author2.addElement("url");
        url2.addText("http://sourceforge.net/users/werken/");
    }

    protected Element getRootElement() {
        Element root = this.document.getRootElement();
        AbstractTestCase.assertTrue((String)"Document has root element", (root != null ? 1 : 0) != 0);
        return root;
    }
}

