/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.io.XMLWriter;

public class BackedListTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.BackedListTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testXPaths() throws Exception {
        Element element = (Element)this.document.selectSingleNode("/root");
        this.mutate(element);
        element = (Element)this.document.selectSingleNode("//author");
        this.mutate(element);
    }

    public void testAddRemove() throws Exception {
        Element parentElement = (Element)this.document.selectSingleNode("/root");
        List children = parentElement.elements();
        int lastPos = children.size() - 1;
        Element child = (Element)children.get(lastPos);
        try {
            children.add(0, child);
            BackedListTest.fail();
        }
        catch (IllegalAddException illegalAddException) {
            // empty catch block
        }
    }

    public void testAddWithIndex() throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        Element root = (Element)this.document.selectSingleNode("/root");
        List children = root.elements();
        BackedListTest.assertEquals((int)2, (int)children.size());
        children.add(1, factory.createElement("dummy1"));
        children = root.elements();
        BackedListTest.assertEquals((int)3, (int)children.size());
        children = root.elements("author");
        BackedListTest.assertEquals((int)2, (int)children.size());
        children.add(1, factory.createElement("dummy2"));
        children = root.elements();
        BackedListTest.assertEquals((int)4, (int)children.size());
        BackedListTest.assertEquals((String)"dummy1", (String)((Node)children.get(1)).getName());
        BackedListTest.assertEquals((String)"dummy2", (String)((Node)children.get(2)).getName());
        children.add(children.size(), factory.createElement("dummy3"));
        children = root.elements("author");
        children.add(children.size(), factory.createElement("dummy4"));
    }

    protected void mutate(Element element) throws Exception {
        DocumentFactory factory = DocumentFactory.getInstance();
        List list = element.elements();
        list.add(factory.createElement("last"));
        list.add(0, factory.createElement("first"));
        List list2 = element.elements();
        BackedListTest.assertTrue((String)"Both lists should contain same number of elements", (list.size() == list2.size() ? 1 : 0) != 0);
        XMLWriter writer = new XMLWriter(System.out);
        this.log("Element content is now: " + element.content());
        writer.write(element);
    }
}

