/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.File;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.io.SAXReader;

public class EmbeddedHandlerTest
extends AbstractTestCase {
    private static final int MAIN_READER = 0;
    private static final int ON_END_READER = 1;
    protected String[] testDocuments = new String[]{"xml/test/FranzBeilMain.xml"};
    private StringBuffer[] results = new StringBuffer[]{new StringBuffer(), new StringBuffer()};
    protected int test;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.EmbeddedHandlerTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testMainReader() throws Exception {
        this.test = 0;
        this.readDocuments();
    }

    public void testOnEndReader() throws Exception {
        this.test = 1;
        this.readDocuments();
    }

    public void testBothReaders() throws Exception {
        this.testMainReader();
        this.testOnEndReader();
        if (!this.results[0].toString().equals(this.results[1].toString())) {
            StringBuffer msg = new StringBuffer();
            msg.append("Results of tests should be equal!\n");
            msg.append("Results testMainReader():\n" + this.results[0].toString());
            msg.append("Results testOnEndReader():\n" + this.results[1].toString());
            throw new Exception(msg.toString());
        }
    }

    private void readDocuments() throws Exception {
        int i = 0;
        while (i < this.testDocuments.length) {
            File testDoc = this.getFile(this.testDocuments[i]);
            String mainDir = testDoc.getParent();
            SAXReader reader = new SAXReader();
            MainHandler mainHandler = new MainHandler(mainDir);
            reader.addHandler("/main/import", mainHandler);
            this.getDocument(this.testDocuments[i], reader);
            ++i;
        }
    }

    public class EmbeddedHandler
    implements ElementHandler {
        public void onStart(ElementPath path) {
            EmbeddedHandlerTest.this.results[EmbeddedHandlerTest.this.test].append(String.valueOf(path.getCurrent().attribute("name").getValue()) + "\n");
        }

        public void onEnd(ElementPath path) {
        }
    }

    class MainHandler
    implements ElementHandler {
        private SAXReader mainReader = new SAXReader();
        private String mainDir;

        public MainHandler(String dir) {
            this.mainDir = dir;
            this.mainReader.addHandler("/import/stuff", new EmbeddedHandler());
        }

        public void onStart(ElementPath path) {
        }

        public void onEnd(ElementPath path) {
            String href = path.getCurrent().attribute("href").getValue();
            Element importRef = path.getCurrent();
            Element parentElement = importRef.getParent();
            SAXReader onEndReader = new SAXReader();
            onEndReader.addHandler("/import/stuff", new EmbeddedHandler());
            File file = new File(String.valueOf(this.mainDir) + File.separator + href);
            Element importElement = null;
            try {
                if (EmbeddedHandlerTest.this.test == 0) {
                    importElement = this.mainReader.read(file).getRootElement();
                } else if (EmbeddedHandlerTest.this.test == 1) {
                    importElement = onEndReader.read(file).getRootElement();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            importRef.detach();
            parentElement.add(importElement);
        }
    }
}

