/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class ParentTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.ParentTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testDocument() throws Exception {
        this.testParentRelationship(this.document.getRootElement());
    }

    public void testFragment() throws Exception {
        DocumentFactory factory = new DocumentFactory();
        Element root = factory.createElement("root");
        Element first = root.addElement("child");
        Element second = root.addElement("child");
        this.testXPathNode(root, first);
        this.testXPathNode(root, second);
    }

    protected void testParentRelationship(Element parent, List content) {
        Iterator iter = content.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof Element) {
                this.testParentRelationship((Element)object);
            }
            this.testXPathNode(parent, (Node)object);
        }
    }

    protected void testParentRelationship(Element element) {
        this.testParentRelationship(element, element.attributes());
        this.testParentRelationship(element, element.content());
    }

    protected void testXPathNode(Element parent, Node node) {
        if (node.supportsParent()) {
            this.log("Node: " + node);
            this.log("Parent: " + parent);
            this.log("getParent(): " + node.getParent());
            ParentTest.assertTrue((String)("getParent() returns parent for: " + node), (node.getParent() == parent ? 1 : 0) != 0);
        } else {
            Node xpathNode = node.asXPathResult(parent);
            ParentTest.assertTrue((String)("XPath Node supports parent for: " + xpathNode), (boolean)xpathNode.supportsParent());
            ParentTest.assertTrue((String)("getParent() returns parent for: " + xpathNode), (xpathNode.getParent() == parent ? 1 : 0) != 0);
        }
    }
}

