/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.util.UserDataAttribute;
import org.dom4j.util.UserDataDocumentFactory;
import org.dom4j.util.UserDataElement;

public class UserDataTest
extends AbstractTestCase {
    private static final String INPUT_XML_FILE = "/xml/web.xml";
    private Object userData = new Double(1.23456);
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.UserDataTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testSetData() throws Exception {
        Element root = this.getRootElement();
        UserDataTest.assertTrue((String)"Element instanceof UserDataElement", (boolean)(root instanceof UserDataElement));
        root.setData(this.userData);
        UserDataTest.assertTrue((String)"Stored user data!", (root.getData() == this.userData ? 1 : 0) != 0);
        this.log("root: " + root);
        this.assertUserData(root, this.userData);
        Element cloned = (Element)root.clone();
        UserDataTest.assertTrue((String)"Cloned new instance", (cloned != root ? 1 : 0) != 0);
        this.assertUserData(cloned, this.userData);
        cloned = root.createCopy();
        UserDataTest.assertTrue((String)"Cloned new instance", (cloned != root ? 1 : 0) != 0);
        this.assertUserData(cloned, this.userData);
    }

    public void testCloneAttribute() throws Exception {
        Element root = this.getRootElement();
        root.addAttribute("name", "value");
        Attribute attribute = root.attribute("name");
        UserDataTest.assertTrue((boolean)(attribute instanceof UserDataAttribute));
        Element cloned = (Element)root.clone();
        Attribute clonedAttribute = cloned.attribute("name");
        UserDataTest.assertTrue((boolean)(clonedAttribute instanceof UserDataAttribute));
    }

    public void testNewAdditions() throws Exception {
        Element root = this.getRootElement();
        Element newElement = root.addElement("foo1234");
        UserDataTest.assertTrue((String)"New Element is a UserDataElement", (boolean)(newElement instanceof UserDataElement));
        root.addAttribute("bar456", "123");
        Attribute newAttribute = root.attribute("bar456");
        UserDataTest.assertTrue((String)"New Attribute is a UserDataAttribute", (boolean)(newAttribute instanceof UserDataAttribute));
    }

    public void testNewDocument() throws Exception {
        DocumentFactory factory = UserDataDocumentFactory.getInstance();
        Document document = factory.createDocument();
        Element root = document.addElement("root");
        UserDataTest.assertTrue((String)"Root Element is a UserDataElement", (boolean)(root instanceof UserDataElement));
        Element newElement = root.addElement("foo1234");
        UserDataTest.assertTrue((String)"New Element is a UserDataElement", (boolean)(newElement instanceof UserDataElement));
        root.addAttribute("bar456", "123");
        Attribute newAttribute = root.attribute("bar456");
        UserDataTest.assertTrue((String)"New Attribute is a UserDataAttribute", (boolean)(newAttribute instanceof UserDataAttribute));
    }

    protected void assertUserData(Element root, Object data) throws Exception {
        Object result = root.getData();
        UserDataTest.assertTrue((String)"No user data!", (result != null ? 1 : 0) != 0);
        UserDataTest.assertTrue((String)"Stored user data correctly", (boolean)data.equals(result));
    }

    protected void setUp() throws Exception {
        super.setUp();
        SAXReader reader = new SAXReader();
        reader.setDocumentFactory(UserDataDocumentFactory.getInstance());
        this.document = this.getDocument(INPUT_XML_FILE, reader);
    }
}

