/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.swing;

import javax.swing.table.TableModel;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Document;
import org.dom4j.swing.XMLTableDefinition;
import org.dom4j.swing.XMLTableModel;

public class TableModelTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.swing.TableModelTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testServletTable() throws Exception {
        Document document = this.getDocument("/xml/web.xml");
        XMLTableDefinition tableDefinition = new XMLTableDefinition();
        tableDefinition.setRowExpression("/web-app/servlet");
        tableDefinition.addStringColumn("Name", "servlet-name");
        tableDefinition.addStringColumn("Class", "servlet-class");
        String mapping = "../servlet-mapping[servlet-name=$Name]/url-pattern";
        tableDefinition.addStringColumn("Mapping", mapping);
        XMLTableModel tableModel = new XMLTableModel(tableDefinition, (Object)document);
        TableModelTest.assertEquals((String)"correct row count", (int)tableModel.getRowCount(), (int)2);
        TableModelTest.assertEquals((String)"correct column count", (int)tableModel.getColumnCount(), (int)3);
        this.assertColumnNameEquals(tableModel, 0, "Name");
        this.assertColumnNameEquals(tableModel, 1, "Class");
        this.assertColumnNameEquals(tableModel, 2, "Mapping");
        this.assertCellEquals(tableModel, 0, 0, "snoop");
        this.assertCellEquals(tableModel, 1, 0, "file");
        this.assertCellEquals(tableModel, 0, 1, "SnoopServlet");
        this.assertCellEquals(tableModel, 1, 1, "ViewFile");
        this.assertCellEquals(tableModel, 0, 2, "/foo/snoop");
        this.assertCellEquals(tableModel, 1, 2, "");
    }

    public void testServletTableViaXMLDescription() throws Exception {
        Document definition = this.getDocument("/xml/swing/tableForWeb.xml");
        Document document = this.getDocument("/xml/web.xml");
        XMLTableModel tableModel = new XMLTableModel(definition, (Object)document);
        TableModelTest.assertEquals((String)"correct row count", (int)tableModel.getRowCount(), (int)2);
        TableModelTest.assertEquals((String)"correct column count", (int)tableModel.getColumnCount(), (int)3);
        this.assertColumnNameEquals(tableModel, 0, "Name");
        this.assertColumnNameEquals(tableModel, 1, "Class");
        this.assertColumnNameEquals(tableModel, 2, "Mapping");
        this.assertCellEquals(tableModel, 0, 0, "snoop");
        this.assertCellEquals(tableModel, 1, 0, "file");
        this.assertCellEquals(tableModel, 0, 1, "SnoopServlet");
        this.assertCellEquals(tableModel, 1, 1, "ViewFile");
        this.assertCellEquals(tableModel, 0, 2, "/foo/snoop");
        this.assertCellEquals(tableModel, 1, 2, "");
    }

    protected void assertColumnNameEquals(TableModel tableModel, int columnIndex, String name) {
        TableModelTest.assertEquals((String)("Column name correct for index: " + columnIndex), (String)name, (String)tableModel.getColumnName(columnIndex));
    }

    protected void assertCellEquals(TableModel tableModel, int rowIndex, int columnIndex, Object value) {
        TableModelTest.assertEquals((String)("Cell value at row: " + rowIndex + " col: " + columnIndex), (Object)value, (Object)tableModel.getValueAt(rowIndex, columnIndex));
    }
}

