/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.util.Iterator;
import java.util.List;
import junit.textui.TestRunner;
import org.dom4j.AbstractTestCase;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;

public class GetPathTest
extends AbstractTestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.dom4j.xpath.GetPathTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void testGetPath() throws Exception {
        this.log("Testing paths");
        this.testPath(this.document, "/");
        Element root = this.document.getRootElement();
        this.testPath(root, "/root");
        List elements = root.elements();
        this.testPath((Node)elements.get(0), "/root/author", "/root/author[1]");
        int i = 0;
        int size = elements.size();
        while (i < size) {
            String path = "/root/author";
            String uniquePath = "/root/author";
            String pathRel = "author";
            String uniquePathRel = "author";
            if (size > 1) {
                uniquePath = "/root/author[" + (i + 1) + "]";
                uniquePathRel = "author[" + (i + 1) + "]";
            }
            Element element = (Element)elements.get(i);
            this.testPath(element, path, uniquePath);
            this.testRelativePath(root, element, pathRel, uniquePathRel);
            Attribute attribute = element.attribute("name");
            this.testPath(attribute, String.valueOf(path) + "/@name", String.valueOf(uniquePath) + "/@name");
            this.testRelativePath(root, attribute, String.valueOf(pathRel) + "/@name", String.valueOf(uniquePathRel) + "/@name");
            Element child = element.element("url");
            this.testPath(child, String.valueOf(path) + "/url", String.valueOf(uniquePath) + "/url");
            this.testRelativePath(root, child, String.valueOf(pathRel) + "/url", String.valueOf(uniquePathRel) + "/url");
            ++i;
        }
    }

    public void testDefaultNamespace() throws Exception {
        Document doc = this.getDocument("/xml/test/defaultNamespace.xml");
        Element root = doc.getRootElement();
        this.testPath(root, "/*[name()='a']");
        Element child = (Element)root.elements().get(0);
        this.testPath(child, "/*[name()='a']/*[name()='b']");
        this.testRelativePath(root, child, "*[name()='b']");
    }

    public void testBug770410() {
        Document doc = DocumentHelper.createDocument();
        Element a = doc.addElement("a");
        Element b = a.addElement("b");
        Element c = b.addElement("c");
        b.detach();
        String relativePath = b.getPath(b);
        GetPathTest.assertSame((Object)b, (Object)b.selectSingleNode(relativePath));
    }

    public void testBug569927() {
        Document doc = DocumentHelper.createDocument();
        QName elName = DocumentFactory.getInstance().createQName("a", "ns", "uri://myuri");
        Element a = doc.addElement(elName);
        QName attName = DocumentFactory.getInstance().createQName("attribute", "ns", "uri://myuri");
        a = a.addAttribute(attName, "test");
        Attribute att = a.attribute(attName);
        GetPathTest.assertSame((Object)att, (Object)doc.selectSingleNode(att.getPath()));
        GetPathTest.assertSame((Object)att, (Object)doc.selectSingleNode(att.getUniquePath()));
    }

    protected void testPath(Node node, String value) {
        this.testPath(node, value, value);
    }

    protected void testPath(Node node, String path, String uniquePath) {
        GetPathTest.assertEquals((String)"getPath expression should be what is expected", (String)path, (String)node.getPath());
        GetPathTest.assertEquals((String)"getUniquePath expression should be what is expected", (String)uniquePath, (String)node.getUniquePath());
    }

    protected void testRelativePath(Element context, Node node, String path) {
        this.testRelativePath(context, node, path, path);
    }

    protected void testRelativePath(Element context, Node node, String pathRel, String uniquePathRel) {
        GetPathTest.assertEquals((String)"relative getPath expression should be what is expected", (String)pathRel, (String)node.getPath(context));
        GetPathTest.assertEquals((String)"relative getUniquePath expression not correct", (String)uniquePathRel, (String)node.getUniquePath(context));
    }

    protected void testBranchPath(Branch branch) {
        this.testNodePath(branch);
        if (branch instanceof Element) {
            Element element = (Element)branch;
            Iterator iter = element.attributeIterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                this.testNodePath(node);
            }
        }
        Iterator iter = branch.nodeIterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node instanceof Branch) {
                this.testBranchPath((Branch)node);
                continue;
            }
            this.testNodePath(node);
        }
    }

    protected void testNodePath(Node node) {
        String path = node.getPath();
        this.log("Path: " + path + " node: " + node);
    }
}

