/*
 * Copyright (C) 2010 Florian Maul & Jean Marie PASCAL
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.fmaul.android.cmis.model;

import java.io.Serializable;

public class Server implements Serializable{
	
	private static final long serialVersionUID = 1L;
	
	public static final String INFO_GENERAL = "serverInfoGeneral";
	public static final String INFO_CAPABILITIES = "serverInfoCapabilites";
	public static final String INFO_ACL_CAPABILITIES = "serverInfoACL";
	
	private long id;
    private String name;
    private String url;
	private String username;
	private String password;
	private String workspace;
	
	public Server(long id, String name, String url, String username, String password, String workspace) {
		super();
		this.id = id;
		this.name = name;
		this.url = url;
		this.username = username;
		this.password = password;
		this.workspace = workspace;
	}
	
	
	public Server() {
	}


	public String getUsername() {
		return username;
	}
	public void setUsername(String username) {
		this.username = username;
	}
	public String getPassword() {
		return password;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getName() {
		return name;
	}
	public void setWorkspace(String workspace) {
		this.workspace = workspace;
	}
	public String getWorkspace() {
		return workspace;
	}
}
