package de.k4ever.k4android.fragments;

import java.util.Map;

import android.graphics.Bitmap;
import android.support.v4.app.Fragment;
import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.JsonObjectRequest;
import de.k4ever.k4android.utils.KassenHttpUtils;
import org.json.JSONException;
import org.json.JSONObject;

import android.app.ProgressDialog;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;
import de.k4ever.k4android.BuyScreenActivity;
import de.k4ever.k4android.R;
import de.k4ever.k4android.database.KassenContentProvider;
import de.k4ever.k4android.database.KassenSQLiteHelper;
import de.k4ever.k4android.database.KassenSQLiteHelper.Products;
import de.k4ever.k4android.utils.KassenConfig;

public class BuyScreenFragment extends Fragment
implements SeekBar.OnSeekBarChangeListener, OnItemSelectedListener {
	private int mItemID, mMultiplier;
	private TextView mPrice, mDeposit, mNumItems, mDescText, mName;
	private double mPriceVal, mDepositVal;
	private ImageView mProductImage;
	private ImageLoader mImageLoader;
	private Button mBuy;
	private SeekBar mSeekBar;
	private ProgressBar mProgressBar;
	private Spinner mDepositChooser;
	private View mContainer;
	private Boolean mFavorite;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		View view = inflater.inflate(R.layout.layout_buyscreen, container, false);
		mContainer = view.findViewById(R.id.buyscreenLayout);
		mProductImage = (ImageView) view.findViewById(R.id.productImage);
		mImageLoader = KassenHttpUtils.getInstance(getActivity()).getImageLoader();

		mSeekBar = (SeekBar) view.findViewById(R.id.amount);
		mSeekBar.setOnSeekBarChangeListener(this);
		mDeposit = (TextView)view.findViewById(R.id.deposit);
		mPrice = (TextView)view.findViewById(R.id.price);
		mNumItems = (TextView)view.findViewById(R.id.num);
		mBuy = (Button)view.findViewById(R.id.buy);
		mDescText = (TextView)view.findViewById(R.id.description);
		mProgressBar = (ProgressBar)view.findViewById(R.id.progressBar1);
		mDepositChooser = (Spinner)view.findViewById(R.id.deposit_chooser);
		mName = (TextView)view.findViewById(R.id.name);
		mFavorite = false;

		ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(getActivity(),
				R.array.deposit_chooser, android.R.layout.simple_spinner_item);
		adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		mDepositChooser.setAdapter(adapter);
		mDepositChooser.setOnItemSelectedListener(this);

		mBuy.setEnabled(false);
		mBuy.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				buy();
			}
		});
		mContainer.setVisibility(View.INVISIBLE);
		setHasOptionsMenu(true);

		return view;
	}

	@Override
	public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
		inflater.inflate(R.menu.buy_menu, menu);
		if(mFavorite)
            menu.findItem(R.id.menu_favorite).setIcon(
                    getResources().getDrawable(R.drawable.ic_action_favorite_checked));

        if (!mBuy.isEnabled())
                menu.findItem(R.id.menu_favorite).setVisible(false);
	}

	@Override
	public boolean onOptionsItemSelected(final MenuItem item) {
		switch(item.getItemId()) {
		case R.id.menu_favorite:

			mFavorite = !mFavorite;
			final ContentValues favorite = new ContentValues(1);
			favorite.put(KassenSQLiteHelper.Products.COLUMN_FAVORITE, (mFavorite ? 1 : 0));
			getActivity().getContentResolver().update(
					Uri.withAppendedPath(KassenContentProvider.CONTENT_PRODUCTS, "/"+mItemID),
					favorite, null, null);
			getActivity().getContentResolver().notifyChange(KassenContentProvider.CONTENT_PRODUCTS, null);
			getActivity().invalidateOptionsMenu();

			break;
		}
		return super.onOptionsItemSelected(item);
	}


	private void buy() {
		final ProgressDialog dialog = ProgressDialog.show(getActivity(), "",
				getString(R.string.please_wait), true);
		String url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_BUYABLE + mItemID, getActivity());
		JsonObjectRequest request = new JsonObjectRequest(
				Request.Method.POST,
				url,
				null,
				new Response.Listener<JSONObject>() {
					@Override
					public void onResponse(JSONObject kassenObj) {
						dialog.dismiss();

						try {
							if (kassenObj != null && kassenObj.getBoolean("success")) {
								Toast.makeText(getActivity(), getString(R.string.buy_sucess), Toast.LENGTH_LONG).show();
							}
							else {
								// JSON in error case not implemented in api
								Toast.makeText(getActivity(), getString(R.string.buy_fail), Toast.LENGTH_LONG).show();
							}
						} catch (JSONException e) {
							// no JSON result: error
							Toast.makeText(getActivity(), getString(R.string.buy_fail), Toast.LENGTH_LONG).show();
						}
                        if(getActivity() instanceof BuyScreenActivity)
						    getActivity().finish();
					}
				},
				new Response.ErrorListener() {
					@Override
					public void onErrorResponse(VolleyError volleyError) {
						dialog.dismiss();
						Log.e("Volley", "Error: " + volleyError.toString());

						Toast.makeText(getActivity(), getString(R.string.buy_fail), Toast.LENGTH_LONG).show();
					}
				}
		) {
			@Override
			public Map<String, String> getHeaders() throws AuthFailureError {
				Map<String, String> map =  KassenHttpUtils
						.getAuthHeader(getActivity());
				map.put("amount", String.valueOf(mSeekBar.getProgress()+1));
				map.put("deposit", ""+mDepositChooser.getSelectedItemPosition());
				return map;
			}
		};

		KassenHttpUtils.getInstance(getActivity()).addToRequestQueue(request);
	}


	public void showProdukt(Cursor cursor) {
		mContainer.setVisibility(View.VISIBLE);
		final int id = cursor.getInt(cursor.getColumnIndex(Products.COLUMN_ID));
		final String img = cursor.getString(cursor.getColumnIndex(Products.COLUMN_IMAGE));
		final String name = cursor.getString(cursor.getColumnIndex(Products.COLUMN_NAME));
		final Double price = cursor.getDouble(cursor.getColumnIndex(Products.COLUMN_PRICE));
		final Double deposit = cursor.getDouble(cursor.getColumnIndex(Products.COLUMN_DEPOSIT));
		final String description = cursor.getString(cursor.getColumnIndex(Products.COLUMN_DESCRIPTION));
		final int favorite = cursor.getInt(cursor.getColumnIndex(Products.COLUMN_FAVORITE));

		mImageLoader.get(KassenHttpUtils.getMediaURL(getActivity()) + img, new ImageLoader.ImageListener() {
			@Override
			public void onErrorResponse(VolleyError volleyError) {
				Toast.makeText(getActivity(), volleyError.getLocalizedMessage(),Toast.LENGTH_LONG).show();
			}

			@Override
			public void onResponse(ImageLoader.ImageContainer response, boolean isImmediate) {
				if (response != null) {
					Bitmap bitmap = response.getBitmap();
					if (bitmap != null) {
						mProgressBar.setVisibility(View.GONE);
						mProductImage.setImageBitmap(bitmap);
					}

				}
			}
		});

        mFavorite = favorite > 0;
		mPriceVal = price;
		mDepositVal = deposit;
		mMultiplier = 1;
		mItemID = id;

        mDepositChooser.setVisibility(deposit == 0 ? View.INVISIBLE: View.VISIBLE);
        mDeposit.setVisibility(deposit == 0 ? View.INVISIBLE : View.VISIBLE);

		updateText();
		mDescText.setText(description);
		if(getActivity() instanceof BuyScreenActivity) {
            getActivity().getActionBar().setTitle(name);
        }
		else {
            mName.setText(name);
        }
		mBuy.setEnabled(true);
        getActivity().invalidateOptionsMenu();
	}

	@Override
	public void onProgressChanged(SeekBar seekBar, int progress,
			boolean fromUser) {
		mMultiplier = ++progress;
		updateText();
	}

	private void updateText() {
		double price;

		mNumItems.setText(mMultiplier+"x");

		switch(mDepositChooser.getSelectedItemPosition()) {
		case 0:
			price = mPriceVal * mMultiplier;
			break;
		case 1:
			price = mDepositVal * mMultiplier;
			break;
		case 2:
			price = (mPriceVal + mDepositVal) * mMultiplier;
			break;
		default:
			price = mPriceVal * mMultiplier;
		}

		mPrice.setText(String.format(getString(R.string.currency_format), price));
		mDeposit.setText(String.format(getString(R.string.deposit_format), mDepositVal * mMultiplier));
	}

	@Override
	public void onStartTrackingTouch(SeekBar seekBar) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onStopTrackingTouch(SeekBar seekBar) {
		// TODO Auto-generated method stub

	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	@Override
	public void onItemSelected(AdapterView<?> parent, View view, 
			int pos, long id) {
		updateText();
	}

	@Override
	public void onNothingSelected(AdapterView<?> arg0) {
	}

}
