package de.kromonos.android.rpcoiner;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.http.HttpHost;
import org.json.JSONArray;
import org.json.JSONObject;

import android.preference.PreferenceManager;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;


public class RPCoinerActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences(this);
        String server = settings.getString("rpchost", null);
    	String rpcuser = settings.getString("username", null);
    	String rpcpasswd = settings.getString("password", null);
    	
    	if( (server != null) && (rpcuser != null) && (rpcpasswd != null) ) {
    		final ImageButton button = (ImageButton) findViewById(R.id.btn_getbalance);
    		button.setEnabled(true);
    	}
    	else {
    		final ImageButton button = (ImageButton) findViewById(R.id.btn_getbalance);
    		button.setEnabled(false);
    		String no_credits = getString(R.string.no_credits);
    		Toast.makeText(RPCoinerActivity.this, no_credits,
			Toast.LENGTH_LONG).show();
    	}
    
    }
    
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.mainmenu, menu);
		return true;
	}
	
	public void btn_getBalance_click(View view) {
		run_action(view);
	}

    @Override
    protected void onResume() {
        super.onResume();
    }	
	
	public void run_action(View view) {
		String server = null;
		String rpcuser = null;
		String rpcpasswd = null;
		int port = 8332;
		int timeout = 20000;
		Boolean use_ssl = false;
		double balance = 0;
		String use_https = null;
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences(this);
        Log.d("RPClient", "fooooo.bar");
    	server = settings.getString("rpchost", "bka.li");
    	rpcuser = settings.getString("username", "null");
    	rpcpasswd = settings.getString("password", "null");
//      	port = settings.getInt("rpcport", 8332);
//       	timeout = settings.getInt("timeout", 2000);
//       	use_ssl = settings.getInt("usessl", 0);
//    	port = 8332;
    	port = Integer.parseInt(settings.getString("rpcport", null));
    	timeout = Integer.parseInt(settings.getString("timeout", null));
    	use_ssl = settings.getBoolean("usessl", false);

    	Log.d("RPClient", "SSL: " + use_ssl);
    	if( use_ssl == false ) {
    		use_https = "http";
    	}
    	else {
    		use_https = "https";
    	}
    	
		switch (view.getId()) {
		case R.id.btn_getbalance:
			HttpHost host = new HttpHost(server, port, use_https);
	    	Log.d("RPClient", "Creating connection");
			JSONRPCClient client = JSONRPCClient.create(host, "/", rpcuser.trim(), rpcpasswd);
	    	Log.d("RPClient", "Connection: " + client.toString());
			client.setConnectionTimeout(timeout);
			client.setSoTimeout(timeout);

			TableLayout table = (TableLayout) findViewById(R.id.transactions);
			TextView balanceText = (TextView)findViewById(R.id.txt_balance);
			table.removeViewsInLayout(0, table.getChildCount());
			
			String[] params = {};

			try {
				Log.d("RPClient", "Trying to get balance");
				String out = client.callString("getinfo", (Object[]) params);
				org.json.JSONObject object = new JSONObject(out);
				balance = object.getDouble("balance");

				String out1 = client.callString("listtransactions", (Object[]) params);
				JSONArray jArray = new JSONArray(out1);
				Log.d("RPClient", jArray.toString());
		        for(int i=0;i<jArray.length();i++){
	                JSONObject json_data = jArray.getJSONObject(i);
		        	TableRow tr = new TableRow(this);
		        	double amount = json_data.getDouble("amount");
		        	String address = json_data.getString("address");
		        	long time = json_data.getLong("time");
		        	Date _date = new Date((long)time*1000);

		        	SimpleDateFormat date = new SimpleDateFormat("dd.MM.yyyy HH:mm");
		        	String date_form = date.format(_date);

		        	Log.d("RPCLient", "Date: " + date_form );
		            
		            tr.setId(100+i);
		            tr.setLayoutParams(new LayoutParams(
		                    LayoutParams.FILL_PARENT,
		                    LayoutParams.WRAP_CONTENT));   

		            TextView txt_date = new TextView(this);
		        	txt_date.setId(50+i);
		        	txt_date.setText( date_form  + ": " );
		            tr.addView(txt_date);

		            TextView txt_amount = new TextView(this);
		            txt_amount.setId(200+i);
		            txt_amount.setText( amount + "BTC" );
		            Log.d("RPClient", amount + " BTC" );
		            if( json_data.getDouble("amount") > 0 ) {
		            	txt_amount.setTextColor(Color.GREEN);
		            }
		            else {
		            	txt_amount.setTextColor(Color.RED);
		            }
		            tr.addView(txt_amount);		            

		            TextView txt_txid = new TextView(this);
		            txt_txid.setId(i);
		            txt_txid.setText( address );
		            tr.addView(txt_txid);

		            // Add the TableRow to the TableLayout
		            table.addView(tr, new TableLayout.LayoutParams(
		                    LayoutParams.FILL_PARENT,
		                    LayoutParams.WRAP_CONTENT));		            
		        }				
				Log.d("RPClient", out);
			}
			catch (JSONRPCException e) {
				Log.e("RPCoiner", "JSON BalFailed: " + e.toString());
			}
			catch (Exception e) {
				Log.e("RPCoiner", "BalFailed: " + e.toString());
			}

			if( balance > 0 ) {
				balanceText.setTextColor(Color.GREEN);
			}
			balanceText.setText( balance + " BTC");
		}
	}
	
	private void toggleProgressBar() {
        ProgressBar PRGbar = (ProgressBar)findViewById(R.id.prg_Bar);
		switch (PRGbar.getVisibility()) {
	    case View.GONE:
	    	PRGbar.setVisibility(View.VISIBLE);
	        break;
	    default:
	    	PRGbar.setVisibility(View.GONE);
	        break;
	    }
	}	
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		// We have only one menu option
		case R.id.preferences:
			// Launch Preference activity
			Intent i = new Intent(RPCoinerActivity.this, MyPreferencesActivity.class);
			startActivity(i);
			// Some feedback to the user
			break;
		case R.id.men_exit:
	        Log.d("RPClient","Exit");
			finish();
			break;
		}
		return true;
	}	
	
}