'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _getChildEventSubscriber = require('./getChildEventSubscriber');

var _getChildEventSubscriber2 = _interopRequireDefault(_getChildEventSubscriber);

var _getChildRouter = require('./getChildRouter');

var _getChildRouter2 = _interopRequireDefault(_getChildRouter);

var _getNavigationActionCreators = require('./routers/getNavigationActionCreators');

var _getNavigationActionCreators2 = _interopRequireDefault(_getNavigationActionCreators);

var _getChildrenNavigationCache = require('./getChildrenNavigationCache');

var _getChildrenNavigationCache2 = _interopRequireDefault(_getChildrenNavigationCache);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var createParamGetter = route => (paramName, defaultValue) => {
  var params = route.params;

  if (params && paramName in params) {
    return params[paramName];
  }

  return defaultValue;
};

function getChildNavigation(navigation, childKey, getCurrentParentNavigation) {
  var children = (0, _getChildrenNavigationCache2.default)(navigation);
  var childRoute = navigation.state.routes.find(r => r.key === childKey);

  if (!childRoute) {
    return null;
  }

  if (children[childKey] && children[childKey].state === childRoute) {
    return children[childKey];
  }

  var childRouter = (0, _getChildRouter2.default)(navigation.router, childRoute.routeName);

  // If the route has children, we'll use this to pass in to the action creators
  // for the childRouter so that any action that depends on the active route will
  // behave as expected. We don't explicitly require that routers implement routes
  // and index properties, but if we did then we would put an invariant here to
  // ensure that a focusedGrandChildRoute exists if childRouter is defined.
  var focusedGrandChildRoute = childRoute.routes && typeof childRoute.index === 'number' ? childRoute.routes[childRoute.index] : null;

  var actionCreators = _extends({}, navigation.actions, navigation.router.getActionCreators(childRoute, navigation.state.key), childRouter ? childRouter.getActionCreators(focusedGrandChildRoute, childRoute.key) : {}, (0, _getNavigationActionCreators2.default)(childRoute));

  var actionHelpers = {};
  Object.keys(actionCreators).forEach(actionName => {
    actionHelpers[actionName] = (...args) => {
      var actionCreator = actionCreators[actionName];
      var action = actionCreator(...args);
      return navigation.dispatch(action);
    };
  });

  if (children[childKey]) {
    children[childKey] = _extends({}, children[childKey], actionHelpers, {
      state: childRoute,
      router: childRouter,
      actions: actionCreators,
      getParam: createParamGetter(childRoute)
    });
    return children[childKey];
  } else {
    var childSubscriber = (0, _getChildEventSubscriber2.default)(navigation.addListener, childKey);

    children[childKey] = _extends({}, actionHelpers, {

      state: childRoute,
      router: childRouter,
      actions: actionCreators,
      getParam: createParamGetter(childRoute),

      getChildNavigation: grandChildKey => getChildNavigation(children[childKey], grandChildKey, () => {
        var nav = getCurrentParentNavigation();
        return nav && nav.getChildNavigation(childKey);
      }),

      isFocused: () => {
        var currentNavigation = getCurrentParentNavigation();
        if (!currentNavigation) {
          return false;
        }
        var { routes, index } = currentNavigation.state;
        if (!currentNavigation.isFocused()) {
          return false;
        }
        if (routes[index].key === childKey) {
          return true;
        }
        return false;
      },
      dispatch: navigation.dispatch,
      getScreenProps: navigation.getScreenProps,
      dangerouslyGetParent: getCurrentParentNavigation,
      addListener: childSubscriber.addListener,
      emit: childSubscriber.emit
    });
    return children[childKey];
  }
}

exports.default = getChildNavigation;