'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _NavigationActions = require('../NavigationActions');

var _NavigationActions2 = _interopRequireDefault(_NavigationActions);

var _StackActions = require('./StackActions');

var _StackActions2 = _interopRequireDefault(_StackActions);

var _createConfigGetter = require('./createConfigGetter');

var _createConfigGetter2 = _interopRequireDefault(_createConfigGetter);

var _getScreenForRouteName = require('./getScreenForRouteName');

var _getScreenForRouteName2 = _interopRequireDefault(_getScreenForRouteName);

var _StateUtils = require('../StateUtils');

var _StateUtils2 = _interopRequireDefault(_StateUtils);

var _validateRouteConfigMap = require('./validateRouteConfigMap');

var _validateRouteConfigMap2 = _interopRequireDefault(_validateRouteConfigMap);

var _invariant = require('../utils/invariant');

var _invariant2 = _interopRequireDefault(_invariant);

var _KeyGenerator = require('./KeyGenerator');

var _pathUtils = require('./pathUtils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function behavesLikePushAction(action) {
  return action.type === _NavigationActions2.default.NAVIGATE || action.type === _StackActions2.default.PUSH;
}

var defaultActionCreators = () => ({});

function isResetToRootStack(action) {
  return action.type === _StackActions2.default.RESET && action.key === null;
}

exports.default = (routeConfigs, stackConfig = {}) => {
  // Fail fast on invalid route definitions
  (0, _validateRouteConfigMap2.default)(routeConfigs);

  var childRouters = {};
  var routeNames = Object.keys(routeConfigs);

  // Loop through routes and find child routers
  routeNames.forEach(routeName => {
    var screen = (0, _getScreenForRouteName2.default)(routeConfigs, routeName);
    if (screen && screen.router) {
      // If it has a router it's a navigator.
      childRouters[routeName] = screen.router;
    } else {
      // If it doesn't have router it's an ordinary React component.
      childRouters[routeName] = null;
    }
  });

  var { initialRouteParams } = stackConfig;
  var getCustomActionCreators = stackConfig.getCustomActionCreators || defaultActionCreators;

  var initialRouteName = stackConfig.initialRouteName || routeNames[0];

  var initialChildRouter = childRouters[initialRouteName];

  function getInitialState(action) {
    var route = {};
    var childRouter = childRouters[action.routeName];

    // This is a push-like action, and childRouter will be a router or null if we are responsible for this routeName
    if (behavesLikePushAction(action) && childRouter !== undefined) {
      var childState = {};
      // The router is null for normal leaf routes
      if (childRouter !== null) {
        var childAction = action.action || _NavigationActions2.default.init({ params: action.params });
        childState = childRouter.getStateForAction(childAction);
      }

      return {
        key: 'StackRouterRoot',
        isTransitioning: false,
        index: 0,
        routes: [_extends({
          params: action.params
        }, childState, {
          key: action.key || (0, _KeyGenerator.generateKey)(),
          routeName: action.routeName
        })]
      };
    }

    if (initialChildRouter) {
      route = initialChildRouter.getStateForAction(_NavigationActions2.default.navigate({
        routeName: initialRouteName,
        params: initialRouteParams
      }));
    }
    var params = (routeConfigs[initialRouteName].params || route.params || action.params || initialRouteParams) && _extends({}, routeConfigs[initialRouteName].params || {}, route.params || {}, action.params || {}, initialRouteParams || {});
    var { initialRouteKey } = stackConfig;
    route = _extends({}, route, params ? { params } : {}, {
      routeName: initialRouteName,
      key: action.key || initialRouteKey || (0, _KeyGenerator.generateKey)()
    });
    return {
      key: 'StackRouterRoot',
      isTransitioning: false,
      index: 0,
      routes: [route]
    };
  }

  function getParamsForRouteAndAction(routeName, action) {
    var routeConfig = routeConfigs[routeName];
    if (routeConfig && routeConfig.params) {
      return _extends({}, routeConfig.params, action.params);
    } else {
      return action.params;
    }
  }

  var {
    getPathAndParamsForRoute,
    getActionForPathAndParams
  } = (0, _pathUtils.createPathParser)(childRouters, routeConfigs, stackConfig);

  return {
    childRouters,

    getComponentForState(state) {
      var activeChildRoute = state.routes[state.index];
      var { routeName } = activeChildRoute;
      if (childRouters[routeName]) {
        return childRouters[routeName].getComponentForState(activeChildRoute);
      }
      return (0, _getScreenForRouteName2.default)(routeConfigs, routeName);
    },

    getComponentForRouteName(routeName) {
      return (0, _getScreenForRouteName2.default)(routeConfigs, routeName);
    },

    getActionCreators(route, navStateKey) {
      return _extends({}, getCustomActionCreators(route, navStateKey), {
        pop: (n, params) => _StackActions2.default.pop(_extends({
          n
        }, params)),
        popToTop: params => _StackActions2.default.popToTop(params),
        push: (routeName, params, action) => _StackActions2.default.push({
          routeName,
          params,
          action
        }),
        replace: (replaceWith, params, action, newKey) => {
          if (typeof replaceWith === 'string') {
            return _StackActions2.default.replace({
              routeName: replaceWith,
              params,
              action,
              key: route.key,
              newKey
            });
          }
          (0, _invariant2.default)(typeof replaceWith === 'object', 'Must replaceWith an object or a string');
          (0, _invariant2.default)(params == null, 'Params must not be provided to .replace() when specifying an object');
          (0, _invariant2.default)(action == null, 'Child action must not be provided to .replace() when specifying an object');
          (0, _invariant2.default)(newKey == null, 'Child action must not be provided to .replace() when specifying an object');
          return _StackActions2.default.replace(replaceWith);
        },
        reset: (actions, index) => _StackActions2.default.reset({
          actions,
          index: index == null ? actions.length - 1 : index,
          key: navStateKey
        }),
        dismiss: () => _NavigationActions2.default.back({
          key: navStateKey
        })
      });
    },

    getStateForAction(action, state) {
      // Set up the initial state if needed
      if (!state) {
        return getInitialState(action);
      }

      var activeChildRoute = state.routes[state.index];

      if (!isResetToRootStack(action) && action.type !== _NavigationActions2.default.NAVIGATE) {
        // Let the active child router handle the action
        var activeChildRouter = childRouters[activeChildRoute.routeName];
        if (activeChildRouter) {
          var route = activeChildRouter.getStateForAction(action, activeChildRoute);
          if (route !== null && route !== activeChildRoute) {
            return _StateUtils2.default.replaceAt(state, activeChildRoute.key, route,
            // the following tells replaceAt to NOT change the index to this route for the setParam action, because people don't expect param-setting actions to switch the active route
            action.type === _NavigationActions2.default.SET_PARAMS);
          }
        }
      } else if (action.type === _NavigationActions2.default.NAVIGATE) {
        // Traverse routes from the top of the stack to the bottom, so the
        // active route has the first opportunity, then the one before it, etc.

        for (var childRoute of state.routes.slice().reverse()) {
          var childRouter = childRouters[childRoute.routeName];
          var childAction = action.routeName === childRoute.routeName && action.action ? action.action : action;

          if (childRouter) {
            var nextRouteState = childRouter.getStateForAction(childAction, childRoute);

            if (nextRouteState === null || nextRouteState !== childRoute) {
              var newState = _StateUtils2.default.replaceAndPrune(state, nextRouteState ? nextRouteState.key : childRoute.key, nextRouteState ? nextRouteState : childRoute);
              return _extends({}, newState, {
                isTransitioning: state.index !== newState.index ? action.immediate !== true : state.isTransitioning
              });
            }
          }
        }
      }

      // Handle push and navigate actions. This must happen after the focused
      // child router has had a chance to handle the action.
      if (behavesLikePushAction(action) && childRouters[action.routeName] !== undefined // undefined means it's not a childRouter or a screen
      ) {
          var _childRouter = childRouters[action.routeName];
          var _route = void 0;

          (0, _invariant2.default)(action.type !== _StackActions2.default.PUSH || action.key == null, 'StackRouter does not support key on the push action');

          // Before pushing a new route we first try to find one in the existing route stack
          // More information on this: https://github.com/react-navigation/rfcs/blob/master/text/0004-less-pushy-navigate.md
          var lastRouteIndex = state.routes.findIndex(r => {
            if (action.key) {
              return r.key === action.key;
            } else {
              return r.routeName === action.routeName;
            }
          });

          // An instance of this route exists already and we're dealing with a navigate action
          if (action.type !== _StackActions2.default.PUSH && lastRouteIndex !== -1) {
            // If index is unchanged and params are not being set, leave state identity intact
            if (state.index === lastRouteIndex && !action.params) {
              return null;
            }

            // Remove the now unused routes at the tail of the routes array
            var routes = state.routes.slice(0, lastRouteIndex + 1);

            // Apply params if provided, otherwise leave route identity intact
            if (action.params) {
              var _route2 = state.routes[lastRouteIndex];
              routes[lastRouteIndex] = _extends({}, _route2, {
                params: _extends({}, _route2.params, action.params)
              });
            }
            // Return state with new index. Change isTransitioning only if index has changed
            return _extends({}, state, {
              isTransitioning: state.index !== lastRouteIndex ? action.immediate !== true : state.isTransitioning,
              index: lastRouteIndex,
              routes
            });
          }

          if (_childRouter) {
            // Delegate to the child router with the given action, or init it
            var _childAction = action.action || _NavigationActions2.default.init({
              params: getParamsForRouteAndAction(action.routeName, action)
            });
            _route = _extends({
              params: getParamsForRouteAndAction(action.routeName, action)
            }, _childRouter.getStateForAction(_childAction), {
              routeName: action.routeName,
              key: action.key || (0, _KeyGenerator.generateKey)()
            });
          } else {
            // Create the route from scratch
            _route = {
              params: getParamsForRouteAndAction(action.routeName, action),
              routeName: action.routeName,
              key: action.key || (0, _KeyGenerator.generateKey)()
            };
          }
          return _extends({}, _StateUtils2.default.push(state, _route), {
            isTransitioning: action.immediate !== true
          });
        } else if (action.type === _StackActions2.default.PUSH && childRouters[action.routeName] === undefined) {
        // Return the state identity to bubble the action up
        return state;
      }

      // Handle navigation to other child routers that are not yet pushed
      if (behavesLikePushAction(action)) {
        var childRouterNames = Object.keys(childRouters);
        for (var i = 0; i < childRouterNames.length; i++) {
          var childRouterName = childRouterNames[i];
          var _childRouter2 = childRouters[childRouterName];
          if (_childRouter2) {
            // For each child router, start with a blank state
            var initChildRoute = _childRouter2.getStateForAction(_NavigationActions2.default.init());
            // Then check to see if the router handles our navigate action
            var navigatedChildRoute = _childRouter2.getStateForAction(action, initChildRoute);
            var routeToPush = null;
            if (navigatedChildRoute === null) {
              // Push the route if the router has 'handled' the action and returned null
              routeToPush = initChildRoute;
            } else if (navigatedChildRoute !== initChildRoute) {
              // Push the route if the state has changed in response to this navigation
              routeToPush = navigatedChildRoute;
            }
            if (routeToPush) {
              var _route3 = _extends({}, routeToPush, {
                routeName: childRouterName,
                key: action.key || (0, _KeyGenerator.generateKey)()
              });
              return _extends({}, _StateUtils2.default.push(state, _route3), {
                isTransitioning: action.immediate !== true
              });
            }
          }
        }
      }

      // Handle pop-to-top behavior. Make sure this happens after children have had a chance to handle the action, so that the inner stack pops to top first.
      if (action.type === _StackActions2.default.POP_TO_TOP) {
        // Refuse to handle pop to top if a key is given that doesn't correspond
        // to this router
        if (action.key && state.key !== action.key) {
          return state;
        }

        // If we're already at the top, then we return the state with a new
        // identity so that the action is handled by this router.
        if (state.index > 0) {
          return _extends({}, state, {
            isTransitioning: action.immediate !== true,
            index: 0,
            routes: [state.routes[0]]
          });
        }
        return state;
      }

      // Handle replace action
      if (action.type === _StackActions2.default.REPLACE) {
        var routeIndex = void 0;

        // If the key param is undefined, set the index to the last route in the stack
        if (action.key === undefined && state.routes.length) {
          routeIndex = state.routes.length - 1;
        } else {
          routeIndex = state.routes.findIndex(r => r.key === action.key);
        }

        // Only replace if the key matches one of our routes
        if (routeIndex !== -1) {
          var _childRouter3 = childRouters[action.routeName];
          var childState = {};
          if (_childRouter3) {
            var _childAction2 = action.action || _NavigationActions2.default.init({
              params: getParamsForRouteAndAction(action.routeName, action)
            });
            childState = _childRouter3.getStateForAction(_childAction2);
          }
          var _routes = [...state.routes];
          _routes[routeIndex] = _extends({
            params: getParamsForRouteAndAction(action.routeName, action)
          }, childState, {
            routeName: action.routeName,
            key: action.newKey || (0, _KeyGenerator.generateKey)()
          });
          return _extends({}, state, { routes: _routes });
        }
      }

      // Update transitioning state
      if (action.type === _StackActions2.default.COMPLETE_TRANSITION && (action.key == null || action.key === state.key) && action.toChildKey === state.routes[state.index].key && state.isTransitioning) {
        return _extends({}, state, {
          isTransitioning: false
        });
      }

      if (action.type === _NavigationActions2.default.SET_PARAMS) {
        var key = action.key;
        var lastRoute = state.routes.find(route => route.key === key);
        if (lastRoute) {
          var params = _extends({}, lastRoute.params, action.params);
          var _routes2 = [...state.routes];
          _routes2[state.routes.indexOf(lastRoute)] = _extends({}, lastRoute, {
            params
          });
          return _extends({}, state, {
            routes: _routes2
          });
        }
      }

      if (action.type === _StackActions2.default.RESET) {
        // Only handle reset actions that are unspecified or match this state key
        if (action.key != null && action.key != state.key) {
          // Deliberately use != instead of !== so we can match null with
          // undefined on either the state or the action
          return state;
        }
        var newStackActions = action.actions;

        return _extends({}, state, {
          routes: newStackActions.map(newStackAction => {
            var router = childRouters[newStackAction.routeName];

            var childState = {};

            if (router) {
              var _childAction3 = newStackAction.action || _NavigationActions2.default.init({
                params: getParamsForRouteAndAction(newStackAction.routeName, newStackAction)
              });

              childState = router.getStateForAction(_childAction3);
            }

            return _extends({
              params: getParamsForRouteAndAction(newStackAction.routeName, newStackAction)
            }, childState, {
              routeName: newStackAction.routeName,
              key: newStackAction.key || (0, _KeyGenerator.generateKey)()
            });
          }),
          index: action.index
        });
      }

      if (action.type === _NavigationActions2.default.BACK || action.type === _StackActions2.default.POP) {
        var { key: _key, n, immediate } = action;
        var backRouteIndex = state.index;
        if (action.type === _StackActions2.default.POP && n != null) {
          // determine the index to go back *from*. In this case, n=1 means to go
          // back from state.index, as if it were a normal "BACK" action
          backRouteIndex = Math.max(1, state.index - n + 1);
        } else if (_key) {
          var backRoute = state.routes.find(route => route.key === _key);
          backRouteIndex = state.routes.indexOf(backRoute);
        }

        if (backRouteIndex > 0) {
          return _extends({}, state, {
            routes: state.routes.slice(0, backRouteIndex),
            index: backRouteIndex - 1,
            isTransitioning: immediate !== true
          });
        }
      }

      // By this point in the router's state handling logic, we have handled the behavior of the active route, and handled any stack actions.
      // If we haven't returned by now, we should allow non-active child routers to handle this action, and switch to that index if the child state (route) does change..

      var keyIndex = action.key ? _StateUtils2.default.indexOf(state, action.key) : -1;

      // Traverse routes from the top of the stack to the bottom, so the
      // active route has the first opportunity, then the one before it, etc.
      for (var _childRoute of state.routes.slice().reverse()) {
        if (_childRoute.key === activeChildRoute.key) {
          // skip over the active child because we let it attempt to handle the action earlier
          continue;
        }
        // If a key is provided and in routes state then let's use that
        // knowledge to skip extra getStateForAction calls on other child
        // routers
        if (keyIndex >= 0 && _childRoute.key !== action.key) {
          continue;
        }
        var _childRouter4 = childRouters[_childRoute.routeName];
        if (_childRouter4) {
          var _route4 = _childRouter4.getStateForAction(action, _childRoute);

          if (_route4 === null) {
            return state;
          } else if (_route4 && _route4 !== _childRoute) {
            return _StateUtils2.default.replaceAt(state, _childRoute.key, _route4,
            // the following tells replaceAt to NOT change the index to this route for the setParam action or complete transition action,
            // because people don't expect these actions to switch the active route
            action.type === _NavigationActions2.default.SET_PARAMS || action.type === _StackActions2.default.COMPLETE_TRANSITION || action.type.includes('DRAWER'));
          }
        }
      }

      return state;
    },

    getPathAndParamsForState(state) {
      var route = state.routes[state.index];
      return getPathAndParamsForRoute(route);
    },

    getActionForPathAndParams(path, params) {
      return getActionForPathAndParams(path, params);
    },

    getScreenOptions: (0, _createConfigGetter2.default)(routeConfigs, stackConfig.defaultNavigationOptions)
  };
};