'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _NavigationActions = require('../NavigationActions');

var _NavigationActions2 = _interopRequireDefault(_NavigationActions);

var _invariant = require('../utils/invariant');

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getNavigationActionCreators = route => {
  return {
    goBack: key => {
      var actualizedKey = key;
      if (key === undefined && route.key) {
        (0, _invariant2.default)(typeof route.key === 'string', 'key should be a string');
        actualizedKey = route.key;
      }
      return _NavigationActions2.default.back({ key: actualizedKey });
    },
    navigate: (navigateTo, params, action) => {
      if (typeof navigateTo === 'string') {
        return _NavigationActions2.default.navigate({
          routeName: navigateTo,
          params,
          action
        });
      }
      (0, _invariant2.default)(typeof navigateTo === 'object', 'Must navigateTo an object or a string');
      (0, _invariant2.default)(params == null, 'Params must not be provided to .navigate() when specifying an object');
      (0, _invariant2.default)(action == null, 'Child action must not be provided to .navigate() when specifying an object');
      return _NavigationActions2.default.navigate(navigateTo);
    },
    setParams: params => {
      (0, _invariant2.default)(route.key && typeof route.key === 'string', 'setParams cannot be called by root navigator');
      return _NavigationActions2.default.setParams({ params, key: route.key });
    }
  };
};

exports.default = getNavigationActionCreators;