"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = require("@babel/helper-plugin-utils");

  _helperPluginUtils = function _helperPluginUtils() {
    return data;
  };

  return data;
}

function _pluginSyntaxOptionalChaining() {
  const data = _interopRequireDefault(require("@babel/plugin-syntax-optional-chaining"));

  _pluginSyntaxOptionalChaining = function _pluginSyntaxOptionalChaining() {
    return data;
  };

  return data;
}

function _core() {
  const data = require("@babel/core");

  _core = function _core() {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = (0, _helperPluginUtils().declare)((api, options) => {
  api.assertVersion(7);
  const _options$loose = options.loose,
        loose = _options$loose === void 0 ? false : _options$loose;

  function optional(path, replacementPath) {
    const scope = path.scope;
    const optionals = [];
    let objectPath = path;

    while (objectPath.isOptionalMemberExpression() || objectPath.isOptionalCallExpression()) {
      const _objectPath = objectPath,
            node = _objectPath.node;

      if (node.optional) {
        optionals.push(node);
      }

      if (objectPath.isOptionalMemberExpression()) {
        objectPath.node.type = "MemberExpression";
        objectPath = objectPath.get("object");
      } else {
        objectPath.node.type = "CallExpression";
        objectPath = objectPath.get("callee");
      }
    }

    for (let i = optionals.length - 1; i >= 0; i--) {
      const node = optionals[i];
      node.optional = false;

      const isCall = _core().types.isCallExpression(node);

      const replaceKey = isCall ? "callee" : "object";
      const chain = node[replaceKey];
      let ref;
      let check;

      if (loose && isCall) {
        check = ref = chain;
      } else {
        ref = scope.maybeGenerateMemoised(chain);

        if (ref) {
          check = _core().types.assignmentExpression("=", _core().types.cloneNode(ref), chain);
          node[replaceKey] = ref;
        } else {
          check = ref = chain;
        }
      }

      if (isCall && _core().types.isMemberExpression(chain)) {
        if (loose) {
          node.callee = chain;
        } else {
          const object = chain.object;
          let context = scope.maybeGenerateMemoised(object);

          if (context) {
            chain.object = _core().types.assignmentExpression("=", context, object);
          } else {
            context = object;
          }

          node.arguments.unshift(_core().types.cloneNode(context));
          node.callee = _core().types.memberExpression(node.callee, _core().types.identifier("call"));
        }
      }

      replacementPath.replaceWith(_core().types.conditionalExpression(loose ? _core().types.binaryExpression("==", _core().types.cloneNode(check), _core().types.nullLiteral()) : _core().types.logicalExpression("||", _core().types.binaryExpression("===", _core().types.cloneNode(check), _core().types.nullLiteral()), _core().types.binaryExpression("===", _core().types.cloneNode(ref), scope.buildUndefinedNode())), scope.buildUndefinedNode(), replacementPath.node));
      replacementPath = replacementPath.get("alternate");
    }
  }

  function findReplacementPath(path) {
    return path.find(path => {
      const parentPath = path.parentPath;

      if (path.key == "object" && parentPath.isOptionalMemberExpression()) {
        return false;
      }

      if (path.key == "callee" && parentPath.isOptionalCallExpression()) {
        return false;
      }

      if (path.key == "argument" && parentPath.isUnaryExpression({
        operator: "delete"
      })) {
        return false;
      }

      return true;
    });
  }

  return {
    inherits: _pluginSyntaxOptionalChaining().default,
    visitor: {
      "OptionalCallExpression|OptionalMemberExpression"(path) {
        if (!path.node.optional) {
          return;
        }

        optional(path, findReplacementPath(path));
      }

    }
  };
});

exports.default = _default;