/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */

"use strict";

const getAbsolutePath = require("./getAbsolutePath");
const path = require("path");

function getEntryAbsolutePath(config, entryFile) {
  if (config.projectRoot) {
    return path.resolve(config.projectRoot, entryFile);
  }
  return getAbsolutePath(entryFile, config.watchFolders);
}

module.exports = getEntryAbsolutePath;
