/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *  strict-local
 * @format
 */

/* eslint-env worker, serviceworker */
"use strict";

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}

function _asyncToGenerator(fn) {
  return function() {
    var self = this,
      args = arguments;
    return new Promise(function(resolve, reject) {
      var gen = fn.apply(self, args);
      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }
      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }
      _next(undefined);
    });
  };
}

const BUNDLE_CACHE_NAME = "__metroBundleCache";
/**
 * Retrieves a stringified bundle response from either the custom bundle cache
 * or the browser cache.
 */

function getBundleResponse(_x) {
  return _getBundleResponse.apply(this, arguments);
}
/**
 * Stores a stringified bundle response in the custom bundle cache.
 */

function _getBundleResponse() {
  _getBundleResponse = _asyncToGenerator(function*(request) {
    const cache = yield caches.open(BUNDLE_CACHE_NAME);
    const stringBundleRes = yield cache.match(request);

    if (stringBundleRes != null) {
      return stringBundleRes;
    }

    return yield fetch(request, {
      // This forces using the browser cache, in which the initial bundle request
      // will have been stored.
      cache: "force-cache"
    });
  });
  return _getBundleResponse.apply(this, arguments);
}

function setBundleResponse(_x2, _x3) {
  return _setBundleResponse.apply(this, arguments);
}

function _setBundleResponse() {
  _setBundleResponse = _asyncToGenerator(function*(request, response) {
    const cache = yield caches.open(BUNDLE_CACHE_NAME);
    yield cache.put(request, response);
  });
  return _setBundleResponse.apply(this, arguments);
}

module.exports = {
  getBundleResponse,
  setBundleResponse
};
