'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _reactIs = require('react-is');

var _invariant = require('../utils/invariant');

var _invariant2 = _interopRequireDefault(_invariant);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Make sure the config passed e.g. to StackRouter, TabRouter has
 * the correct format, and throw a clear error if it doesn't.
 */
function validateRouteConfigMap(routeConfigs) {
  var routeNames = Object.keys(routeConfigs);
  (0, _invariant2.default)(routeNames.length > 0, 'Please specify at least one route when configuring a navigator.');

  routeNames.forEach(routeName => {
    var routeConfig = routeConfigs[routeName];
    var screenComponent = getScreenComponent(routeConfig);

    if (!screenComponent || !(0, _reactIs.isValidElementType)(screenComponent) && !routeConfig.getScreen) {
      throw new Error(`The component for route '${routeName}' must be a React component. For example:

import MyScreen from './MyScreen';
...
${routeName}: MyScreen,
}

You can also use a navigator:

import MyNavigator from './MyNavigator';
...
${routeName}: MyNavigator,
}`);
    }

    if (routeConfig.screen && routeConfig.getScreen) {
      throw new Error(`Route '${routeName}' should declare a screen or a getScreen, not both.`);
    }
  });
}

function getScreenComponent(routeConfig) {
  if (!routeConfig) {
    return null;
  }

  return routeConfig.screen ? routeConfig.screen : routeConfig;
}

exports.default = validateRouteConfigMap;