"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _helperPluginUtils() {
  const data = require("@babel/helper-plugin-utils");

  _helperPluginUtils = function _helperPluginUtils() {
    return data;
  };

  return data;
}

function _core() {
  const data = require("@babel/core");

  _core = function _core() {
    return data;
  };

  return data;
}

var _default = (0, _helperPluginUtils().declare)((api, options) => {
  api.assertVersion(7);
  const loose = options.loose;

  function getSpreadLiteral(spread, scope) {
    if (loose && !_core().types.isIdentifier(spread.argument, {
      name: "arguments"
    })) {
      return spread.argument;
    } else {
      return scope.toArray(spread.argument, true);
    }
  }

  function hasSpread(nodes) {
    for (let i = 0; i < nodes.length; i++) {
      if (_core().types.isSpreadElement(nodes[i])) {
        return true;
      }
    }

    return false;
  }

  function push(_props, nodes) {
    if (!_props.length) return _props;
    nodes.push(_core().types.arrayExpression(_props));
    return [];
  }

  function build(props, scope) {
    const nodes = [];
    let _props = [];

    for (var _iterator = props, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
      var _ref;

      if (_isArray) {
        if (_i >= _iterator.length) break;
        _ref = _iterator[_i++];
      } else {
        _i = _iterator.next();
        if (_i.done) break;
        _ref = _i.value;
      }

      const prop = _ref;

      if (_core().types.isSpreadElement(prop)) {
        _props = push(_props, nodes);
        nodes.push(getSpreadLiteral(prop, scope));
      } else {
        _props.push(prop);
      }
    }

    push(_props, nodes);
    return nodes;
  }

  return {
    visitor: {
      ArrayExpression(path) {
        const node = path.node,
              scope = path.scope;
        const elements = node.elements;
        if (!hasSpread(elements)) return;
        const nodes = build(elements, scope);
        const first = nodes.shift();

        if (nodes.length === 0 && first !== elements[0].argument) {
          path.replaceWith(first);
          return;
        }

        path.replaceWith(_core().types.callExpression(_core().types.memberExpression(first, _core().types.identifier("concat")), nodes));
      },

      CallExpression(path) {
        const node = path.node,
              scope = path.scope;
        const args = node.arguments;
        if (!hasSpread(args)) return;
        const calleePath = path.get("callee");
        if (calleePath.isSuper()) return;
        let contextLiteral = scope.buildUndefinedNode();
        node.arguments = [];
        let nodes;

        if (args.length === 1 && args[0].argument.name === "arguments") {
          nodes = [args[0].argument];
        } else {
          nodes = build(args, scope);
        }

        const first = nodes.shift();

        if (nodes.length) {
          node.arguments.push(_core().types.callExpression(_core().types.memberExpression(first, _core().types.identifier("concat")), nodes));
        } else {
          node.arguments.push(first);
        }

        const callee = node.callee;

        if (calleePath.isMemberExpression()) {
          const temp = scope.maybeGenerateMemoised(callee.object);

          if (temp) {
            callee.object = _core().types.assignmentExpression("=", temp, callee.object);
            contextLiteral = temp;
          } else {
            contextLiteral = _core().types.cloneNode(callee.object);
          }

          _core().types.appendToMemberExpression(callee, _core().types.identifier("apply"));
        } else {
          node.callee = _core().types.memberExpression(node.callee, _core().types.identifier("apply"));
        }

        if (_core().types.isSuper(contextLiteral)) {
          contextLiteral = _core().types.thisExpression();
        }

        node.arguments.unshift(_core().types.cloneNode(contextLiteral));
      },

      NewExpression(path) {
        const node = path.node,
              scope = path.scope;
        let args = node.arguments;
        if (!hasSpread(args)) return;
        const nodes = build(args, scope);
        const first = nodes.shift();

        if (nodes.length) {
          args = _core().types.callExpression(_core().types.memberExpression(first, _core().types.identifier("concat")), nodes);
        } else {
          args = first;
        }

        path.replaceWith(_core().types.callExpression(path.hub.file.addHelper("construct"), [node.callee, args]));
      }

    }
  };
});

exports.default = _default;