/*
 * Copyright 2017 Juergen Fickel
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.retujo.bierverkostung.data;

import java.util.List;

import javax.annotation.Nonnull;

/**
 * This interface defines a database table.
 *
 * @since 1.0.0
 */
public interface Table extends CharSequence {

    /**
     * Creates a new column which belongs to this table.
     *
     * @param name the name of the column.
     * @param type the type of the column.
     * @return the new column.
     * @throws NullPointerException if any argument is {@code null}.
     * @throws IllegalArgumentException if {@code name} is empty.
     */
    @Nonnull
    Column createColumn(@Nonnull CharSequence name, @Nonnull ColumnType type);

    /**
     * Returns the columns of this table which were created by calling {@link #createColumn(CharSequence, ColumnType)}.
     *
     * @return an copy of the list with the columns. The order is the creation order. If this table does not have
     * columns an empty list is returned.
     */
    @Nonnull
    List<Column> getColumns();

}
