/*
 * This file is auto-generated.  DO NOT MODIFY.
 * Original file: frameworks/base/telephony/java/com/android/internal/telephony/ITelephony.aidl
 */
package com.android.internal.telephony;

/**
 * Interface used to interact with the phone. Mostly this is used by the TelephonyManager class. A few places
 * are still using this directly. Please clean them up if possible and use TelephonyManager insteadl.
 * <p>
 * {@hide}
 */
public interface ITelephony extends android.os.IInterface {
    /**
     * Local-side IPC implementation stub class.
     */
    public static abstract class Stub extends android.os.Binder implements
            com.android.internal.telephony.ITelephony {
        private static final java.lang.String DESCRIPTOR = "com.android.internal.telephony.ITelephony";

        /**
         * Construct the stub at attach it to the interface.
         */
        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        /**
         * Cast an IBinder object into an com.android.internal.telephony.ITelephony interface, generating a proxy
         * if needed.
         */
        public static com.android.internal.telephony.ITelephony asInterface(android.os.IBinder obj) {
            if ((obj == null)) {
                return null;
            }
            android.os.IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (((iin != null) && (iin instanceof com.android.internal.telephony.ITelephony))) {
                return ((com.android.internal.telephony.ITelephony) iin);
            }
            return new com.android.internal.telephony.ITelephony.Stub.Proxy(obj);
        }

        @Override
        public android.os.IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, android.os.Parcel data, android.os.Parcel reply, int flags) throws android.os.RemoteException {
            switch (code) {
                case INTERFACE_TRANSACTION: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case TRANSACTION_dial: {
                    data.enforceInterface(DESCRIPTOR);
                    java.lang.String _arg0;
                    _arg0 = data.readString();
                    this.dial(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_call: {
                    data.enforceInterface(DESCRIPTOR);
                    java.lang.String _arg0;
                    _arg0 = data.readString();
                    this.call(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_showCallScreen: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.showCallScreen();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_showCallScreenWithDialpad: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0;
                    _arg0 = (0 != data.readInt());
                    boolean _result = this.showCallScreenWithDialpad(_arg0);
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_endCall: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.endCall();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_answerRingingCall: {
                    data.enforceInterface(DESCRIPTOR);
                    this.answerRingingCall();
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_silenceRinger: {
                    data.enforceInterface(DESCRIPTOR);
                    this.silenceRinger();
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_isOffhook: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isOffhook();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_isRinging: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isRinging();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_isIdle: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isIdle();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_isRadioOn: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isRadioOn();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_isSimPinEnabled: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isSimPinEnabled();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_cancelMissedCallsNotification: {
                    data.enforceInterface(DESCRIPTOR);
                    this.cancelMissedCallsNotification();
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_supplyPin: {
                    data.enforceInterface(DESCRIPTOR);
                    java.lang.String _arg0;
                    _arg0 = data.readString();
                    boolean _result = this.supplyPin(_arg0);
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_handlePinMmi: {
                    data.enforceInterface(DESCRIPTOR);
                    java.lang.String _arg0;
                    _arg0 = data.readString();
                    boolean _result = this.handlePinMmi(_arg0);
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_toggleRadioOnOff: {
                    data.enforceInterface(DESCRIPTOR);
                    this.toggleRadioOnOff();
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_setRadio: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _arg0;
                    _arg0 = (0 != data.readInt());
                    boolean _result = this.setRadio(_arg0);
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_updateServiceLocation: {
                    data.enforceInterface(DESCRIPTOR);
                    this.updateServiceLocation();
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_enableLocationUpdates: {
                    data.enforceInterface(DESCRIPTOR);
                    this.enableLocationUpdates();
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_disableLocationUpdates: {
                    data.enforceInterface(DESCRIPTOR);
                    this.disableLocationUpdates();
                    reply.writeNoException();
                    return true;
                }
                case TRANSACTION_enableApnType: {
                    data.enforceInterface(DESCRIPTOR);
                    java.lang.String _arg0;
                    _arg0 = data.readString();
                    int _result = this.enableApnType(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_disableApnType: {
                    data.enforceInterface(DESCRIPTOR);
                    java.lang.String _arg0;
                    _arg0 = data.readString();
                    int _result = this.disableApnType(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_enableDataConnectivity: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.enableDataConnectivity();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_disableDataConnectivity: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.disableDataConnectivity();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_isDataConnectivityPossible: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isDataConnectivityPossible();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_getCellLocation: {
                    data.enforceInterface(DESCRIPTOR);
                    android.os.Bundle _result = this.getCellLocation();
                    reply.writeNoException();
                    if ((_result != null)) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, android.os.Parcelable.PARCELABLE_WRITE_RETURN_VALUE);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case TRANSACTION_getNeighboringCellInfo: {
                    data.enforceInterface(DESCRIPTOR);
                    java.util.List<android.telephony.NeighboringCellInfo> _result = this.getNeighboringCellInfo();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case TRANSACTION_getCallState: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getCallState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_getDataActivity: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getDataActivity();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_getDataState: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getDataState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_getActivePhoneType: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getActivePhoneType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_getCdmaEriIconIndex: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getCdmaEriIconIndex();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_getCdmaEriIconMode: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getCdmaEriIconMode();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_getCdmaEriText: {
                    data.enforceInterface(DESCRIPTOR);
                    java.lang.String _result = this.getCdmaEriText();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case TRANSACTION_getCdmaNeedsProvisioning: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.getCdmaNeedsProvisioning();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
                case TRANSACTION_getVoiceMessageCount: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getVoiceMessageCount();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_getNetworkType: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getNetworkType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case TRANSACTION_hasIccCard: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.hasIccCard();
                    reply.writeNoException();
                    reply.writeInt(((_result) ? (1) : (0)));
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy implements com.android.internal.telephony.ITelephony {
            private android.os.IBinder mRemote;

            Proxy(android.os.IBinder remote) {
                mRemote = remote;
            }

            @Override
            public android.os.IBinder asBinder() {
                return mRemote;
            }

            public java.lang.String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /**
             * Dial a number. This doesn't place the call. It displays the Dialer screen.
             *
             * @param number the number to be dialed. If null, this would display the Dialer screen with no number
             *               pre-filled.
             */
            @Override
            public void dial(java.lang.String number) throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(number);
                    mRemote.transact(Stub.TRANSACTION_dial, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * Place a call to the specified number.
             *
             * @param number the number to be called.
             */
            @Override
            public void call(java.lang.String number) throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(number);
                    mRemote.transact(Stub.TRANSACTION_call, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * If there is currently a call in progress, show the call screen. The DTMF dialpad may or may not be
             * visible initially, depending on whether it was up when the user last exited the InCallScreen.
             *
             * @return true if the call screen was shown.
             */
            @Override
            public boolean showCallScreen() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_showCallScreen, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Variation of showCallScreen() that also specifies whether the DTMF dialpad should be initially
             * visible when the InCallScreen comes up.
             *
             * @param showDialpad if true, make the dialpad visible initially, otherwise hide the dialpad initially.
             * @return true if the call screen was shown.
             * @see showCallScreen
             */
            @Override
            public boolean showCallScreenWithDialpad(boolean showDialpad) throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(((showDialpad) ? (1) : (0)));
                    mRemote.transact(Stub.TRANSACTION_showCallScreenWithDialpad, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * End call or go to the Home screen
             *
             * @return whether it hung up
             */
            @Override
            public boolean endCall() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_endCall, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Answer the currently-ringing call.
             * <p>
             * If there's already a current active call, that call will be automatically put on hold. If both lines
             * are currently in use, the current active call will be ended.
             * <p>
             * TODO: provide a flag to let the caller specify what policy to use if both lines are in use. (The
             * current behavior is hardwired to "answer incoming, end ongoing", which is how the CALL button is
             * specced to behave.)
             * <p>
             * TODO: this should be a oneway call (especially since it's called directly from the key queue thread).
             */
            @Override
            public void answerRingingCall() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_answerRingingCall, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * Silence the ringer if an incoming call is currently ringing. (If vibrating, stop the vibrator also.)
             * <p>
             * It's safe to call this if the ringer has already been silenced, or even if there's no incoming call.
             * (If so, this method will do nothing.)
             * <p>
             * TODO: this should be a oneway call too (see above). (Actually *all* the methods here that return void
             * can probably be oneway.)
             */
            @Override
            public void silenceRinger() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_silenceRinger, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * Check if we are in either an active or holding call
             *
             * @return true if the phone state is OFFHOOK.
             */
            @Override
            public boolean isOffhook() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_isOffhook, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Check if an incoming phone call is ringing or call waiting.
             *
             * @return true if the phone state is RINGING.
             */
            @Override
            public boolean isRinging() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_isRinging, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Check if the phone is idle.
             *
             * @return true if the phone state is IDLE.
             */
            @Override
            public boolean isIdle() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_isIdle, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Check to see if the radio is on or not.
             *
             * @return returns true if the radio is on.
             */
            @Override
            public boolean isRadioOn() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_isRadioOn, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Check if the SIM pin lock is enabled.
             *
             * @return true if the SIM pin lock is enabled.
             */
            @Override
            public boolean isSimPinEnabled() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_isSimPinEnabled, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Cancels the missed calls notification.
             */
            @Override
            public void cancelMissedCallsNotification() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_cancelMissedCallsNotification, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * Supply a pin to unlock the SIM. Blocks until a result is determined.
             *
             * @param pin The pin to check.
             * @return whether the operation was a success.
             */
            @Override
            public boolean supplyPin(java.lang.String pin) throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(pin);
                    mRemote.transact(Stub.TRANSACTION_supplyPin, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Handles PIN MMI commands (PIN/PIN2/PUK/PUK2), which are initiated without SEND (so <code>dial</code>
             * is not appropriate).
             *
             * @param dialString the MMI command to be executed.
             * @return true if MMI command is executed.
             */
            @Override
            public boolean handlePinMmi(java.lang.String dialString) throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(dialString);
                    mRemote.transact(Stub.TRANSACTION_handlePinMmi, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Toggles the radio on or off.
             */
            @Override
            public void toggleRadioOnOff() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_toggleRadioOnOff, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * Set the radio to on or off
             */
            @Override
            public boolean setRadio(boolean turnOn) throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(((turnOn) ? (1) : (0)));
                    mRemote.transact(Stub.TRANSACTION_setRadio, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Request to update location information in service state
             */
            @Override
            public void updateServiceLocation() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_updateServiceLocation, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * Enable location update notifications.
             */
            @Override
            public void enableLocationUpdates() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_enableLocationUpdates, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * Disable location update notifications.
             */
            @Override
            public void disableLocationUpdates() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_disableLocationUpdates, _data, _reply, 0);
                    _reply.readException();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /**
             * Enable a specific APN type.
             */
            @Override
            public int enableApnType(java.lang.String type) throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(type);
                    mRemote.transact(Stub.TRANSACTION_enableApnType, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Disable a specific APN type.
             */
            @Override
            public int disableApnType(java.lang.String type) throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(type);
                    mRemote.transact(Stub.TRANSACTION_disableApnType, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Allow mobile data connections.
             */
            @Override
            public boolean enableDataConnectivity() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_enableDataConnectivity, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Disallow mobile data connections.
             */
            @Override
            public boolean disableDataConnectivity() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_disableDataConnectivity, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Report whether data connectivity is possible.
             */
            @Override
            public boolean isDataConnectivityPossible() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_isDataConnectivityPossible, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public android.os.Bundle getCellLocation() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                android.os.Bundle _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getCellLocation, _data, _reply, 0);
                    _reply.readException();
                    if ((0 != _reply.readInt())) {
                        _result = android.os.Bundle.CREATOR.createFromParcel(_reply);
                    } else {
                        _result = null;
                    }
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Returns the neighboring cell information of the device.
             */
            @Override
            public java.util.List<android.telephony.NeighboringCellInfo> getNeighboringCellInfo() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                java.util.List<android.telephony.NeighboringCellInfo> _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getNeighboringCellInfo, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(android.telephony.NeighboringCellInfo.CREATOR);
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public int getCallState() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getCallState, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public int getDataActivity() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getDataActivity, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            @Override
            public int getDataState() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getDataState, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Returns the current active phone type as integer. Returns TelephonyManager.PHONE_TYPE_CDMA if
             * RILConstants.CDMA_PHONE and TelephonyManager.PHONE_TYPE_GSM if RILConstants.GSM_PHONE
             */
            @Override
            public int getActivePhoneType() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getActivePhoneType, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Returns the CDMA ERI icon index to display
             */
            @Override
            public int getCdmaEriIconIndex() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getCdmaEriIconIndex, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Returns the CDMA ERI icon mode, 0 - ON 1 - FLASHING
             */
            @Override
            public int getCdmaEriIconMode() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getCdmaEriIconMode, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Returns the CDMA ERI text,
             */
            @Override
            public java.lang.String getCdmaEriText() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                java.lang.String _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getCdmaEriText, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Returns true if CDMA provisioning needs to run.
             */
            @Override
            public boolean getCdmaNeedsProvisioning() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getCdmaNeedsProvisioning, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Returns the unread count of voicemails
             */
            @Override
            public int getVoiceMessageCount() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getVoiceMessageCount, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Returns the network type
             */
            @Override
            public int getNetworkType() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                int _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_getNetworkType, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /**
             * Return true if an ICC card is present
             */
            @Override
            public boolean hasIccCard() throws android.os.RemoteException {
                android.os.Parcel _data = android.os.Parcel.obtain();
                android.os.Parcel _reply = android.os.Parcel.obtain();
                boolean _result;
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    mRemote.transact(Stub.TRANSACTION_hasIccCard, _data, _reply, 0);
                    _reply.readException();
                    _result = (0 != _reply.readInt());
                } finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }

        static final int TRANSACTION_dial = (android.os.IBinder.FIRST_CALL_TRANSACTION + 0);
        static final int TRANSACTION_call = (android.os.IBinder.FIRST_CALL_TRANSACTION + 1);
        static final int TRANSACTION_showCallScreen = (android.os.IBinder.FIRST_CALL_TRANSACTION + 2);
        static final int TRANSACTION_showCallScreenWithDialpad = (android.os.IBinder.FIRST_CALL_TRANSACTION + 3);
        static final int TRANSACTION_endCall = (android.os.IBinder.FIRST_CALL_TRANSACTION + 4);
        static final int TRANSACTION_answerRingingCall = (android.os.IBinder.FIRST_CALL_TRANSACTION + 5);
        static final int TRANSACTION_silenceRinger = (android.os.IBinder.FIRST_CALL_TRANSACTION + 6);
        static final int TRANSACTION_isOffhook = (android.os.IBinder.FIRST_CALL_TRANSACTION + 7);
        static final int TRANSACTION_isRinging = (android.os.IBinder.FIRST_CALL_TRANSACTION + 8);
        static final int TRANSACTION_isIdle = (android.os.IBinder.FIRST_CALL_TRANSACTION + 9);
        static final int TRANSACTION_isRadioOn = (android.os.IBinder.FIRST_CALL_TRANSACTION + 10);
        static final int TRANSACTION_isSimPinEnabled = (android.os.IBinder.FIRST_CALL_TRANSACTION + 11);
        static final int TRANSACTION_cancelMissedCallsNotification = (android.os.IBinder.FIRST_CALL_TRANSACTION + 12);
        static final int TRANSACTION_supplyPin = (android.os.IBinder.FIRST_CALL_TRANSACTION + 13);
        static final int TRANSACTION_handlePinMmi = (android.os.IBinder.FIRST_CALL_TRANSACTION + 14);
        static final int TRANSACTION_toggleRadioOnOff = (android.os.IBinder.FIRST_CALL_TRANSACTION + 15);
        static final int TRANSACTION_setRadio = (android.os.IBinder.FIRST_CALL_TRANSACTION + 16);
        static final int TRANSACTION_updateServiceLocation = (android.os.IBinder.FIRST_CALL_TRANSACTION + 17);
        static final int TRANSACTION_enableLocationUpdates = (android.os.IBinder.FIRST_CALL_TRANSACTION + 18);
        static final int TRANSACTION_disableLocationUpdates = (android.os.IBinder.FIRST_CALL_TRANSACTION + 19);
        static final int TRANSACTION_enableApnType = (android.os.IBinder.FIRST_CALL_TRANSACTION + 20);
        static final int TRANSACTION_disableApnType = (android.os.IBinder.FIRST_CALL_TRANSACTION + 21);
        static final int TRANSACTION_enableDataConnectivity = (android.os.IBinder.FIRST_CALL_TRANSACTION + 22);
        static final int TRANSACTION_disableDataConnectivity = (android.os.IBinder.FIRST_CALL_TRANSACTION + 23);
        static final int TRANSACTION_isDataConnectivityPossible = (android.os.IBinder.FIRST_CALL_TRANSACTION + 24);
        static final int TRANSACTION_getCellLocation = (android.os.IBinder.FIRST_CALL_TRANSACTION + 25);
        static final int TRANSACTION_getNeighboringCellInfo = (android.os.IBinder.FIRST_CALL_TRANSACTION + 26);
        static final int TRANSACTION_getCallState = (android.os.IBinder.FIRST_CALL_TRANSACTION + 27);
        static final int TRANSACTION_getDataActivity = (android.os.IBinder.FIRST_CALL_TRANSACTION + 28);
        static final int TRANSACTION_getDataState = (android.os.IBinder.FIRST_CALL_TRANSACTION + 29);
        static final int TRANSACTION_getActivePhoneType = (android.os.IBinder.FIRST_CALL_TRANSACTION + 30);
        static final int TRANSACTION_getCdmaEriIconIndex = (android.os.IBinder.FIRST_CALL_TRANSACTION + 31);
        static final int TRANSACTION_getCdmaEriIconMode = (android.os.IBinder.FIRST_CALL_TRANSACTION + 32);
        static final int TRANSACTION_getCdmaEriText = (android.os.IBinder.FIRST_CALL_TRANSACTION + 33);
        static final int TRANSACTION_getCdmaNeedsProvisioning = (android.os.IBinder.FIRST_CALL_TRANSACTION + 34);
        static final int TRANSACTION_getVoiceMessageCount = (android.os.IBinder.FIRST_CALL_TRANSACTION + 35);
        static final int TRANSACTION_getNetworkType = (android.os.IBinder.FIRST_CALL_TRANSACTION + 36);
        static final int TRANSACTION_hasIccCard = (android.os.IBinder.FIRST_CALL_TRANSACTION + 37);
    }

    /**
     * Dial a number. This doesn't place the call. It displays the Dialer screen.
     *
     * @param number the number to be dialed. If null, this would display the Dialer screen with no number
     *               pre-filled.
     */
    public void dial(java.lang.String number) throws android.os.RemoteException;

    /**
     * Place a call to the specified number.
     *
     * @param number the number to be called.
     */
    public void call(java.lang.String number) throws android.os.RemoteException;

    /**
     * If there is currently a call in progress, show the call screen. The DTMF dialpad may or may not be
     * visible initially, depending on whether it was up when the user last exited the InCallScreen.
     *
     * @return true if the call screen was shown.
     */
    public boolean showCallScreen() throws android.os.RemoteException;

    /**
     * Variation of showCallScreen() that also specifies whether the DTMF dialpad should be initially visible
     * when the InCallScreen comes up.
     *
     * @param showDialpad if true, make the dialpad visible initially, otherwise hide the dialpad initially.
     * @return true if the call screen was shown.
     * @see showCallScreen
     */
    public boolean showCallScreenWithDialpad(boolean showDialpad) throws android.os.RemoteException;

    /**
     * End call or go to the Home screen
     *
     * @return whether it hung up
     */
    public boolean endCall() throws android.os.RemoteException;

    /**
     * Answer the currently-ringing call.
     * <p>
     * If there's already a current active call, that call will be automatically put on hold. If both lines are
     * currently in use, the current active call will be ended.
     * <p>
     * TODO: provide a flag to let the caller specify what policy to use if both lines are in use. (The current
     * behavior is hardwired to "answer incoming, end ongoing", which is how the CALL button is specced to
     * behave.)
     * <p>
     * TODO: this should be a oneway call (especially since it's called directly from the key queue thread).
     */
    public void answerRingingCall() throws android.os.RemoteException;

    /**
     * Silence the ringer if an incoming call is currently ringing. (If vibrating, stop the vibrator also.)
     * <p>
     * It's safe to call this if the ringer has already been silenced, or even if there's no incoming call. (If
     * so, this method will do nothing.)
     * <p>
     * TODO: this should be a oneway call too (see above). (Actually *all* the methods here that return void can
     * probably be oneway.)
     */
    public void silenceRinger() throws android.os.RemoteException;

    /**
     * Check if we are in either an active or holding call
     *
     * @return true if the phone state is OFFHOOK.
     */
    public boolean isOffhook() throws android.os.RemoteException;

    /**
     * Check if an incoming phone call is ringing or call waiting.
     *
     * @return true if the phone state is RINGING.
     */
    public boolean isRinging() throws android.os.RemoteException;

    /**
     * Check if the phone is idle.
     *
     * @return true if the phone state is IDLE.
     */
    public boolean isIdle() throws android.os.RemoteException;

    /**
     * Check to see if the radio is on or not.
     *
     * @return returns true if the radio is on.
     */
    public boolean isRadioOn() throws android.os.RemoteException;

    /**
     * Check if the SIM pin lock is enabled.
     *
     * @return true if the SIM pin lock is enabled.
     */
    public boolean isSimPinEnabled() throws android.os.RemoteException;

    /**
     * Cancels the missed calls notification.
     */
    public void cancelMissedCallsNotification() throws android.os.RemoteException;

    /**
     * Supply a pin to unlock the SIM. Blocks until a result is determined.
     *
     * @param pin The pin to check.
     * @return whether the operation was a success.
     */
    public boolean supplyPin(java.lang.String pin) throws android.os.RemoteException;

    /**
     * Handles PIN MMI commands (PIN/PIN2/PUK/PUK2), which are initiated without SEND (so <code>dial</code> is
     * not appropriate).
     *
     * @param dialString the MMI command to be executed.
     * @return true if MMI command is executed.
     */
    public boolean handlePinMmi(java.lang.String dialString) throws android.os.RemoteException;

    /**
     * Toggles the radio on or off.
     */
    public void toggleRadioOnOff() throws android.os.RemoteException;

    /**
     * Set the radio to on or off
     */
    public boolean setRadio(boolean turnOn) throws android.os.RemoteException;

    /**
     * Request to update location information in service state
     */
    public void updateServiceLocation() throws android.os.RemoteException;

    /**
     * Enable location update notifications.
     */
    public void enableLocationUpdates() throws android.os.RemoteException;

    /**
     * Disable location update notifications.
     */
    public void disableLocationUpdates() throws android.os.RemoteException;

    /**
     * Enable a specific APN type.
     */
    public int enableApnType(java.lang.String type) throws android.os.RemoteException;

    /**
     * Disable a specific APN type.
     */
    public int disableApnType(java.lang.String type) throws android.os.RemoteException;

    /**
     * Allow mobile data connections.
     */
    public boolean enableDataConnectivity() throws android.os.RemoteException;

    /**
     * Disallow mobile data connections.
     */
    public boolean disableDataConnectivity() throws android.os.RemoteException;

    /**
     * Report whether data connectivity is possible.
     */
    public boolean isDataConnectivityPossible() throws android.os.RemoteException;

    public android.os.Bundle getCellLocation() throws android.os.RemoteException;

    /**
     * Returns the neighboring cell information of the device.
     */
    public java.util.List<android.telephony.NeighboringCellInfo> getNeighboringCellInfo() throws android.os.RemoteException;

    public int getCallState() throws android.os.RemoteException;

    public int getDataActivity() throws android.os.RemoteException;

    public int getDataState() throws android.os.RemoteException;

    /**
     * Returns the current active phone type as integer. Returns TelephonyManager.PHONE_TYPE_CDMA if
     * RILConstants.CDMA_PHONE and TelephonyManager.PHONE_TYPE_GSM if RILConstants.GSM_PHONE
     */
    public int getActivePhoneType() throws android.os.RemoteException;

    /**
     * Returns the CDMA ERI icon index to display
     */
    public int getCdmaEriIconIndex() throws android.os.RemoteException;

    /**
     * Returns the CDMA ERI icon mode, 0 - ON 1 - FLASHING
     */
    public int getCdmaEriIconMode() throws android.os.RemoteException;

    /**
     * Returns the CDMA ERI text,
     */
    public java.lang.String getCdmaEriText() throws android.os.RemoteException;

    /**
     * Returns true if CDMA provisioning needs to run.
     */
    public boolean getCdmaNeedsProvisioning() throws android.os.RemoteException;

    /**
     * Returns the unread count of voicemails
     */
    public int getVoiceMessageCount() throws android.os.RemoteException;

    /**
     * Returns the network type
     */
    public int getNetworkType() throws android.os.RemoteException;

    /**
     * Return true if an ICC card is present
     */
    public boolean hasIccCard() throws android.os.RemoteException;
}
