package de.xskat;

public class Translations {
    // --------------------------------------------------------------------------------------
    // File text.c
    // --------------------------------------------------------------------------------------

    private final static String[][] TRANSLATIONS = { // DE, EN
            {"Null", "Null"}, // XT_Null
            {"Karo", "Diamond"}, // XT_Karo
            {"Herz", "Heart"}, // XT_Herz
            {"Pik", "Spade"}, // XT_Pik
            {"Kreuz", "Club"}, // XT_Kreuz
            {"Grand", "Grand"}, // XT_Grand
            {"Ramsch", "Ramsch"}, // XT_Ramsch
            {"Sortiere für Null", "Sort for Null"}, // XT_Sortiere_fuer_Null
            {"Sortiere normal", "Sort normally"}, // XT_Sortiere_normal
            {"Gereizt bis", "It was bid"}, // XT_Gereizt_bis
            {"Androido", "Androido"}, // XT_Androido
            {"Androida", "Androida"}, // XT_Androida
            {"spielt", "plays"}, // XT_spielt
            {"Hand", "Hand"}, // XT_Hand
            {"für", "for"}, // XT_fuer
            {"Spitze", "Spitze"}, // XT_Spitze
            {"Annehmen", "Accept"}, // XT_Annehmen
            {"Schenken", "Concede"}, // XT_Schenken
            {"Passe", "Pass"}, // XT_Passe
            {"Im Skat", "Skat"}, // XT_Im_Skat
            {"war", "was"}, // XT_war
            {"ist", "is"}, // XT_ist
            {"Eine Jungfrau!", "One virgin!"}, // XT_Eine_Jungfrau
            {"Durchmarsch!", "Forced march!"}, // XT_Durchmarsch
            {"Überreizt!", "Overbid!"}, // XT_Ueberreizt
            {"Gegner nicht Schneider!", "Opponents not Schneider!"}, // XT_Gegner_nicht_Schneider
            {"Gegner nicht schwarz!", "Opponents not schwarz!"}, // XT_Gegner_nicht_schwarz
            {"Spitze verloren!", "Lost Spitze!"}, // XT_Spitze_verloren
            {"Spieler", "Player"}, // XT_Spieler
            {"Niemand", "Nobody"}, // XT_Niemand
            {"gewinnt", "wins"}, // XT_gewinnt
            {"verliert", "loses"}, // XT_verliert
            {"das Nullspiel.", "the Null game."}, // XT_das_Nullspiel
            {"den Ramsch.", "the Ramsch."}, // XT_den_Ramsch
            {"schwarz.", "schwarz."}, // XT_schwarz
            {"mit", "with"}, // XT_mit
            {"Augen", "points"}, // XT_Augen
            {"Spielwert", "Game value"}, // XT_Spielwert
            {"Ja", "Yes"}, // XT_Ja
            {"Weiter", "Continue"}, // XT_Weiter
            {"Dieses Programm ist freie Software;",
                    "This program is free software;"}, // XT_Dieses_Programm_ist_freie_Software
            {"es kann frei verbreitet werden.",
                    "you can redistribute it freely."}, // XT_es_kann_frei_verbreitet_werden
            {"Nur bei Handspielen kann Schneider",
                    "Only when playing Hand you may"}, // XT_Nur_bei_Handspielen_kann_Schneider
            {"oder schwarz angesagt werden.", "say Schneider or schwarz."}, // XT_oder_schwarz_angesagt_werden
            {"Ouvert schließt schwarz angesagt ein", "Ouvert includes schwarz"}, // XT_Ouvert_schliesst_schwarz_angesagt_ein
            {"(außer bei Null natürlich).", "(except when playing Null)."}, // XT_ausser_bei_Null_natuerlich
            {"Hand?", "Hand?"}, // XT_HandFrage
            {"Nein", "No"}, // XT_Nein
            {"Spiel", "Game"}, // XT_Spiel
            {"G/V", "W/L"}, // XT_GV
            {"Löschen", "Delete"}, // XT_Loeschen
            {"Über XSkat", "About XSkat"}, // XT_Ueber_XSkat
            {"Optionen", "Options"}, // XT_Optionen
            {"Letzter Stich", "Last trick"}, // XT_Letzter_Stich
            {"Lösche", "Delete"}, // XT_Loesche
            {"Spielstand", "game score"}, // XT_Spielstand
            {"und Liste?", "and list?"}, // XT_und_Liste
            {"Liste", "List"}, // XT_Liste
            {"Protokoll", "Log"}, // XT_Protokoll
            {"Schneider", "Schneider"}, // XT_Schneider
            {"Schwarz", "Schwarz"}, // XT_Schwarz
            {"Ouvert", "Ouvert"}, // XT_Ouvert
            {"Spielen", "Play"}, // XT_Spielen
            {"Revolution", "Revolution"}, // XT_Revolution
            {"Du hast höher gereizt als der", "The value of your game"}, // XT_Du_hast_hoeher_gereizt_als_der
            {"Wert des angesagten Spiels!", "is not high enough!"}, // XT_Wert_des_angesagten_Spiels
            {"Null: 23, Hand: 35", "Null: 23, Hand: 35"}, // XT_Null_23_Hand_35
            {"ouvert: 46, ouvert Hand: 59", "ouvert: 46, ouvert Hand: 59"}, // XT_ouvert_46_ouvert_Hand_59
            {"Revolution: 92", "Revolution: 92"}, // XT_Revolution_92
            {"Drücken", "Done"}, // XT_Druecken
            {"Fertig", "Done"}, // XT_Fertig
            {"Spielstärke", "Playing strength"}, // XT_Spielstaerke
            {"Sprache", "Language"}, // XT_Sprache
            {"Display irgendwo antippen,", "Tap screen anywhere"}, // XT_Display_irgendwo_antippen
            {"um Stich zu entfernen.", "to remove trick."}, // XT_um_Stich_zu_entfernen
            {"Neues Spiel", "New game"}, // XT_NeuesSpiel
            {"http://xskat.de/android-de.html", "http://xskat.de/android.html"}, // XT_xskat_de
            {"Blatt", "Suit"}, // XT_Blatt
            {"Turnier", "Tournament"}, // XT_Turnier
            {"Französisch", "French"}, // XT_Franzoesisch
            {"Deutsch", "German"}, // XT_Deutsch
            {"Schellen", "Bells"}, // XT_Schellen
            {"Rot", "Hearts"}, // XT_Rot
            {"Grün", "Leaves"}, // XT_Gruen
            {"Eicheln", "Acorns"}, // XT_Eicheln
            {"Sortierung", "Sort"}, // XT_Sortierung
            {"Alternierend", "Alternating"}, // XT_Alternierend
            {"Sequentiell", "Sequential"}, // XT_Sequentiell
            {"Nimm Stich nach", "Take trick after"}, // XT_Nimm_Stich_nach
            {"Antippen.", "tapping."}, // XT_Antippen
            {" Sekunden.", " seconds."}, // XT_Sekunden
            {"Varianten", "Variants"}, // XT_Varianten
            {"Immer", "Always"}, // XT_Immer
            {"Kontra", "Kontra"}, // XT_Kontra
            {"ab 18", "if 18"}, // XT_Ab_18
            {"Bock", "Bock"}, // XT_Bock
            {"+Ramsch", "+Ramsch"}, // XT_Plus_Ramsch
            {"zählt 2", "counts 2"}, // XT_Zaehlt_2
            {"Schieberamsch", "Schieberamsch"}, // XT_Schieberamsch
            {"Skat geht an", "Skat goes to"}, // XT_Skat_geht_an
            {"letzten Stich", "last trick"}, // XT_letzten_Stich
            {"Verlierer", "loser"}, // XT_Verlierer
            {"Skat aufnehmen?", "Pick up Skat?"}, // XT_Skat_aufnehmen
            {"Spielwert verdoppelt!", "Game value doubled!"}, // XT_Spielwert_verdoppelt
            {"nimmt den Skat nicht auf.", "doesn't pick up the Skat."}, // XT_nimmt_den_Skat_nicht_auf
            {"klopft.", "knocks."}, // XT_klopft
            {"Klopfen", "Klopfen"}, // XT_Klopfen
            {"Spielwert verdoppeln?", "Double game value?"}, // XT_Spielwert_verdoppeln
            {"Buben", "Buben"}, // XT_Buben
            {"Jacks", "Jacks"}, // XT_Jacks
            {"Unter", "Unter"}, // XT_Unter
            {"dürfen nicht geschoben werden.", "may not be passed on."}, // XT_duerfen_nicht_geschoben_werden
            {"Re", "Re"}, // XT_Re
            {"von ", "by "}, // XT_von
            {"mit Kontra", "with Kontra"}, // XT_mit_Kontra
            {" & ", " & "}, // XT_und
            {"Vorschläge", "Hints"}, // XT_Vorschlaege
            {"Nochmal", "Replay"}, // XT_Nochmal
            {"Spiel wiederholen", "Replay game"}, // XT_Spiel_wiederholen
            {"mit den Karten von", "with the cards from"}, // XT_mit_den_Karten_von
            {"mir", "me"}, // XT_mir
            {"Zurück", "Back"}, // XT_Zurueck
            {"Start", "Start"}, // XT_Start
            {"Animationsgeschwindigkeit", "Animation speed"}, // XT_AnimationSpeed
            {"https://github.com/rnauber/xskat-android", "https://github.com/rnauber/xskat-android"}, // XT_github_xskat / 124
            {"Statistiken", "Statistics"}, // XT_MenuStatistics / 125
            {"Summe", "Sum"}, // XT_Sum / 126
            {"Verteilung der erreichten Punkte", "Distribution of reached points"}, // XT_PointDistribution / 127
            {"Spielstatistik für {0}", "Game statistic for {0}"}, // XT_GameStatistics / 128
            {"alle", "all"}, // XT_All / 129
            {"(G/V)", "(W/L)"}, // XT_WonLost / 130
            {"Insgesamt", "Total"}, // XT_Total / 131
            {"Normal", "Normal"}, // XT_Normal / 132
            {"Ouv. H.", "Ouv. H."}, // XT_Ouvert_Hand / 133
    };

    public static final int XT_Null = 0;
    public static final int XT_Karo = 1;
    public static final int XT_Herz = 2;
    public static final int XT_Pik = 3;
    public static final int XT_Kreuz = 4;
    public static final int XT_Grand = 5;
    public static final int XT_Ramsch = 6;
    public static final int XT_Sortiere_fuer_Null = 7;
    public static final int XT_Sortiere_normal = 8;
    public static final int XT_Gereizt_bis = 9;
    public static final int XT_Androido = 10;
    public static final int XT_Androida = 11;
    public static final int XT_spielt = 12;
    public static final int XT_Hand = 13;
    public static final int XT_fuer = 14;
    public static final int XT_Spitze = 15;
    public static final int XT_Annehmen = 16;
    public static final int XT_Schenken = 17;
    public static final int XT_Passe = 18;
    public static final int XT_Im_Skat = 19;
    public static final int XT_war = 20;
    public static final int XT_ist = 21;
    public static final int XT_Eine_Jungfrau = 22;
    public static final int XT_Durchmarsch = 23;
    public static final int XT_Ueberreizt = 24;
    public static final int XT_Gegner_nicht_Schneider = 25;
    public static final int XT_Gegner_nicht_schwarz = 26;
    public static final int XT_Spitze_verloren = 27;
    public static final int XT_Spieler = 28;
    public static final int XT_Niemand = 29;
    public static final int XT_gewinnt = 30;
    public static final int XT_verliert = 31;
    public static final int XT_das_Nullspiel = 32;
    public static final int XT_den_Ramsch = 33;
    public static final int XT_schwarz = 34;
    public static final int XT_mit = 35;
    public static final int XT_Augen = 36;
    public static final int XT_Spielwert = 37;
    public static final int XT_Ja = 38;
    public static final int XT_Weiter = 39;
    public static final int XT_Dieses_Programm_ist_freie_Software = 40;
    public static final int XT_es_kann_frei_verbreitet_werden = 41;
    public static final int XT_Nur_bei_Handspielen_kann_Schneider = 42;
    public static final int XT_oder_schwarz_angesagt_werden = 43;
    public static final int XT_Ouvert_schliesst_schwarz_angesagt_ein = 44;
    public static final int XT_ausser_bei_Null_natuerlich = 45;
    public static final int XT_HandFrage = 46;
    public static final int XT_Nein = 47;
    public static final int XT_Spiel = 48;
    public static final int XT_GV = 49;
    public static final int XT_Loeschen = 50;
    public static final int XT_Ueber_XSkat = 51;
    public static final int XT_Optionen = 52;
    public static final int XT_Letzter_Stich = 53;
    public static final int XT_Loesche = 54;
    public static final int XT_Spielstand = 55;
    public static final int XT_und_Liste = 56;
    public static final int XT_Liste = 57;
    public static final int XT_Protokoll = 58;
    public static final int XT_Schneider = 59;
    public static final int XT_Schwarz = 60;
    public static final int XT_Ouvert = 61;
    public static final int XT_Spielen = 62;
    public static final int XT_Revolution = 63;
    public static final int XT_Du_hast_hoeher_gereizt_als_der = 64;
    public static final int XT_Wert_des_angesagten_Spiels = 65;
    public static final int XT_Null_23_Hand_35 = 66;
    public static final int XT_ouvert_46_ouvert_Hand_59 = 67;
    public static final int XT_Revolution_92 = 68;
    public static final int XT_Druecken = 69;
    public static final int XT_Fertig = 70;
    public static final int XT_Spielstaerke = 71;
    public static final int XT_Sprache = 72;
    public static final int XT_Display_irgendwo_antippen = 73;
    public static final int XT_um_Stich_zu_entfernen = 74;
    public static final int XT_NeuesSpiel = 75;
    public static final int XT_xskat_de = 76;
    public static final int XT_Blatt = 77;
    public static final int XT_Turnier = 78;
    public static final int XT_Franzoesisch = 79;
    public static final int XT_Deutsch = 80;
    public static final int XT_Schellen = 81;
    public static final int XT_Rot = 82;
    public static final int XT_Gruen = 83;
    public static final int XT_Eicheln = 84;
    public static final int XT_Sortierung = 85;
    public static final int XT_Alternierend = 86;
    public static final int XT_Sequentiell = 87;
    public static final int XT_Nimm_Stich_nach = 88;
    public static final int XT_Antippen = 89;
    public static final int XT_Sekunden = 90;
    public static final int XT_Varianten = 91;
    public static final int XT_Immer = 92;
    public static final int XT_Kontra = 93;
    public static final int XT_Ab_18 = 94;
    public static final int XT_Bock = 95;
    public static final int XT_Plus_Ramsch = 96;
    public static final int XT_Zaehlt_2 = 97;
    public static final int XT_Schieberamsch = 98;
    public static final int XT_Skat_geht_an = 99;
    public static final int XT_letzten_Stich = 100;
    public static final int XT_Verlierer = 101;
    public static final int XT_Skat_aufnehmen = 102;
    public static final int XT_Spielwert_verdoppelt = 103;
    public static final int XT_nimmt_den_Skat_nicht_auf = 104;
    public static final int XT_klopft = 105;
    public static final int XT_Klopfen = 106;
    public static final int XT_Spielwert_verdoppeln = 107;
    public static final int XT_Buben = 108;
    public static final int XT_Jacks = 109;
    public static final int XT_Unter = 110;
    public static final int XT_duerfen_nicht_geschoben_werden = 111;
    public static final int XT_Re = 112;
    public static final int XT_von = 113;
    public static final int XT_mit_Kontra = 114;
    public static final int XT_und = 115;
    public static final int XT_Vorschlaege = 116;
    public static final int XT_Nochmal = 117;
    public static final int XT_Spiel_wiederholen = 118;
    public static final int XT_mit_den_Karten_von = 119;
    public static final int XT_mir = 120;
    public static final int XT_Zurueck = 121;
    public static final int XT_Start = 122;
    public static final int XT_AnimationSpeed = 123;
    public static final int XT_github_xskat = 124;
    public static final int XT_MenuStatistics = 125;
    public static final int XT_Sum = 126;
    public static final int XT_PointDistribution = 127;
    public static final int XT_GameStatistics = 128;
    public static final int XT_All = 129;
    public static final int XT_WonLost = 130;
    public static final int XT_Total= 131;
    public static final int XT_Normal = 132;
    public static final int XT_Ouvert_Hand = 133;

    public static String getTranslation(int key, int currentLanguage) {
        return TRANSLATIONS[key][currentLanguage];
    }
}
