/* 
 *	Copyright (c) 2011 Ronny Rhricht
 *
 *	This file is part of Moloko.
 *
 *	Moloko is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	Moloko is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with Moloko.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	Contributors:
 * Ronny Rhricht - implementation
 */

package dev.drsoran.moloko.sync;

import com.mdt.rtm.Service;
import com.mdt.rtm.ServiceException;
import com.mdt.rtm.data.RtmTimeline;

import dev.drsoran.moloko.MolokoApp;


public final class TimeLineFactory
{
   private final Service service;
   
   private RtmTimeline timeline;
   
   
   
   public TimeLineFactory( Service service )
   {
      this.service = service;
   }
   
   
   
   public final RtmTimeline createTimeline() throws ServiceException
   {
      if ( timeline == null )
         timeline = createTimelineImpl();
      
      return timeline;
   }
   
   
   
   public final RtmTimeline createOneShotTimeline() throws ServiceException
   {
      return createTimelineImpl();
   }
   
   
   
   private final RtmTimeline createTimelineImpl() throws ServiceException
   {
      final RtmTimeline newTimeline = service.timelines_create();
      MolokoApp.Log.i( getClass(), "Created new time line " + newTimeline );
      
      return newTimeline;
   }
}
