/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.acra.ACRA;
import org.acra.log.ACRALog;
import org.acra.log.AndroidLogDelegate;
import org.acra.util.FakeSocketFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public final class HttpRequest {
    private static ACRALog log = new AndroidLogDelegate();
    private String login;
    private String password;
    private int connectionTimeOut = 3000;
    private int socketTimeOut = 3000;
    private int maxNrRetries = 3;

    static void setLog(ACRALog log) {
        HttpRequest.log = log;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public void setSocketTimeOut(int socketTimeOut) {
        this.socketTimeOut = socketTimeOut;
    }

    public void setMaxNrRetries(int maxNrRetries) {
        this.maxNrRetries = maxNrRetries;
    }

    public void sendPost(URL url, Map<?, ?> parameters) throws IOException {
        HttpClient httpClient = this.getHttpClient();
        HttpPost httpPost = this.getHttpPost(url, parameters);
        log.d(ACRA.LOG_TAG, "Sending request to " + url);
        for (Object key : parameters.keySet()) {
        }
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)new BasicHttpContext());
        if (response != null) {
            String statusCode;
            StatusLine statusLine = response.getStatusLine();
            if (statusLine != null && ((statusCode = Integer.toString(response.getStatusLine().getStatusCode())).startsWith("4") || statusCode.startsWith("5"))) {
                throw new IOException("Host returned error code " + statusCode);
            }
            String content = EntityUtils.toString((HttpEntity)response.getEntity());
        }
    }

    private HttpClient getHttpClient() {
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setParameter("http.protocol.cookie-policy", (Object)"rfc2109");
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.connectionTimeOut);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.socketTimeOut);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)new PlainSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)new FakeSocketFactory(), 443));
        ThreadSafeClientConnManager clientConnectionManager = new ThreadSafeClientConnManager((HttpParams)httpParams, registry);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)clientConnectionManager, (HttpParams)httpParams);
        SocketTimeOutRetryHandler retryHandler = new SocketTimeOutRetryHandler((HttpParams)httpParams, this.maxNrRetries);
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)retryHandler);
        return httpClient;
    }

    private UsernamePasswordCredentials getCredentials() {
        if (this.login != null || this.password != null) {
            return new UsernamePasswordCredentials(this.login, this.password);
        }
        return null;
    }

    private HttpPost getHttpPost(URL url, Map<?, ?> parameters) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url.toString());
        UsernamePasswordCredentials creds = this.getCredentials();
        if (creds != null) {
            httpPost.addHeader(BasicScheme.authenticate((Credentials)creds, (String)"UTF-8", (boolean)false));
        }
        httpPost.setHeader("User-Agent", "Android");
        httpPost.setHeader("Accept", "text/html,application/xml,application/xhtml+xml,text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5");
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        String paramsAsString = this.getParamsAsString(parameters);
        httpPost.setEntity((HttpEntity)new StringEntity(paramsAsString, "UTF-8"));
        return httpPost;
    }

    private String getParamsAsString(Map<?, ?> parameters) throws UnsupportedEncodingException {
        StringBuilder dataBfr = new StringBuilder();
        for (Object key : parameters.keySet()) {
            Object preliminaryValue;
            if (dataBfr.length() != 0) {
                dataBfr.append('&');
            }
            String value = (preliminaryValue = parameters.get(key)) == null ? "" : preliminaryValue;
            dataBfr.append(URLEncoder.encode(key.toString(), "UTF-8"));
            dataBfr.append('=');
            dataBfr.append(URLEncoder.encode(value.toString(), "UTF-8"));
        }
        return dataBfr.toString();
    }

    private static class SocketTimeOutRetryHandler
    implements HttpRequestRetryHandler {
        private final HttpParams httpParams;
        private final int maxNrRetries;

        private SocketTimeOutRetryHandler(HttpParams httpParams, int maxNrRetries) {
            this.httpParams = httpParams;
            this.maxNrRetries = maxNrRetries;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (exception instanceof SocketTimeoutException) {
                if (executionCount <= this.maxNrRetries) {
                    if (this.httpParams != null) {
                        int newSocketTimeOut = HttpConnectionParams.getSoTimeout((HttpParams)this.httpParams) * 2;
                        HttpConnectionParams.setSoTimeout((HttpParams)this.httpParams, (int)newSocketTimeOut);
                        log.d(ACRA.LOG_TAG, "SocketTimeOut - increasing time out to " + newSocketTimeOut + " millis and trying again");
                    } else {
                        log.d(ACRA.LOG_TAG, "SocketTimeOut - no HttpParams, cannot increase time out. Trying again with current settings");
                    }
                    return true;
                }
                log.d(ACRA.LOG_TAG, "SocketTimeOut but exceeded max number of retries : " + this.maxNrRetries);
            }
            return false;
        }
    }
}

