// Generated by CoffeeScript 1.12.8
(function() {
  $(function() {
    var $canvas, $game, $level, $levels, $moves, $next, $play, $pushes, $set, $sets, btns, completed_level, current, done, fn, get_lvl, j, k, kc, len, level_completed, levels, next_level, on_done, on_update, oops, opts, play, quit, ref, scroll, set_levels, set_lvl, start, v, x;
    $sets = $('#sets');
    $levels = $('#levels');
    $play = $('#play');
    $next = $('#next');
    $canvas = $('#CANVAS');
    $game = $('#game');
    $set = $('#set');
    $level = $('#level');
    $moves = $('#moves');
    $pushes = $('#pushes');
    levels = quit = done = null;
    current = {
      set: 3,
      level: 0
    };
    completed_level = function(c) {
      var e;
      if (c == null) {
        c = current;
      }
      localStorage.setItem("level " + c.set + " " + c.level, "done");
      e = $levels.children()[c.level];
      return $(e).text(function(i, t) {
        if (t.endsWith("✓")) {
          return t;
        } else {
          return t + " ✓";
        }
      });
    };
    level_completed = function(c) {
      if (c == null) {
        c = current;
      }
      return localStorage.getItem("level " + c.set + " " + c.level) === "done";
    };
    scroll = function() {
      var x, y;
      x = ($canvas.width() - $game.width()) / 2;
      y = ($canvas.height() - $game.height()) / 2;
      $game.scrollLeft(x).scrollTop(y);
      return $('#data-and-buttons')[0].scrollIntoView(false);
    };
    get_lvl = function() {
      var h, j, len, ref, results, x;
      ref = (/^\d+_\d+$/.test(h = location.hash.slice(1)) ? h : localStorage.getItem("level") || "3_0").split("_");
      results = [];
      for (j = 0, len = ref.length; j < len; j++) {
        x = ref[j];
        results.push(parseInt(x));
      }
      return results;
    };
    set_lvl = function() {
      return localStorage.setItem("level", location.hash = current.set + "_" + current.level);
    };
    on_done = function(w) {
      if (!w.quit) {
        completed_level();
      }
      quit = null;
      return typeof done === "function" ? done() : void 0;
    };
    on_update = function(m, p) {
      $moves.text(m);
      return $pushes.text(p);
    };
    oops = function() {
      return _alert('We apologise for the inconvenience...');
    };
    opts = {
      canvas: $canvas[0],
      on_done: on_done,
      on_update: on_update
    };
    ref = 'goal person person_goal object object_goal wall'.split(/\ +/);
    for (j = 0, len = ref.length; j < len; j++) {
      x = ref[j];
      opts[x + "_img"] = $("#" + x + "_img")[0];
    }
    start = function(level) {
      $canvas.focus();
      done = null;
      return quit = sokobang.start(opts, level);
    };
    play = function(set, level) {
      $play.prop('disabled', true);
      current = {
        set: set,
        level: level
      };
      set_lvl();
      $('#completed')[level_completed() ? "show" : "hide"]();
      $set.text(levels[set].name);
      $level.text(level + 1);
      on_update(0, 0);
      done = function() {
        return $.get("levels/level_" + set + "_" + level + ".json").done(function(data) {
          $play.prop('disabled', false);
          return start(data);
        }).fail(oops);
      };
      if (quit) {
        quit();
      } else {
        done();
      }
      return setTimeout(scroll, 500);
    };
    next_level = function() {
      var l, s;
      s = current.set;
      l = current.level;
      if (l < levels[s].levels - 1) {
        $sets.val(s);
        $levels.val(l + 1);
      } else {
        if (s < levels.length - 1) {
          $sets.val(s + 1);
          set_levels();
        } else {
          _alert('There are no more levels.');
        }
      }
      return $play.click();
    };
    set_levels = function() {
      var i, n, o, ref1, t;
      n = parseInt($sets.val());
      $levels.empty();
      for (i = o = 0, ref1 = levels[n].levels - 1; 0 <= ref1 ? o <= ref1 : o >= ref1; i = 0 <= ref1 ? ++o : --o) {
        t = i + 1;
        if (level_completed({
          set: n,
          level: i
        })) {
          t += " ✓";
        }
        $levels.append($('<option>').val(i).text(t));
      }
      return null;
    };
    kc = bigbang.keycodes;
    btns = {
      left: kc.LEFT,
      down: kc.DOWN,
      up: kc.UP,
      right: kc.RIGHT,
      undo: 'U'.charCodeAt()
    };
    fn = function(k, v) {
      return $("#" + k).on('click', function() {
        return $canvas.trigger($.Event('keydown', {
          which: v
        }));
      });
    };
    for (k in btns) {
      v = btns[k];
      fn(k, v);
    }
    $('body').on('keydown', function(e) {
      if (Object.values(btns).includes(e.which)) {
        return $canvas.trigger(e);
      }
    });
    $('#zoom').change(function() {
      $canvas.toggleClass("zoom", this.checked);
      return setTimeout(scroll, 500);
    });
    return $.get('levels/levels.json').done(function(data) {
      var i, len1, lvl, o, ref1, set;
      levels = data;
      for (i = o = 0, len1 = levels.length; o < len1; i = ++o) {
        x = levels[i];
        $sets.append($('<option>').val(i).text(x.name));
      }
      $sets.change(set_levels);
      $play.click(function() {
        return play(parseInt($sets.val()), parseInt($levels.val()));
      });
      $next.click(next_level);
      $canvas.attr('tabindex', 0);
      ref1 = get_lvl(), set = ref1[0], lvl = ref1[1];
      current = {
        set: set,
        lvl: lvl
      };
      $sets.val(set);
      set_levels();
      $levels.val(lvl);
      return $play.click();
    }).fail(oops);
  });

}).call(this);
