/**
 * <p>
 * FileUploadProgressEvent 
 * 	<p>
 * Event Class that is fired during the file upload for tracking the progress of the upload
 * 
 * @author      Photobucket
 * @version     %I%, %G%
 * @see java.util.EventObject
 */


package com.photobucket.api.core;

import java.util.EventObject;

@SuppressWarnings("serial")
public class FileUploadProgressEvent extends EventObject {
	private ObservableUpload observableUpload;
	private String filePath;
	private int percentComplete;

	/**
	 * Constructor 
	 * 
	 * @param source
	 */
	public FileUploadProgressEvent(ObservableUpload observableUpload, String filePath, int percentComplete) {
         super(observableUpload);
         this.observableUpload = observableUpload;
         this.filePath = filePath;
         this.percentComplete = percentComplete;
    }

	public ObservableUpload getUploadInformation() {
		return observableUpload;
	}
	
	/**
	 * Retrieve the file path for the file the event was fired
	 * @return filePath String
	 */
	public String getFilePath() {
		return filePath;
	}
	
	/**
	 * Retrieve the percentage complete for the upload
	 * 
	 * @return percentComplete Percentage Complete between 0-100
	 */

	public int getPercentComplete() {
		return percentComplete;
	}
}
