package com.photobucket.api.core;

public class NullLog implements Log {
	
	public static final NullLog INSTANCE = new NullLog();
	
	/**
	 * Private constructor since we don't really want to force use of the Singleton
	 */
	private NullLog() {
		
	}
	
    public void debug(String source, String message) {
    }

    public void debug(String source, String message, Throwable throwable) {
    }

    public void info(String source, String message) {
    }

    public void info(String source, String message, Throwable throwable) {
    }

    public void warn(String source, String message) {
    }

    public void warn(String source, String message, Throwable throwable) {
    }

    public void error(String source, String message) {
    }

    public void error(String source, String message, Throwable throwable) {
    }

    public boolean isDebugEnabled(String source) {
	    return false;
    }

    public boolean isInfoEnabled(String source) {
	    return false;
    }

    public boolean isWarnEnabled(String source) {
	    return false;
    }

    public boolean isErrorEnabled(String source) {
	    return false;
    }
}
