package com.photobucket.api.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.OAuthMessageSigner;

import com.photobucket.api.core.Log;

@SuppressWarnings("serial")
public class PhotobucketHttpOAuthConsumer extends CommonsHttpOAuthConsumer {
	
	//protected SignatureMethod signatureMethod;
	//protected OAuthMessageSigner messageSigner;
	//protected CustomOAuthMessageSigner messageSigner;
	
	private Long oauthTimestamp;
	
	public PhotobucketHttpOAuthConsumer(String consumerKey, String consumerSecret, OAuthMessageSigner messageSigner, Log log) {
		super(consumerKey, consumerSecret);
		setMessageSigner(messageSigner);
		setSigningStrategy(new AuthorizationHeaderSigningStrategy());
	}

	/*
	public HttpRequest sign(HttpRequest request)
			throws OAuthMessageSignerException, OAuthExpectationFailedException {
		if (getConsumerKey() == null) {
			throw new OAuthExpectationFailedException("consumer key not set");
		}
		if (getConsumerSecret() == null) {
			throw new OAuthExpectationFailedException("consumer secret not set");
		}

		Map<String, String> oauthParams = buildOAuthParameterMap();

		//HttpRequest pbRequest = modifyRequest(request);
		String signature = this.messageSigner.sign(request, oauthParams);
		log.debug(TAG, "Signature: " + signature);

		request.setHeader(OAuth.HTTP_AUTHORIZATION_HEADER, buildOAuthHeader(oauthParams, signature));
		
		return request;
	}
	*/

	/*
	private Map<String, String> buildOAuthParameterMap() {
		HashMap<String, String> map = new HashMap<String, String>();

		map.put(OAuth.OAUTH_CONSUMER_KEY, getConsumerKey());
		map.put(OAuth.OAUTH_SIGNATURE_METHOD, this.signatureMethod.toString());
		map.put(OAuth.OAUTH_TIMESTAMP, getPhotobucketOauthTime());
		map.put(OAuth.OAUTH_NONCE, Long.toString(System.nanoTime()));
		map.put(OAuth.OAUTH_VERSION, OAuth.VERSION_1_0);
		map.put(OAuth.OAUTH_TOKEN, getToken());
		return map;
	}
	*/

	/*
	private String buildOAuthHeader(Map<String, String> oauthParams,
			String signature) {
		StringBuilder sb = new StringBuilder();

		sb.append("OAuth ");

		for (String key : oauthParams.keySet()) {
			String value = oauthParams.get(key);
			sb.append(oauthHeaderElement(key, value));
			sb.append(",");
		}

		sb.append(oauthHeaderElement(OAuth.OAUTH_SIGNATURE, signature));
		String oauthValue = sb.toString();
		
		log.debug(TAG, "OAUTH Value: " + oauthValue);
		
		return oauthValue; 
	}
	*/

	/*
	private String oauthHeaderElement(String name, String value) {
		return OAuth.percentEncode(name) + "=\"" + OAuth.percentEncode(value) + "\"";
	}
	*/

    /**
     * Returns the number of seconds since January 1, 1970, 00:00:00 GMT.  First, trying to 
     * retrieve the time from the Photobucket API.  If the API call fails, the client time is 
     * returned.
     * @return
     */
	@Override
	protected String generateTimestamp() {
    	String time = null;
    	if(this.getOauthTimestamp() != null) {
    		time = this.getOauthTimestamp().toString();
    	} else {
			try {
				URL timeUrl = new URL("http://api.photobucket.com/time");
				BufferedReader reader = new BufferedReader(new InputStreamReader(timeUrl.openStream()));
				time = reader.readLine();
				reader.close();
			} catch (MalformedURLException e) {
				// API time failed... leave time as null
			} catch (IOException e) {
				// API time failed... leave time as null
			} 
	    	
			if(time == null) {
				// Fetching the time from the api server failed
				// Fail over to client time
				time = String.valueOf(new Date().getTime() / 1000);
			}
    	}
		return time;
    }
    
    /*
    public void setTokenWithSecret(String token, String tokenSecret) {
        super.setTokenWithSecret(token, tokenSecret);
        this.messageSigner.setTokenSecret(tokenSecret);
    }
    */

	public Long getOauthTimestamp() {
		return oauthTimestamp;
	}

	public void setOauthTimestamp(Long oauthTimestamp) {
		this.oauthTimestamp = oauthTimestamp;
	}
	
}
