/**
 * <p>
 * RESTfulResponse Class 
 * <p>
 * Class wraps the response message from the API
 * 
 * @author      Photobucket
 * @version     %I%, %G%
 * 
 */
package com.photobucket.api.rest;

public class RESTfulResponse {
	
	private int responseCode = 0;
	private String responseString = new String();
	
	/**
	 * Constructor
	 * 
	 * @param responseCode integer response code from the api
	 * @param responseString String response message from teh api
	 */
	public RESTfulResponse(int responseCode, String responseString) {
		this.responseCode = responseCode;
		this.responseString = responseString;
	}

	/**
	 * Retrieve the response code
	 * 
	 * @return responseCode int
	 */
	public int getResponseCode() {
		return responseCode;
	}
	
	/**
	 * Set the response code
	 * 
	 * @param responseCode int response message from the api
	 */

	public void setResponseCode(int responseCode) {
		this.responseCode = responseCode;
	}

	/**
	 * Retrieve response message from the api
	 * 
	 * @return responseString String
	 */
	public String getResponseString() {
		return responseString;
	}

	/**
	 * Set the response message from the api
	 * 
	 * @param responseString String
	 */
	public void setResponseString(String responseString) {
		this.responseString = responseString;
	}
}
