package com.photobucket.api.core;

/**
 * Defines a generic logging interface that can be implemented by users of the API, to provide the API with a means
 * to report diagnostic output.
 * 
 * Note AV 9/12/10: I'm basing this on the Android logging API, but I wish it was more like Apache Commons Logging,
 * or Log4J.  However, this simplified API can still be put on top of one of those frameworks.
 *   
 * @author avanha
 */
public interface Log {
	public void debug(String source, String message);
	public void debug(String source, String message, Throwable throwable);
	public void info(String source, String message);
	public void info(String source, String message, Throwable throwable);
	public void warn(String source, String message);
	public void warn(String source, String message, Throwable throwable);
	public void error(String source, String message);
	public void error(String source, String message, Throwable throwable);
	
	public boolean isDebugEnabled(String source);
	public boolean isInfoEnabled(String source);
	public boolean isWarnEnabled(String source);
	public boolean isErrorEnabled(String source);
}
