package com.photobucket.api.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import com.photobucket.api.core.IFileUploadProgressEventListener;

public class RESTfulRequest {
	/** Photobucket Base domain - always api.photobucket.com */
	private static final String PHOTOBUCKET_BASE_DOMAIN = "api.photobucket.com";
	
	public enum Method {
		GET,
		POST,
		PUT,
		DELETE
	}
	
	private String requestPath = new String();
    private Method method = Method.GET;
    private Map<String,String> parameters = new HashMap<String,String>();
    private boolean isMultipart = false;
    private boolean followRedirects = true;
    private File uploadFile = null;
    private FileInputStream uploadFileInputStream = null;
    private String uploadFileName = null;
    private Integer uploadFileSize = null;
    private String subdomain = new String(PHOTOBUCKET_BASE_DOMAIN);
   
    // Photobucket specific
    // TODO:  refactor so this class is more generic to REST
    protected Vector<IFileUploadProgressEventListener> listenerList = new Vector<IFileUploadProgressEventListener>();
	public static final String UPLOAD_FILE_KEY = "uploadfile";
	public static final String UPLOAD_FILE_LENGTH_KEY = "uploadfile_length";
	public static final String UPLOAD_FILE_NAME_KEY = "filename";
    
	public Map<String, String> getParameters() {
		return parameters;
	}
	public void setParameters(Map<String, String> parameters) {
		this.parameters = parameters;
	}
    public void addParameter(String key, String value) {
    	this.parameters.put(key, value);
    }
    public String getParameter(String key) {
    	return this.parameters.get(key);
    }
	public boolean isMultipart() {
		return isMultipart;
	}
	public void setMultipart(boolean isMultipart) {
		this.isMultipart = isMultipart;
	}
	public Method getMethod() {
		return method;
	}
	public void setMethod(Method method) {
		this.method = method;
	}
	public boolean shouldFollowRedirects() {
		return followRedirects;
	}
	public void setFollowRedirects(boolean followRedirects) {
		this.followRedirects = followRedirects;
	}
	public File getUploadFile() {
		return uploadFile;
	}
	
	public void setUploadFile(File uploadFile) throws IOException {
		this.uploadFile = uploadFile;

		// Make sure the file size will fit into an int.
		long size = uploadFile.length();
		
		if (size > Integer.MAX_VALUE)
			throw new IOException("Upload file size exceeds Integer.MAX_VALUE (" + Integer.MAX_VALUE + ")");

		this.uploadFileSize = new Integer((int)size); 
	}
	
	public Vector<IFileUploadProgressEventListener> getListenerList() {
		return listenerList;
	}
	public void setListenerList(
			Vector<IFileUploadProgressEventListener> listenerList) {
		this.listenerList = listenerList;
	}
	public String getSubdomain() {
		return subdomain;
	}
	public void setSubdomain(String subdomain) {
		this.subdomain = subdomain;
	}
	public String getRequestPath() {
		return requestPath;
	}
	public void setRequestPath(String requestPath) {
		this.requestPath = requestPath;
	}
	
	public String getRequestUrl() {
		return "http://"+getSubdomain()+getRequestPath();
	}
	
	public String getBaseDomainRequestUrl() {
		return "http://"+PHOTOBUCKET_BASE_DOMAIN+getRequestPath();
	}

	public void setFormat(String format) {
		addParameter("format", format);
	}
	public FileInputStream getFileInputStream() {
		return uploadFileInputStream;
	}
	
	public void setFileInputStreamAndFilename(FileInputStream uploadFileInputStream, String uploadFileName) 
		throws IOException {
		this.uploadFileInputStream = uploadFileInputStream;
		this.uploadFileName = uploadFileName;
		this.uploadFileSize = new Integer(uploadFileInputStream.available());
	}
	
	public String getUploadFileName() {
		return uploadFileName;
	}
	
	public void setUploadFileName(String uploadFileName) {
		this.uploadFileName = uploadFileName;
	}
	
	public Integer getUploadFileSize() {
		return uploadFileSize;
	}
	
	public boolean isFileUpload() {
		return (this.uploadFileInputStream != null || this.uploadFile != null);
	}
}
