// This software is released into the Public Domain by the author Victor H Olvera

package dudeofx.eval;

public class tSyntaxNode {
   public static final int cVALUE       = 1;
   public static final int cIDENTIFIER  = 2;
   public static final int cOPERATOR    = 3;
   public static final int cFUNCTION    = 4;
   public static final int cVARIABLE    = 5;
   public static final int cPARSE       = 6;
   public static final int cMISC        = 7;
   public static final int cERROR       = -1;

   int    type;
   double value;
   String ident;
   String aux_msg;
   int    token;

   tSyntaxNode parent = null;
   tSyntaxNode sibling = null;
   tSyntaxNode child = null;

   //-----------------------------------------------------------------------------
   tSyntaxNode(double value) {
      this.type = cVALUE;
      this.value = value;
      this.token = -1;
      this.aux_msg = null;
      this.ident = null;
   }
   //-----------------------------------------------------------------------------
   tSyntaxNode(int type, int token) {
      this.type = type;
      this.value = Double.NaN;
      this.token = token;
      this.aux_msg = null;
      this.ident = null;
   }
   //-----------------------------------------------------------------------------
   tSyntaxNode(int type, String st) {
      this.type = type;
      this.value = Double.NaN;
      this.token = -1;
      if ((type == cVARIABLE) || (type == cFUNCTION) || (type == cIDENTIFIER)){
         this.aux_msg = null;
         this.ident = st;
      } else {
         this.aux_msg = st;
         this.ident = null;
      }
   }
   //-----------------------------------------------------------------------------
   tSyntaxNode(int type, String ident, String msg) {
      this.type = type;
      this.value = Double.NaN;
      this.token = -1;
      this.aux_msg = msg;
      this.ident = ident;
   }
   //-----------------------------------------------------------------------------
   void AddChild(tSyntaxNode child) {
      child.parent = this;
      child.sibling = this.child;
      this.child = child;
   }
   //-----------------------------------------------------------------------------
}

