/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.AudioManager;
import android.media.SoundPool;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.IntArray;

final class AndroidSound
implements Sound {
    final SoundPool soundPool;
    final AudioManager manager;
    final int soundId;
    final IntArray streamIds = new IntArray(8);

    AndroidSound(SoundPool pool, AudioManager manager, int soundId) {
        this.soundPool = pool;
        this.manager = manager;
        this.soundId = soundId;
    }

    public void dispose() {
        this.soundPool.unload(this.soundId);
    }

    public long play() {
        return this.play(1.0f);
    }

    public long play(float volume) {
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        int streamId = this.soundPool.play(this.soundId, volume, volume, 1, 0, 1.0f);
        this.streamIds.add(streamId);
        return streamId;
    }

    public void stop() {
        int n = this.streamIds.size;
        for (int i = 0; i < n; ++i) {
            this.soundPool.stop(this.streamIds.get(i));
        }
    }

    public void stop(long soundId) {
        this.soundPool.stop((int)soundId);
    }

    public void setPitch(long soundId, float pitch) {
        this.soundPool.setRate((int)soundId, pitch);
    }

    public void setVolume(long soundId, float volume) {
        this.soundPool.setVolume((int)soundId, volume, volume);
    }

    public long loop() {
        return this.loop(1.0f);
    }

    public long loop(float volume) {
        if (this.streamIds.size == 8) {
            this.streamIds.pop();
        }
        int streamId = this.soundPool.play(this.soundId, volume, volume, 1, -1, 1.0f);
        this.streamIds.add(streamId);
        return streamId;
    }

    public void setLooping(long soundId, boolean looping) {
        this.soundPool.setLoop((int)soundId, looping ? -1 : 0);
    }

    public void setPan(long soundId, float pan, float volume) {
        float leftVolume = volume;
        float rightVolume = volume;
        if (pan < 0.0f) {
            rightVolume *= 1.0f - Math.abs(pan);
        } else if (pan > 0.0f) {
            leftVolume *= 1.0f - Math.abs(pan);
        }
        this.soundPool.setVolume((int)soundId, leftVolume, rightVolume);
    }
}

