/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class NinePatch {
    public static final int TOP_LEFT = 0;
    public static final int TOP_CENTER = 1;
    public static final int TOP_RIGHT = 2;
    public static final int MIDDLE_LEFT = 3;
    public static final int MIDDLE_CENTER = 4;
    public static final int MIDDLE_RIGHT = 5;
    public static final int BOTTOM_LEFT = 6;
    public static final int BOTTOM_CENTER = 7;
    public static final int BOTTOM_RIGHT = 8;
    private TextureRegion[] patches;
    private Color color;
    private boolean blending = true;

    private NinePatch() {
    }

    public NinePatch(Texture texture, int left, int right, int top, int bottom) {
        this(new TextureRegion(texture), left, right, top, bottom);
    }

    public NinePatch(TextureRegion region, int left, int right, int top, int bottom) {
        if (region == null) {
            throw new IllegalArgumentException("region cannot be null.");
        }
        int middleWidth = region.getRegionWidth() - left - right;
        int middleHeight = region.getRegionHeight() - top - bottom;
        this.patches = new TextureRegion[9];
        if (top > 0) {
            if (left > 0) {
                this.patches[0] = new TextureRegion(region, 0, 0, left, top);
            }
            if (middleWidth > 0) {
                this.patches[1] = new TextureRegion(region, left, 0, middleWidth, top);
            }
            if (right > 0) {
                this.patches[2] = new TextureRegion(region, left + middleWidth, 0, right, top);
            }
        }
        if (middleHeight > 0) {
            if (left > 0) {
                this.patches[3] = new TextureRegion(region, 0, top, left, middleHeight);
            }
            if (middleWidth > 0) {
                this.patches[4] = new TextureRegion(region, left, top, middleWidth, middleHeight);
            }
            if (right > 0) {
                this.patches[5] = new TextureRegion(region, left + middleWidth, top, right, middleHeight);
            }
        }
        if (bottom > 0) {
            if (left > 0) {
                this.patches[6] = new TextureRegion(region, 0, top + middleHeight, left, bottom);
            }
            if (middleWidth > 0) {
                this.patches[7] = new TextureRegion(region, left, top + middleHeight, middleWidth, bottom);
            }
            if (right > 0) {
                this.patches[8] = new TextureRegion(region, left + middleWidth, top + middleHeight, right, bottom);
            }
        }
        if (left == 0 && middleWidth == 0) {
            this.patches[1] = this.patches[2];
            this.patches[4] = this.patches[5];
            this.patches[7] = this.patches[8];
            this.patches[2] = null;
            this.patches[5] = null;
            this.patches[8] = null;
        }
        if (top == 0 && middleHeight == 0) {
            this.patches[3] = this.patches[6];
            this.patches[4] = this.patches[7];
            this.patches[5] = this.patches[8];
            this.patches[6] = null;
            this.patches[7] = null;
            this.patches[8] = null;
        }
    }

    public NinePatch(Texture texture, Color color) {
        this(texture);
        this.setColor(color);
    }

    public NinePatch(Texture texture) {
        this(new TextureRegion(texture));
    }

    public NinePatch(TextureRegion region, Color color) {
        this(region);
        this.setColor(color);
    }

    public NinePatch(TextureRegion region) {
        this.patches = new TextureRegion[]{null, null, null, null, region, null, null, null, null};
    }

    public NinePatch(TextureRegion ... patches) {
        if (patches == null || patches.length != 9) {
            throw new IllegalArgumentException("NinePatch needs nine TextureRegions");
        }
        this.patches = patches;
        this.checkValidity();
    }

    public NinePatch(NinePatch ninePatch) {
        this(ninePatch, ninePatch.color == null ? null : new Color(ninePatch.color));
    }

    public NinePatch(NinePatch ninePatch, Color color) {
        this.patches = new TextureRegion[9];
        System.arraycopy(ninePatch.patches, 0, this.patches, 0, 9);
        this.color = color;
    }

    private void checkValidity() {
        float leftWidth = this.getLeftWidth();
        if (this.patches[0] != null && (float)this.patches[0].getRegionWidth() != leftWidth || this.patches[3] != null && (float)this.patches[3].getRegionWidth() != leftWidth || this.patches[6] != null && (float)this.patches[6].getRegionWidth() != leftWidth) {
            throw new GdxRuntimeException("Left side patches must have the same width");
        }
        float rightWidth = this.getRightWidth();
        if (this.patches[2] != null && (float)this.patches[2].getRegionWidth() != rightWidth || this.patches[5] != null && (float)this.patches[5].getRegionWidth() != rightWidth || this.patches[8] != null && (float)this.patches[8].getRegionWidth() != rightWidth) {
            throw new GdxRuntimeException("Right side patches must have the same width");
        }
        float bottomHeight = this.getBottomHeight();
        if (this.patches[6] != null && (float)this.patches[6].getRegionHeight() != bottomHeight || this.patches[7] != null && (float)this.patches[7].getRegionHeight() != bottomHeight || this.patches[8] != null && (float)this.patches[8].getRegionHeight() != bottomHeight) {
            throw new GdxRuntimeException("Bottom side patches must have the same height");
        }
        float topHeight = this.getTopHeight();
        if (this.patches[0] != null && (float)this.patches[0].getRegionHeight() != topHeight || this.patches[1] != null && (float)this.patches[1].getRegionHeight() != topHeight || this.patches[2] != null && (float)this.patches[2].getRegionHeight() != topHeight) {
            throw new GdxRuntimeException("Top side patches must have the same height");
        }
    }

    public void draw(SpriteBatch batch, float x, float y, float width, float height) {
        float centerColumnX = x + this.getLeftWidth();
        float rightColumnX = x + width - this.getRightWidth();
        float middleRowY = y + this.getBottomHeight();
        float topRowY = y + height - this.getTopHeight();
        if (this.color != null) {
            Color batchColor = batch.getColor();
            batch.setColor(this.color.r, this.color.g, this.color.b, batchColor.a * this.color.a);
        }
        if (!this.blending && batch.getColor().a == 1.0f && this.color != null && this.color.a == 1.0f) {
            batch.disableBlending();
        }
        if (this.patches[6] != null) {
            batch.draw(this.patches[6], x, y, centerColumnX - x, middleRowY - y);
        }
        if (this.patches[7] != null) {
            batch.draw(this.patches[7], centerColumnX, y, rightColumnX - centerColumnX, middleRowY - y);
        }
        if (this.patches[8] != null) {
            batch.draw(this.patches[8], rightColumnX, y, x + width - rightColumnX, middleRowY - y);
        }
        if (this.patches[3] != null) {
            batch.draw(this.patches[3], x, middleRowY, centerColumnX - x, topRowY - middleRowY);
        }
        if (this.patches[4] != null) {
            batch.draw(this.patches[4], centerColumnX, middleRowY, rightColumnX - centerColumnX, topRowY - middleRowY);
        }
        if (this.patches[5] != null) {
            batch.draw(this.patches[5], rightColumnX, middleRowY, x + width - rightColumnX, topRowY - middleRowY);
        }
        if (this.patches[0] != null) {
            batch.draw(this.patches[0], x, topRowY, centerColumnX - x, y + height - topRowY);
        }
        if (this.patches[1] != null) {
            batch.draw(this.patches[1], centerColumnX, topRowY, rightColumnX - centerColumnX, y + height - topRowY);
        }
        if (this.patches[2] != null) {
            batch.draw(this.patches[2], rightColumnX, topRowY, x + width - rightColumnX, y + height - topRowY);
        }
        if (!this.blending) {
            batch.enableBlending();
        }
    }

    public float getLeftWidth() {
        if (this.patches[6] != null) {
            return this.patches[6].getRegionWidth();
        }
        if (this.patches[3] != null) {
            return this.patches[3].getRegionWidth();
        }
        if (this.patches[0] != null) {
            return this.patches[0].getRegionWidth();
        }
        return 0.0f;
    }

    public float getRightWidth() {
        if (this.patches[8] != null) {
            return this.patches[8].getRegionWidth();
        }
        if (this.patches[5] != null) {
            return this.patches[5].getRegionWidth();
        }
        if (this.patches[2] != null) {
            return this.patches[2].getRegionWidth();
        }
        return 0.0f;
    }

    public float getTopHeight() {
        if (this.patches[0] != null) {
            return this.patches[0].getRegionHeight();
        }
        if (this.patches[1] != null) {
            return this.patches[1].getRegionHeight();
        }
        if (this.patches[2] != null) {
            return this.patches[2].getRegionHeight();
        }
        return 0.0f;
    }

    public float getBottomHeight() {
        if (this.patches[6] != null) {
            return this.patches[6].getRegionHeight();
        }
        if (this.patches[7] != null) {
            return this.patches[7].getRegionHeight();
        }
        if (this.patches[8] != null) {
            return this.patches[8].getRegionHeight();
        }
        return 0.0f;
    }

    public float getTotalHeight() {
        float totalHeight = this.getTopHeight() + this.getBottomHeight();
        if (this.patches[4] != null) {
            totalHeight += (float)this.patches[4].getRegionHeight();
        }
        return totalHeight;
    }

    public float getTotalWidth() {
        float totalWidth = this.getLeftWidth() + this.getRightWidth();
        if (this.patches[4] != null) {
            totalWidth += (float)this.patches[4].getRegionWidth();
        }
        return totalWidth;
    }

    public TextureRegion[] getPatches() {
        return this.patches;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setBlending(boolean blending) {
        this.blending = blending;
    }
}

