/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;

public class TextureAtlas
implements Disposable {
    static final String[] tuple = new String[2];
    private final HashSet<Texture> textures = new HashSet(4);
    private final ArrayList<AtlasRegion> regions = new ArrayList();
    static final Comparator<TextureAtlasData.Region> indexComparator = new Comparator<TextureAtlasData.Region>(){

        @Override
        public int compare(TextureAtlasData.Region region1, TextureAtlasData.Region region2) {
            int i2;
            int i1 = region1.index;
            if (i1 == -1) {
                i1 = Integer.MAX_VALUE;
            }
            if ((i2 = region2.index) == -1) {
                i2 = Integer.MAX_VALUE;
            }
            return i1 - i2;
        }
    };

    public TextureAtlas() {
    }

    public TextureAtlas(String internalPackFile) {
        this(Gdx.files.internal(internalPackFile));
    }

    public TextureAtlas(FileHandle packFile) {
        this(packFile, packFile.parent());
    }

    public TextureAtlas(FileHandle packFile, boolean flip) {
        this(packFile, packFile.parent(), flip);
    }

    public TextureAtlas(FileHandle packFile, FileHandle imagesDir) {
        this(packFile, imagesDir, false);
    }

    public TextureAtlas(FileHandle packFile, FileHandle imagesDir, boolean flip) {
        this(new TextureAtlasData(packFile, imagesDir, flip));
    }

    public TextureAtlas(TextureAtlasData data) {
        this.load(data);
    }

    private void load(TextureAtlasData data) {
        ObjectMap<TextureAtlasData.Page, Texture> pageToTexture = new ObjectMap<TextureAtlasData.Page, Texture>();
        for (TextureAtlasData.Page page : data.pages) {
            Texture texture = null;
            if (page.texture == null) {
                texture = new Texture(page.textureFile, page.format, page.useMipMaps);
                texture.setFilter(page.minFilter, page.magFilter);
                texture.setWrap(page.uWrap, page.vWrap);
            } else {
                texture = page.texture;
                texture.setFilter(page.minFilter, page.magFilter);
                texture.setWrap(page.uWrap, page.vWrap);
            }
            this.textures.add(texture);
            pageToTexture.put(page, texture);
        }
        for (TextureAtlasData.Region region : data.regions) {
            AtlasRegion atlasRegion = new AtlasRegion((Texture)pageToTexture.get(region.page), region.left, region.top, region.width, region.height);
            atlasRegion.index = region.index;
            atlasRegion.name = region.name;
            atlasRegion.offsetX = region.offsetX;
            atlasRegion.offsetY = region.offsetY;
            atlasRegion.originalHeight = region.originalHeight;
            atlasRegion.originalWidth = region.originalWidth;
            atlasRegion.rotate = region.rotate;
            if (region.flip) {
                atlasRegion.flip(false, true);
            }
            this.regions.add(atlasRegion);
        }
    }

    public AtlasRegion addRegion(String name, Texture texture, int x, int y, int width, int height) {
        this.textures.add(texture);
        AtlasRegion region = new AtlasRegion(texture, x, y, width, height);
        region.name = name;
        region.originalWidth = width;
        region.originalHeight = height;
        region.index = -1;
        this.regions.add(region);
        return region;
    }

    public AtlasRegion addRegion(String name, TextureRegion textureRegion) {
        return this.addRegion(name, textureRegion.texture, textureRegion.getRegionX(), textureRegion.getRegionY(), textureRegion.getRegionWidth(), textureRegion.getRegionHeight());
    }

    public List<AtlasRegion> getRegions() {
        return this.regions;
    }

    public AtlasRegion findRegion(String name) {
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            if (!this.regions.get((int)i).name.equals(name)) continue;
            return this.regions.get(i);
        }
        return null;
    }

    public AtlasRegion findRegion(String name, int index) {
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            AtlasRegion region = this.regions.get(i);
            if (!region.name.equals(name) || region.index != index) continue;
            return region;
        }
        return null;
    }

    public List<AtlasRegion> findRegions(String name) {
        ArrayList<AtlasRegion> matched = new ArrayList<AtlasRegion>();
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            AtlasRegion region = this.regions.get(i);
            if (!region.name.equals(name)) continue;
            matched.add(new AtlasRegion(region));
        }
        return matched;
    }

    public List<Sprite> createSprites() {
        ArrayList<Sprite> sprites = new ArrayList<Sprite>(this.regions.size());
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            sprites.add(this.newSprite(this.regions.get(i)));
        }
        return sprites;
    }

    public Sprite createSprite(String name) {
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            if (!this.regions.get((int)i).name.equals(name)) continue;
            return this.newSprite(this.regions.get(i));
        }
        return null;
    }

    public Sprite createSprite(String name, int index) {
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            AtlasRegion region = this.regions.get(i);
            if (!region.name.equals(name) || region.index != index) continue;
            return this.newSprite(this.regions.get(i));
        }
        return null;
    }

    public List<Sprite> createSprites(String name) {
        ArrayList<Sprite> matched = new ArrayList<Sprite>();
        int n = this.regions.size();
        for (int i = 0; i < n; ++i) {
            AtlasRegion region = this.regions.get(i);
            if (!region.name.equals(name)) continue;
            matched.add(this.newSprite(region));
        }
        return matched;
    }

    private Sprite newSprite(AtlasRegion region) {
        if (region.packedWidth == region.originalWidth && region.packedHeight == region.originalHeight) {
            if (region.rotate) {
                Sprite sprite = new Sprite(region);
                sprite.setBounds(0.0f, 0.0f, region.getRegionHeight(), region.getRegionWidth());
                sprite.rotate90(true);
                return sprite;
            }
            return new Sprite(region);
        }
        return new AtlasSprite(region);
    }

    public Set<Texture> getTextures() {
        return this.textures;
    }

    @Override
    public void dispose() {
        for (Texture texture : this.textures) {
            texture.dispose();
        }
        this.textures.clear();
    }

    static String readValue(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int colon = line.indexOf(58);
        if (colon == -1) {
            throw new GdxRuntimeException("Invalid line: " + line);
        }
        return line.substring(colon + 1).trim();
    }

    static void readTuple(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int colon = line.indexOf(58);
        int comma = line.indexOf(44);
        if (colon == -1 || comma == -1 || comma < colon + 1) {
            throw new GdxRuntimeException("Invalid line: " + line);
        }
        TextureAtlas.tuple[0] = line.substring(colon + 1, comma).trim();
        TextureAtlas.tuple[1] = line.substring(comma + 1).trim();
    }

    public static class AtlasSprite
    extends Sprite {
        final AtlasRegion region;
        float originalOffsetX;
        float originalOffsetY;

        public AtlasSprite(AtlasRegion region) {
            this.region = new AtlasRegion(region);
            this.originalOffsetX = region.offsetX;
            this.originalOffsetY = region.offsetY;
            this.setRegion(region);
            this.setOrigin((float)region.originalWidth / 2.0f, (float)region.originalHeight / 2.0f);
            int width = Math.abs(region.getRegionWidth());
            int height = Math.abs(region.getRegionHeight());
            if (region.rotate) {
                this.rotate90(true);
                super.setBounds(region.offsetX, region.offsetY, height, width);
            } else {
                super.setBounds(region.offsetX, region.offsetY, width, height);
            }
            this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void setPosition(float x, float y) {
            super.setPosition(x + this.region.offsetX, y + this.region.offsetY);
        }

        @Override
        public void setBounds(float x, float y, float width, float height) {
            float widthRatio = width / (float)this.region.originalWidth;
            float heightRatio = height / (float)this.region.originalHeight;
            this.region.offsetX = this.originalOffsetX * widthRatio;
            this.region.offsetY = this.originalOffsetY * heightRatio;
            super.setBounds(x + this.region.offsetX, y + this.region.offsetY, (float)this.region.packedWidth * widthRatio, (float)this.region.packedHeight * heightRatio);
        }

        @Override
        public void setSize(float width, float height) {
            this.setBounds(this.getX(), this.getY(), width, height);
        }

        @Override
        public void setOrigin(float originX, float originY) {
            super.setOrigin(originX - this.region.offsetX, originY - this.region.offsetY);
        }

        @Override
        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            float oldOriginX = this.getOriginX();
            float oldOriginY = this.getOriginY();
            float oldOffsetX = this.region.offsetX;
            float oldOffsetY = this.region.offsetY;
            this.region.flip(x, y);
            this.translate(this.region.offsetX - oldOffsetX, this.region.offsetY - oldOffsetY);
            this.setOrigin(oldOriginX, oldOriginY);
        }

        @Override
        public float getX() {
            return super.getX() - this.region.offsetX;
        }

        @Override
        public float getY() {
            return super.getY() - this.region.offsetY;
        }

        @Override
        public float getOriginX() {
            return super.getOriginX() + this.region.offsetX;
        }

        @Override
        public float getOriginY() {
            return super.getOriginY() + this.region.offsetY;
        }

        @Override
        public float getWidth() {
            return super.getWidth() / (float)this.region.packedWidth * (float)this.region.originalWidth;
        }

        @Override
        public float getHeight() {
            return super.getHeight() / (float)this.region.packedHeight * (float)this.region.originalHeight;
        }

        public AtlasRegion getAtlasRegion() {
            return this.region;
        }
    }

    public static class AtlasRegion
    extends TextureRegion {
        public int index;
        public String name;
        public float offsetX;
        public float offsetY;
        public int packedWidth;
        public int packedHeight;
        public int originalWidth;
        public int originalHeight;
        public boolean rotate;

        public AtlasRegion(Texture texture, int x, int y, int width, int height) {
            super(texture, x, y, width, height);
            this.packedWidth = width;
            this.packedHeight = height;
        }

        public AtlasRegion(AtlasRegion region) {
            this.setRegion(region);
            this.index = region.index;
            this.name = region.name;
            this.offsetX = region.offsetX;
            this.offsetY = region.offsetY;
            this.packedWidth = region.packedWidth;
            this.packedHeight = region.packedHeight;
            this.originalWidth = region.originalWidth;
            this.originalHeight = region.originalHeight;
            this.rotate = region.rotate;
        }

        @Override
        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            if (x) {
                this.offsetX = (float)this.originalWidth - this.offsetX - (float)this.packedWidth;
            }
            if (y) {
                this.offsetY = (float)this.originalHeight - this.offsetY - (float)this.packedHeight;
            }
        }
    }

    public static class TextureAtlasData {
        final Array<Page> pages = new Array();
        final Array<Region> regions = new Array();

        public TextureAtlasData(FileHandle packFile, FileHandle imagesDir, boolean flip) {
            PriorityQueue<Region> sortedRegions = new PriorityQueue<Region>(16, indexComparator);
            BufferedReader reader = new BufferedReader(new InputStreamReader(packFile.read()), 64);
            try {
                String line;
                Page pageImage = null;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().length() == 0) {
                        pageImage = null;
                        continue;
                    }
                    if (pageImage == null) {
                        FileHandle file = imagesDir.child(line);
                        Pixmap.Format format = Pixmap.Format.valueOf(TextureAtlas.readValue(reader));
                        TextureAtlas.readTuple(reader);
                        Texture.TextureFilter min = Texture.TextureFilter.valueOf(tuple[0]);
                        Texture.TextureFilter max = Texture.TextureFilter.valueOf(tuple[1]);
                        String direction = TextureAtlas.readValue(reader);
                        Texture.TextureWrap repeatX = Texture.TextureWrap.ClampToEdge;
                        Texture.TextureWrap repeatY = Texture.TextureWrap.ClampToEdge;
                        if (direction.equals("x")) {
                            repeatX = Texture.TextureWrap.Repeat;
                        } else if (direction.equals("y")) {
                            repeatY = Texture.TextureWrap.Repeat;
                        } else if (direction.equals("xy")) {
                            repeatX = Texture.TextureWrap.Repeat;
                            repeatY = Texture.TextureWrap.Repeat;
                        }
                        pageImage = new Page(file, min.isMipMap(), format, min, max, repeatX, repeatY);
                        this.pages.add(pageImage);
                        continue;
                    }
                    boolean rotate = Boolean.valueOf(TextureAtlas.readValue(reader));
                    TextureAtlas.readTuple(reader);
                    int left = Integer.parseInt(tuple[0]);
                    int top = Integer.parseInt(tuple[1]);
                    TextureAtlas.readTuple(reader);
                    int width = Integer.parseInt(tuple[0]);
                    int height = Integer.parseInt(tuple[1]);
                    Region region = new Region();
                    region.page = pageImage;
                    region.left = left;
                    region.top = top;
                    region.width = width;
                    region.height = height;
                    region.name = line;
                    region.rotate = rotate;
                    TextureAtlas.readTuple(reader);
                    region.originalWidth = Integer.parseInt(tuple[0]);
                    region.originalHeight = Integer.parseInt(tuple[1]);
                    TextureAtlas.readTuple(reader);
                    region.offsetX = Integer.parseInt(tuple[0]);
                    region.offsetY = Integer.parseInt(tuple[1]);
                    region.index = Integer.parseInt(TextureAtlas.readValue(reader));
                    if (flip) {
                        region.flip = true;
                    }
                    sortedRegions.add(region);
                }
            }
            catch (IOException ex) {
                throw new GdxRuntimeException("Error reading pack file: " + packFile);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
            int n = sortedRegions.size();
            for (int i = 0; i < n; ++i) {
                this.regions.add(sortedRegions.poll());
            }
        }

        public Array<Page> getPages() {
            return this.pages;
        }

        public Array<Region> getRegions() {
            return this.regions;
        }

        public static class Region {
            public Page page;
            public int index;
            public String name;
            public float offsetX;
            public float offsetY;
            public int originalWidth;
            public int originalHeight;
            public boolean rotate;
            public int left;
            public int top;
            public int width;
            public int height;
            public boolean flip;
        }

        public static class Page {
            public final FileHandle textureFile;
            public Texture texture;
            public final boolean useMipMaps;
            public final Pixmap.Format format;
            public final Texture.TextureFilter minFilter;
            public final Texture.TextureFilter magFilter;
            public final Texture.TextureWrap uWrap;
            public final Texture.TextureWrap vWrap;

            public Page(FileHandle handle, boolean useMipMaps, Pixmap.Format format, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter, Texture.TextureWrap uWrap, Texture.TextureWrap vWrap) {
                this.textureFile = handle;
                this.useMipMaps = useMipMaps;
                this.format = format;
                this.minFilter = minFilter;
                this.magFilter = magFilter;
                this.uWrap = uWrap;
                this.vWrap = vWrap;
            }
        }
    }
}

