/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ClickListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;

public class Button
extends Table {
    private ButtonStyle style;
    ClickListener listener;
    boolean isChecked;
    ButtonGroup buttonGroup;

    public Button(Skin skin) {
        super(skin);
        this.initialize();
        this.setStyle(skin.getStyle(ButtonStyle.class));
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public Button(ButtonStyle style) {
        this.initialize();
        this.setStyle(style);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public Button(Actor child, ButtonStyle style) {
        this.initialize();
        this.add(child);
        this.setStyle(style);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public Button(ButtonStyle style, String name) {
        super(null, null, name);
        this.initialize();
        this.setStyle(style);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    private void initialize() {
        super.setClickListener(new ClickListener(){

            @Override
            public void click(Actor actor, float x, float y) {
                boolean newChecked = !Button.this.isChecked;
                Button.this.setChecked(newChecked);
                if (newChecked == Button.this.isChecked && Button.this.listener != null) {
                    Button.this.listener.click(actor, x, y);
                }
            }
        });
    }

    public Button(TextureRegion region) {
        this(new ButtonStyle(new NinePatch(region), null, null, 0.0f, 0.0f, 0.0f, 0.0f));
    }

    public Button(TextureRegion regionUp, TextureRegion regionDown) {
        this(new ButtonStyle(new NinePatch(regionUp), new NinePatch(regionDown), null, 0.0f, 0.0f, 0.0f, 0.0f));
    }

    public Button(TextureRegion regionUp, TextureRegion regionDown, TextureRegion regionChecked) {
        this(new ButtonStyle(new NinePatch(regionUp), new NinePatch(regionDown), new NinePatch(regionChecked), 0.0f, 0.0f, 0.0f, 0.0f));
    }

    public Button(NinePatch patch) {
        this(new ButtonStyle(patch, null, null, 0.0f, 0.0f, 0.0f, 0.0f));
    }

    public Button(NinePatch patchUp, NinePatch patchDown) {
        this(new ButtonStyle(patchUp, patchDown, null, 0.0f, 0.0f, 0.0f, 0.0f));
    }

    public Button(NinePatch patchUp, NinePatch patchDown, NinePatch patchChecked) {
        this(new ButtonStyle(patchUp, patchDown, patchChecked, 0.0f, 0.0f, 0.0f, 0.0f));
    }

    public Button(Actor child, Skin skin) {
        this(child, skin.getStyle(ButtonStyle.class));
    }

    public void setChecked(boolean isChecked) {
        if (this.buttonGroup != null && !this.buttonGroup.canCheck(this, isChecked)) {
            return;
        }
        this.isChecked = isChecked;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setStyle(ButtonStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.setBackground(this.isPressed && style.down != null ? style.down : style.up);
        this.invalidateHierarchy();
    }

    public ButtonStyle getStyle() {
        return this.style;
    }

    @Override
    public void setClickListener(ClickListener listener) {
        this.listener = listener;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        Actor child;
        int i;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        if (this.isPressed) {
            this.setBackground(this.style.down == null ? this.style.up : this.style.down);
            offsetX = this.style.pressedOffsetX;
            offsetY = this.style.pressedOffsetY;
        } else {
            if (this.style.checked == null) {
                this.setBackground(this.style.up);
            } else {
                this.setBackground(this.isChecked ? this.style.checked : this.style.up);
            }
            offsetX = this.style.unpressedOffsetX;
            offsetY = this.style.unpressedOffsetY;
        }
        this.validate();
        for (i = 0; i < this.children.size(); ++i) {
            child = (Actor)this.children.get(i);
            child.x += offsetX;
            child.y += offsetY;
        }
        super.draw(batch, parentAlpha);
        for (i = 0; i < this.children.size(); ++i) {
            child = (Actor)this.children.get(i);
            child.x -= offsetX;
            child.y -= offsetY;
        }
    }

    @Override
    public float getPrefWidth() {
        float width = this.getTableLayout().getPrefWidth();
        if (this.style.up != null) {
            width = Math.max(width, this.style.up.getTotalWidth());
        }
        if (this.style.down != null) {
            width = Math.max(width, this.style.down.getTotalWidth());
        }
        if (this.style.checked != null) {
            width = Math.max(width, this.style.checked.getTotalWidth());
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        float height = this.getTableLayout().getPrefHeight();
        if (this.style.up != null) {
            height = Math.max(height, this.style.up.getTotalHeight());
        }
        if (this.style.down != null) {
            height = Math.max(height, this.style.down.getTotalHeight());
        }
        if (this.style.checked != null) {
            height = Math.max(height, this.style.checked.getTotalHeight());
        }
        return height;
    }

    @Override
    public float getMinWidth() {
        return this.getPrefWidth();
    }

    @Override
    public float getMinHeight() {
        return this.getPrefHeight();
    }

    public static class ButtonStyle {
        public NinePatch down;
        public NinePatch up;
        public NinePatch checked;
        public float pressedOffsetX;
        public float pressedOffsetY;
        public float unpressedOffsetX;
        public float unpressedOffsetY;

        public ButtonStyle() {
        }

        public ButtonStyle(NinePatch up, NinePatch down, NinePatch checked, float pressedOffsetX, float pressedOffsetY, float unpressedOffsetX, float unpressedOffsetY) {
            this.down = down;
            this.up = up;
            this.checked = checked;
            this.pressedOffsetX = pressedOffsetX;
            this.pressedOffsetY = pressedOffsetY;
            this.unpressedOffsetX = unpressedOffsetX;
            this.unpressedOffsetY = unpressedOffsetY;
        }
    }
}

