/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Scaling;
import com.esotericsoftware.tablelayout.Cell;

public class ImageButton
extends Button {
    private final Image image = new Image();
    private ImageButtonStyle style;

    public ImageButton(Skin skin) {
        this(skin.getStyle("default", ImageButtonStyle.class));
    }

    public ImageButton(ImageButtonStyle style) {
        this(style, null);
    }

    public ImageButton(ImageButtonStyle style, String name) {
        super(style, name);
        this.image.setScaling(Scaling.fit);
        this.add(this.image);
        this.setStyle(style);
        this.width = this.getPrefWidth();
        this.height = this.getPrefHeight();
    }

    public ImageButton(TextureRegion region) {
        this(new ImageButtonStyle(null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, region, null, null));
    }

    public ImageButton(TextureRegion regionUp, TextureRegion regionDown) {
        this(new ImageButtonStyle(null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, regionUp, regionDown, null));
    }

    public ImageButton(TextureRegion regionUp, TextureRegion regionDown, TextureRegion regionChecked) {
        this(new ImageButtonStyle(null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, regionUp, regionDown, regionChecked));
    }

    public ImageButton(NinePatch patch) {
        this(new ImageButtonStyle(null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, patch, null, null));
    }

    public ImageButton(NinePatch patchUp, NinePatch patchDown) {
        this(new ImageButtonStyle(null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, patchUp, patchDown, null));
    }

    public ImageButton(NinePatch patchUp, NinePatch patchDown, NinePatch patchChecked) {
        this(new ImageButtonStyle(null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, patchUp, patchDown, patchChecked));
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof ImageButtonStyle)) {
            throw new IllegalArgumentException("style must be an ImageButtonStyle.");
        }
        super.setStyle(style);
        this.style = (ImageButtonStyle)style;
        if (this.image != null) {
            this.updateImage();
        }
    }

    @Override
    public ImageButtonStyle getStyle() {
        return this.style;
    }

    private void updateImage() {
        if (this.isPressed && this.style.regionDown != null) {
            this.image.setRegion(this.style.regionDown);
        } else if (this.isPressed && this.style.patchDown != null) {
            this.image.setPatch(this.style.patchDown);
        } else if (this.isChecked && this.style.regionChecked != null) {
            this.image.setRegion(this.style.regionChecked);
        } else if (this.isChecked && this.style.patchChecked != null) {
            this.image.setPatch(this.style.patchChecked);
        } else if (this.style.regionUp != null) {
            this.image.setRegion(this.style.regionUp);
        } else if (this.style.patchUp != null) {
            this.image.setPatch(this.style.patchUp);
        }
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        this.updateImage();
        super.draw(batch, parentAlpha);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell getImageCell() {
        return this.getCell(this.image);
    }

    public static class ImageButtonStyle
    extends Button.ButtonStyle {
        public TextureRegion regionUp;
        public TextureRegion regionDown;
        public TextureRegion regionChecked;
        public NinePatch patchUp;
        public NinePatch patchDown;
        public NinePatch patchChecked;

        public ImageButtonStyle() {
        }

        public ImageButtonStyle(NinePatch down, NinePatch up, NinePatch checked, float pressedOffsetX, float pressedOffsetY, float unpressedOffsetX, float unpressedOffsetY, TextureRegion regionUp, TextureRegion regionDown, TextureRegion regionChecked) {
            super(down, up, checked, pressedOffsetX, pressedOffsetY, unpressedOffsetX, unpressedOffsetY);
            this.regionUp = regionUp;
            this.regionDown = regionDown;
            this.regionChecked = regionChecked;
        }

        public ImageButtonStyle(NinePatch down, NinePatch up, NinePatch checked, float pressedOffsetX, float pressedOffsetY, float unpressedOffsetX, float unpressedOffsetY, NinePatch patchUp, NinePatch patchDown, NinePatch patchChecked) {
            super(down, up, checked, pressedOffsetX, pressedOffsetY, unpressedOffsetX, unpressedOffsetY);
            this.patchUp = patchUp;
            this.patchDown = patchDown;
            this.patchChecked = patchChecked;
        }
    }
}

