/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui.tablelayout;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer10;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Layout;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.LibgdxToolkit;
import com.badlogic.gdx.scenes.scene2d.ui.tablelayout.Table;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.tablelayout.BaseTableLayout;
import com.esotericsoftware.tablelayout.Cell;
import java.util.List;

public class TableLayout
extends BaseTableLayout<Actor, Table, TableLayout, LibgdxToolkit> {
    public Skin skin;
    public AssetManager assetManager;
    Array<LibgdxToolkit.DebugRect> debugRects;
    private ImmediateModeRenderer debugRenderer;

    public TableLayout() {
        super(LibgdxToolkit.instance);
    }

    public TableLayout(LibgdxToolkit toolkit) {
        super(toolkit);
    }

    public Actor register(Actor actor) {
        if (actor.name == null) {
            throw new IllegalArgumentException("Actor must have a name: " + actor.getClass());
        }
        return this.register(actor.name, actor);
    }

    @Override
    public Actor getWidget(String name) {
        Actor actor = (Actor)super.getWidget(name);
        if (actor == null) {
            actor = ((Table)this.getTable()).findActor(name);
        }
        return actor;
    }

    @Override
    public void layout() {
        Table table = (Table)this.getTable();
        this.setLayoutSize(0, 0, (int)table.width, (int)table.height);
        super.layout();
        List<Cell> cells = this.getCells();
        int n = cells.size();
        for (int i = 0; i < n; ++i) {
            Cell c = cells.get(i);
            if (c.getIgnore()) continue;
            Actor actor = (Actor)c.getWidget();
            actor.x = c.getWidgetX();
            int widgetHeight = c.getWidgetHeight();
            actor.y = table.height - (float)c.getWidgetY() - (float)widgetHeight;
            actor.width = c.getWidgetWidth();
            actor.height = widgetHeight;
        }
        List<Actor> children = table.getActors();
        int n2 = children.size();
        for (int i = 0; i < n2; ++i) {
            Actor child = children.get(i);
            if (!(child instanceof Layout)) continue;
            Layout layout = (Layout)((Object)child);
            layout.invalidate();
            layout.validate();
        }
    }

    @Override
    public void invalidateHierarchy() {
        super.invalidate();
        ((Table)this.getTable()).invalidateHierarchy();
    }

    private void toStageCoordinates(Actor actor, Vector2 point) {
        point.x += actor.x;
        point.y += actor.y;
        this.toStageCoordinates(actor.parent, point);
    }

    public void drawDebug(SpriteBatch batch) {
        if (this.getDebug() == 0 || this.debugRects == null) {
            return;
        }
        if (this.debugRenderer == null) {
            this.debugRenderer = Gdx.graphics.isGL20Available() ? new ImmediateModeRenderer20(64, false, true, 0) : new ImmediateModeRenderer10(64);
        }
        float x = 0.0f;
        float y = 0.0f;
        Actor parent = (Actor)this.getTable();
        while (parent != null) {
            if (parent instanceof Group) {
                x += parent.x;
                y += parent.y;
            }
            parent = parent.parent;
        }
        this.debugRenderer.begin(batch.getProjectionMatrix(), 1);
        int n = this.debugRects.size;
        for (int i = 0; i < n; ++i) {
            LibgdxToolkit.DebugRect rect = this.debugRects.get(i);
            float x1 = x + rect.x;
            float y1 = y + rect.y - rect.height;
            float x2 = x1 + rect.width;
            float y2 = y1 + rect.height;
            float r = (rect.type & 4) != 0 ? 1.0f : 0.0f;
            float g = (rect.type & 8) != 0 ? 1.0f : 0.0f;
            float b = (rect.type & 2) != 0 ? 1.0f : 0.0f;
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y2, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x2, y1, 0.0f);
            this.debugRenderer.color(r, g, b, 1.0f);
            this.debugRenderer.vertex(x1, y1, 0.0f);
            if (this.debugRenderer.getNumVertices() != 64) continue;
            this.debugRenderer.end();
            this.debugRenderer.begin(batch.getProjectionMatrix(), 1);
        }
        this.debugRenderer.end();
    }
}

