/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import java.lang.reflect.Array;

public class ArrayMap<K, V> {
    public K[] keys;
    public V[] values;
    public int size;
    public boolean ordered;

    public ArrayMap() {
        this(true, 16);
    }

    public ArrayMap(int capacity) {
        this(true, capacity);
    }

    public ArrayMap(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.keys = new Object[capacity];
        this.values = new Object[capacity];
    }

    public ArrayMap(boolean ordered, int capacity, Class<K> keyArrayType, Class<V> valueArrayType) {
        this.ordered = ordered;
        this.keys = (Object[])Array.newInstance(keyArrayType, capacity);
        this.values = (Object[])Array.newInstance(valueArrayType, capacity);
    }

    public ArrayMap(Class<K> keyArrayType, Class<V> valueArrayType) {
        this(false, 16, keyArrayType, valueArrayType);
    }

    public ArrayMap(ArrayMap array) {
        this(array.ordered, array.size, array.keys.getClass().getComponentType(), array.values.getClass().getComponentType());
        this.size = array.size;
        System.arraycopy(array.keys, 0, this.keys, 0, this.size);
        System.arraycopy(array.values, 0, this.values, 0, this.size);
    }

    public void put(K key, V value) {
        if (this.size == this.keys.length) {
            this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        this.keys[this.size] = key;
        this.values[this.size++] = value;
    }

    public void addAll(ArrayMap map) {
        this.addAll(map, 0, map.size);
    }

    public void addAll(ArrayMap map, int offset, int length) {
        if (offset + length > map.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + map.size);
        }
        int sizeNeeded = this.size + length - offset;
        if (sizeNeeded >= this.keys.length) {
            this.resize(Math.max(8, (int)((float)sizeNeeded * 1.75f)));
        }
        System.arraycopy(map.keys, offset, this.keys, this.size, length);
        System.arraycopy(map.values, offset, this.values, this.size, length);
        this.size += length;
    }

    public V get(K key) {
        int i;
        K[] keys = this.keys;
        if (key == null) {
            for (i = this.size - 1; i >= 0; --i) {
                if (keys[i] != key) continue;
                return this.values[i];
            }
        } else {
            while (i >= 0) {
                if (key.equals(keys[i])) {
                    return this.values[i];
                }
                --i;
            }
        }
        return null;
    }

    public V get(K key, boolean identity) {
        int i;
        K[] keys = this.keys;
        if (identity || key == null) {
            for (i = this.size - 1; i >= 0; --i) {
                if (keys[i] != key) continue;
                return this.values[i];
            }
        } else {
            while (i >= 0) {
                if (key.equals(keys[i])) {
                    return this.values[i];
                }
                --i;
            }
        }
        return null;
    }

    public K getKey(V value, boolean identity) {
        int i;
        V[] values = this.values;
        if (identity || values == null) {
            for (i = this.size - 1; i >= 0; --i) {
                if (values[i] != values) continue;
                return this.keys[i];
            }
        } else {
            while (i >= 0) {
                if (values.equals(values[i])) {
                    return this.keys[i];
                }
                --i;
            }
        }
        return null;
    }

    public K getKeyAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.keys[index];
    }

    public V getValueAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.values[index];
    }

    public void setKey(int index, K key) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.keys[index] = key;
    }

    public void setValue(int index, V value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.values[index] = value;
    }

    public void insert(int index, K key, V value) {
        if (this.size == this.keys.length) {
            this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(this.keys, index, this.keys, index + 1, this.size - index);
            System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        } else {
            this.keys[this.size] = this.keys[index];
            this.values[this.size] = this.values[index];
        }
        ++this.size;
        this.keys[index] = key;
        this.values[index] = value;
    }

    public boolean containsKey(K key, boolean identity) {
        K[] keys = this.keys;
        int i = this.size - 1;
        if (identity || key == null) {
            while (i >= 0) {
                if (keys[i--] != key) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!key.equals(keys[i--])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(V value, boolean identity) {
        V[] values = this.values;
        int i = this.size - 1;
        if (identity || value == null) {
            while (i >= 0) {
                if (values[i--] != value) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!value.equals(values[i--])) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOfKey(K key, boolean identity) {
        K[] keys = this.keys;
        if (identity || key == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (keys[i] != key) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!key.equals(keys[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfValue(V value, boolean identity) {
        V[] values = this.values;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (values[i] != value) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public V removeKey(K key, boolean identity) {
        K[] keys = this.keys;
        if (identity || key == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (keys[i] != key) continue;
                V value = this.values[i];
                this.removeIndex(i);
                return value;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!key.equals(keys[i])) continue;
                V value = this.values[i];
                this.removeIndex(i);
                return value;
            }
        }
        return null;
    }

    public boolean removeValue(V value, boolean identity) {
        V[] values = this.values;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (values[i] != value) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(values[i])) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    public void removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        K[] keys = this.keys;
        --this.size;
        if (this.ordered) {
            System.arraycopy(keys, index + 1, keys, index, this.size - index);
            System.arraycopy(this.values, index + 1, this.values, index, this.size - index);
        } else {
            keys[index] = keys[this.size];
            this.values[index] = this.values[this.size];
        }
        keys[this.size] = null;
        this.values[this.size] = null;
    }

    public K peekKey() {
        return this.keys[this.size - 1];
    }

    public V peekValue() {
        return this.values[this.size - 1];
    }

    public void clear() {
        K[] keys = this.keys;
        V[] values = this.values;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            keys[i] = null;
            values[i] = null;
        }
        this.size = 0;
    }

    public void shrink() {
        this.resize(this.size);
    }

    public void ensureCapacity(int additionalCapacity) {
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded >= this.keys.length) {
            this.resize(Math.max(8, sizeNeeded));
        }
    }

    protected void resize(int newSize) {
        Object[] newKeys = (Object[])Array.newInstance(this.keys.getClass().getComponentType(), newSize);
        System.arraycopy(this.keys, 0, newKeys, 0, Math.min(this.keys.length, newKeys.length));
        this.keys = newKeys;
        Object[] newValues = (Object[])Array.newInstance(this.values.getClass().getComponentType(), newSize);
        System.arraycopy(this.values, 0, newValues, 0, Math.min(this.values.length, newValues.length));
        this.values = newValues;
    }

    public void reverse() {
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            K tempKey = this.keys[i];
            this.keys[i] = this.keys[ii];
            this.keys[ii] = tempKey;
            V tempValue = this.values[i];
            this.values[i] = this.values[ii];
            this.values[ii] = tempValue;
        }
    }

    public void shuffle() {
        for (int i = this.size - 1; i >= 0; --i) {
            int ii = MathUtils.random(i);
            K tempKey = this.keys[i];
            this.keys[i] = this.keys[ii];
            this.keys[ii] = tempKey;
            V tempValue = this.values[i];
            this.values[i] = this.values[ii];
            this.values[ii] = tempValue;
        }
    }

    public void truncate(int newSize) {
        if (this.size <= newSize) {
            return;
        }
        for (int i = newSize; i < this.size; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = newSize;
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        K[] keys = this.keys;
        V[] values = this.values;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        buffer.append(keys[0]);
        buffer.append('=');
        buffer.append(values[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(keys[i]);
            buffer.append('=');
            buffer.append(values[i]);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

