/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

public class BinaryHeap<T> {
    public int size = 0;
    private Node<T>[] nodes;
    private final boolean isMaxHeap;

    public BinaryHeap() {
        this(16, false);
    }

    public BinaryHeap(int capacity, boolean isMaxHeap) {
        this.isMaxHeap = isMaxHeap;
        this.nodes = new Node[capacity];
    }

    public Node add(Node node) {
        if (this.size == this.nodes.length) {
            Node[] newNodes = new Node[this.size << 1];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.size);
            this.nodes = newNodes;
        }
        node.index = this.size;
        this.nodes[this.size] = node;
        this.up(this.size++);
        return node;
    }

    public Node pop() {
        Node<T>[] nodes = this.nodes;
        Node<T> popped = nodes[0];
        nodes[0] = nodes[--this.size];
        nodes[this.size] = null;
        if (this.size > 0) {
            this.down(0);
        }
        return popped;
    }

    public void setValue(Node node, float value) {
        float oldValue = node.value;
        node.value = value;
        if (value < oldValue ^ this.isMaxHeap) {
            this.up(node.index);
        } else {
            this.down(node.index);
        }
    }

    private void up(int index) {
        Node<T>[] nodes = this.nodes;
        Node<T> node = nodes[index];
        float value = node.value;
        while (index > 0) {
            int parentIndex = index - 1 >> 1;
            Node<T> parent = nodes[parentIndex];
            if (!(value < parent.value ^ this.isMaxHeap)) break;
            nodes[index] = parent;
            parent.index = index;
            index = parentIndex;
        }
        nodes[index] = node;
        node.index = index;
    }

    private void down(int index) {
        int leftIndex;
        Node<T>[] nodes = this.nodes;
        int size = this.size;
        Node<T> node = nodes[index];
        float value = node.value;
        while ((leftIndex = 1 + (index << 1)) < size) {
            float rightValue;
            Node<T> rightNode;
            int rightIndex = leftIndex + 1;
            Node<T> leftNode = nodes[leftIndex];
            float leftValue = leftNode.value;
            if (rightIndex >= size) {
                rightNode = null;
                rightValue = this.isMaxHeap ? Float.MIN_VALUE : Float.MAX_VALUE;
            } else {
                rightNode = nodes[rightIndex];
                rightValue = rightNode.value;
            }
            if (leftValue < rightValue ^ this.isMaxHeap) {
                if (leftValue == value || leftValue > value ^ this.isMaxHeap) break;
                nodes[index] = leftNode;
                leftNode.index = index;
                index = leftIndex;
                continue;
            }
            if (rightValue == value || rightValue > value ^ this.isMaxHeap) break;
            nodes[index] = rightNode;
            rightNode.index = index;
            index = rightIndex;
        }
        nodes[index] = node;
        node.index = index;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Node<T>[] nodes = this.nodes;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(nodes[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(nodes[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static class Node<T> {
        float value;
        int index;

        public Node(float value) {
            this.value = value;
        }
    }
}

