/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 69;
    static final int json_error = 0;
    static final int json_en_object = 9;
    static final int json_en_array = 42;
    static final int json_en_main = 1;
    private final Array elements = new Array(8);
    private Object root;
    private Object current;

    public Object parse(String json) {
        char[] data = json.toCharArray();
        return this.parse(data, 0, data.length);
    }

    public Object parse(Reader reader) {
        try {
            int length;
            char[] data = new char[1024];
            int offset = 0;
            while ((length = reader.read(data, offset, data.length - offset)) != -1) {
                if (length == 0) {
                    char[] newData = new char[data.length * 2];
                    System.arraycopy(data, 0, newData, 0, data.length);
                    data = newData;
                    continue;
                }
                offset += length;
            }
            Object object = this.parse(data, 0, offset);
            return object;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ignored) {}
        }
    }

    public Object parse(InputStream input) {
        try {
            return this.parse(new InputStreamReader(input, "ISO-8859-1"));
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public Object parse(FileHandle file) {
        try {
            return this.parse(file.read());
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object parse(char[] data, int offset, int length) {
        p = offset;
        eof = pe = length;
        top = 0;
        stack = new int[4];
        s = 0;
        names = new Array<String>(8);
        needsUnescape = false;
        parseRuntimeEx = null;
        debug = false;
        if (debug) {
            System.out.println();
        }
        try {
            cs = 1;
            top = 0;
            _trans = 0;
            _goto_targ = 0;
            block29: while (true) {
                switch (_goto_targ) {
                    case 0: {
                        if (p == pe) {
                            _goto_targ = 4;
                            continue block29;
                        }
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block29;
                        }
                    }
                    case 1: {
                        _keys = JsonReader._json_key_offsets[cs];
                        _trans = JsonReader._json_index_offsets[cs];
                        _klen = JsonReader._json_single_lengths[cs];
                        if (_klen <= 0) ** GOTO lbl45
                        _lower = _keys;
                        _upper = _keys + _klen - 1;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1);
                            if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                _upper = _mid - 1;
                                continue;
                            }
                            if (data[p] > JsonReader._json_trans_keys[_mid]) {
                                _lower = _mid + 1;
                                continue;
                            }
                            _trans += _mid - _keys;
                            ** GOTO lbl59
                        }
                        _keys += _klen;
                        _trans += _klen;
lbl45:
                        // 2 sources

                        if ((_klen = JsonReader._json_range_lengths[cs]) > 0) {
                            _lower = _keys;
                            _upper = _keys + (_klen << 1) - 2;
                            while (_upper >= _lower) {
                                _mid = _lower + (_upper - _lower >> 1 & -2);
                                if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                    _upper = _mid - 2;
                                    continue;
                                }
                                if (data[p] > JsonReader._json_trans_keys[_mid + 1]) {
                                    _lower = _mid + 2;
                                    continue;
                                }
                                _trans += _mid - _keys >> 1;
                                ** GOTO lbl59
                            }
                            _trans += _klen;
                        }
lbl59:
                        // 5 sources

                        cs = JsonReader._json_trans_targs[_trans];
                        if (JsonReader._json_trans_actions[_trans] != 0) {
                            _acts = JsonReader._json_trans_actions[_trans];
                            _nacts = JsonReader._json_actions[_acts++];
                            while (_nacts-- > 0) {
                                switch (JsonReader._json_actions[_acts++]) {
                                    case 0: {
                                        s = p;
                                        needsUnescape = false;
                                        break;
                                    }
                                    case 1: {
                                        needsUnescape = true;
                                        break;
                                    }
                                    case 2: {
                                        name = new String(data, s, p - s);
                                        s = p;
                                        if (needsUnescape) {
                                            name = this.unescape(name);
                                        }
                                        if (debug) {
                                            System.out.println("name: " + name);
                                        }
                                        names.add(name);
                                        break;
                                    }
                                    case 3: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        if (needsUnescape) {
                                            value = this.unescape(value);
                                        }
                                        v0 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("string: " + name + "=" + value);
                                        }
                                        this.string(name, value);
                                        break;
                                    }
                                    case 4: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        v1 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("number: " + name + "=" + Float.parseFloat(value));
                                        }
                                        this.number(name, Float.parseFloat(value));
                                        break;
                                    }
                                    case 5: {
                                        v2 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=true");
                                        }
                                        this.bool(name, true);
                                        break;
                                    }
                                    case 6: {
                                        v3 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=false");
                                        }
                                        this.bool(name, false);
                                        break;
                                    }
                                    case 7: {
                                        v4 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("null: " + name);
                                        }
                                        this.string(name, null);
                                        break;
                                    }
                                    case 8: {
                                        v5 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startObject: " + name);
                                        }
                                        this.startObject(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 9;
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 9: {
                                        if (debug) {
                                            System.out.println("endObject");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 10: {
                                        v6 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startArray: " + name);
                                        }
                                        this.startArray(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 42;
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 11: {
                                        if (debug) {
                                            System.out.println("endArray");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block29;
                        }
                        if (++p != pe) {
                            _goto_targ = 1;
                            continue block29;
                        }
                    }
                    case 4: {
                        if (p != eof) break block29;
                        __acts = JsonReader._json_eof_actions[cs];
                        __nacts = JsonReader._json_actions[__acts++];
                        while (__nacts-- > 0) {
                            switch (JsonReader._json_actions[__acts++]) {
                                case 3: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    if (needsUnescape) {
                                        value = this.unescape(value);
                                    }
                                    v7 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("string: " + name + "=" + value);
                                    }
                                    this.string(name, value);
                                    break;
                                }
                                case 4: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    v8 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("number: " + name + "=" + Float.parseFloat(value));
                                    }
                                    this.number(name, Float.parseFloat(value));
                                    break;
                                }
                                case 5: {
                                    v9 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=true");
                                    }
                                    this.bool(name, true);
                                    break;
                                }
                                case 6: {
                                    v10 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=false");
                                    }
                                    this.bool(name, false);
                                    break;
                                }
                                case 7: {
                                    v11 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("null: " + name);
                                    }
                                    this.string(name, null);
                                }
                            }
                        }
                        break block29;
                    }
                }
                break;
            }
        }
        catch (RuntimeException ex) {
            parseRuntimeEx = ex;
        }
        if (p < pe) {
            lineNumber = 1;
            for (i = 0; i < p; ++i) {
                if (data[i] != '\n') continue;
                ++lineNumber;
            }
            throw new SerializationException("Error parsing JSON on line " + lineNumber + " near: " + new String(data, p, pe - p), parseRuntimeEx);
        }
        if (this.elements.size != 0) {
            element = this.elements.peek();
            this.elements.clear();
            if (element instanceof OrderedMap) {
                throw new SerializationException("Error parsing JSON, unmatched brace.");
            }
            throw new SerializationException("Error parsing JSON, unmatched bracket.");
        }
        root = this.root;
        this.root = null;
        return root;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 2, 0, 2, 2, 0, 3, 2, 3, 9, 2, 3, 11, 2, 4, 9, 2, 4, 11, 2, 5, 9, 2, 5, 11, 2, 6, 9, 2, 6, 11, 2, 7, 9, 2, 7, 11};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 18, 20, 22, 31, 33, 35, 39, 41, 53, 55, 57, 61, 79, 81, 83, 88, 99, 106, 115, 122, 124, 134, 136, 145, 149, 151, 158, 166, 174, 182, 190, 195, 203, 211, 219, 224, 232, 240, 248, 253, 262, 282, 284, 286, 291, 310, 317, 319, 329, 331, 340, 344, 346, 353, 361, 369, 377, 385, 390, 398, 406, 414, 419, 427, 435, 443, 448, 457, 460, 467, 475, 482, 487, 495, 503, 511, 519, 522, 530, 538, 546, 549, 557, 565, 573, 576, 576};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{' ', '\"', '$', '-', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', '0', '9', '0', '9', '+', '-', '0', '9', '0', '9', ' ', '\"', '$', ',', '_', '}', '\t', '\r', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ':', '\t', '\r', ' ', '\"', '$', '-', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', '}', '\t', '\r', ' ', '\"', '$', '_', '}', '\t', '\r', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', ',', '.', 'E', 'e', '}', '\t', '\r', '0', '9', '0', '9', ' ', ',', 'E', 'e', '}', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', '}', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\"', '$', ',', '-', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', ']', '\t', '\r', ' ', '\"', '$', '-', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', ',', '.', 'E', ']', 'e', '\t', '\r', '0', '9', '0', '9', ' ', ',', 'E', ']', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', ']', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ']', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', '.', 'E', 'e', '\t', '\r', '0', '9', ' ', 'E', 'e', '\t', '\r', '0', '9', ' ', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', '\t', '\r', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 10, 2, 2, 7, 0, 0, 2, 0, 6, 2, 2, 2, 10, 2, 2, 3, 5, 5, 7, 5, 0, 6, 0, 5, 2, 0, 3, 6, 6, 6, 6, 3, 6, 6, 6, 3, 6, 6, 6, 3, 7, 12, 2, 2, 3, 11, 5, 0, 6, 0, 5, 2, 0, 3, 6, 6, 6, 6, 3, 6, 6, 6, 3, 6, 6, 6, 3, 7, 1, 5, 4, 3, 1, 6, 6, 6, 6, 1, 6, 6, 6, 1, 6, 6, 6, 1, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 4, 0, 0, 1, 1, 1, 1, 1, 3, 0, 0, 1, 4, 0, 0, 1, 3, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 0, 0, 1, 4, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 15, 18, 21, 30, 32, 34, 38, 40, 50, 53, 56, 60, 75, 78, 81, 86, 95, 102, 111, 118, 120, 129, 131, 139, 143, 145, 151, 159, 167, 175, 183, 188, 196, 204, 212, 217, 225, 233, 241, 246, 255, 272, 275, 278, 283, 299, 306, 308, 317, 319, 327, 331, 333, 339, 347, 355, 363, 371, 376, 384, 392, 400, 405, 413, 421, 429, 434, 443, 446, 453, 460, 466, 470, 478, 486, 494, 502, 505, 513, 521, 529, 532, 540, 548, 556, 559, 560};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{1, 2, 70, 5, 69, 70, 74, 79, 83, 69, 1, 71, 70, 70, 0, 69, 4, 3, 69, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 71, 0, 72, 0, 8, 8, 73, 0, 73, 0, 9, 10, 18, 17, 18, 87, 9, 18, 18, 0, 12, 41, 11, 12, 41, 11, 12, 13, 12, 0, 13, 14, 20, 21, 16, 20, 28, 33, 37, 16, 13, 22, 20, 20, 0, 16, 19, 15, 16, 19, 15, 16, 17, 87, 16, 0, 17, 10, 18, 18, 87, 17, 18, 18, 0, 12, 0, 13, 0, 0, 12, 18, 15, 15, 15, 15, 15, 15, 15, 15, 0, 16, 17, 0, 0, 87, 16, 20, 22, 0, 16, 17, 23, 25, 25, 87, 16, 22, 0, 24, 0, 16, 17, 25, 25, 87, 16, 24, 0, 26, 26, 27, 0, 27, 0, 16, 17, 87, 16, 27, 0, 16, 17, 0, 0, 29, 87, 16, 20, 16, 17, 0, 0, 30, 87, 16, 20, 16, 17, 0, 0, 31, 87, 16, 20, 16, 17, 0, 0, 32, 87, 16, 20, 16, 17, 87, 16, 0, 16, 17, 0, 0, 34, 87, 16, 20, 16, 17, 0, 0, 35, 87, 16, 20, 16, 17, 0, 0, 36, 87, 16, 20, 16, 17, 87, 16, 0, 16, 17, 0, 0, 38, 87, 16, 20, 16, 17, 0, 0, 39, 87, 16, 20, 16, 17, 0, 0, 40, 87, 16, 20, 16, 17, 87, 16, 0, 11, 11, 11, 11, 11, 11, 11, 11, 0, 42, 43, 47, 46, 48, 45, 88, 47, 55, 60, 64, 45, 42, 49, 47, 47, 0, 45, 68, 44, 45, 68, 44, 45, 46, 88, 45, 0, 46, 43, 47, 48, 45, 88, 47, 55, 60, 64, 45, 46, 49, 47, 47, 0, 45, 46, 0, 88, 0, 45, 47, 49, 0, 45, 46, 50, 52, 88, 52, 45, 49, 0, 51, 0, 45, 46, 52, 88, 52, 45, 51, 0, 53, 53, 54, 0, 54, 0, 45, 46, 88, 45, 54, 0, 45, 46, 0, 88, 56, 0, 45, 47, 45, 46, 0, 88, 57, 0, 45, 47, 45, 46, 0, 88, 58, 0, 45, 47, 45, 46, 0, 88, 59, 0, 45, 47, 45, 46, 88, 45, 0, 45, 46, 0, 88, 61, 0, 45, 47, 45, 46, 0, 88, 62, 0, 45, 47, 45, 46, 0, 88, 63, 0, 45, 47, 45, 46, 88, 45, 0, 45, 46, 0, 88, 65, 0, 45, 47, 45, 46, 0, 88, 66, 0, 45, 47, 45, 46, 0, 88, 67, 0, 45, 47, 45, 46, 88, 45, 0, 44, 44, 44, 44, 44, 44, 44, 44, 0, 69, 69, 0, 69, 0, 0, 0, 0, 69, 70, 69, 6, 7, 7, 69, 71, 0, 69, 7, 7, 69, 72, 0, 69, 69, 73, 0, 69, 0, 0, 0, 75, 0, 69, 70, 69, 0, 0, 0, 76, 0, 69, 70, 69, 0, 0, 0, 77, 0, 69, 70, 69, 0, 0, 0, 78, 0, 69, 70, 69, 69, 0, 69, 0, 0, 0, 80, 0, 69, 70, 69, 0, 0, 0, 81, 0, 69, 70, 69, 0, 0, 0, 82, 0, 69, 70, 69, 69, 0, 69, 0, 0, 0, 84, 0, 69, 70, 69, 0, 0, 0, 85, 0, 69, 70, 69, 0, 0, 0, 86, 0, 69, 70, 69, 69, 0, 0, 0, 0};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{0, 0, 1, 1, 21, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 19, 0, 1, 1, 0, 25, 1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 21, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 0, 0, 19, 0, 0, 0, 0, 1, 1, 19, 0, 1, 1, 0, 5, 0, 5, 0, 0, 5, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 7, 7, 0, 0, 31, 7, 0, 0, 0, 9, 9, 0, 0, 0, 37, 9, 0, 0, 0, 0, 9, 9, 0, 0, 37, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 37, 9, 0, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 13, 13, 49, 13, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 15, 15, 55, 15, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 7, 7, 0, 0, 0, 31, 7, 0, 11, 11, 43, 11, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 1, 0, 1, 21, 23, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 28, 1, 1, 7, 0, 0, 0, 0, 23, 0, 0, 0, 0, 1, 1, 21, 23, 1, 1, 1, 1, 17, 0, 1, 1, 1, 0, 7, 7, 0, 34, 0, 7, 0, 0, 0, 9, 9, 0, 0, 40, 0, 9, 0, 0, 0, 0, 9, 9, 0, 40, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 40, 9, 0, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 13, 13, 52, 13, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 15, 15, 58, 15, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 7, 7, 0, 34, 0, 0, 7, 0, 11, 11, 46, 11, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 7, 0, 0, 0, 0, 7, 0, 9, 0, 0, 0, 9, 0, 0, 9, 0, 0, 9, 0, 0, 9, 9, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 13, 13, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 15, 15, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 11, 11, 0, 0, 0, 0};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 9, 9, 9, 7, 7, 7, 7, 13, 7, 7, 7, 15, 7, 7, 7, 11, 0, 0};
    }

    private void set(String name, Object value) {
        if (this.current instanceof OrderedMap) {
            ((OrderedMap)this.current).put(name, value);
        } else if (this.current instanceof Array) {
            ((Array)this.current).add(value);
        } else {
            this.root = value;
        }
    }

    protected void startObject(String name) {
        OrderedMap value = new OrderedMap();
        if (this.current != null) {
            this.set(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void startArray(String name) {
        Array value = new Array();
        if (this.current != null) {
            this.set(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void pop() {
        this.root = this.elements.pop();
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    protected void string(String name, String value) {
        this.set(name, value);
    }

    protected void number(String name, float value) {
        this.set(name, Float.valueOf(value));
    }

    protected void bool(String name, boolean value) {
        this.set(name, value);
    }

    private String unescape(String value) {
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length + 16);
        int i = 0;
        while (i < length) {
            char c;
            if ((c = value.charAt(i++)) != '\\') {
                buffer.append(c);
                continue;
            }
            if (i == length) break;
            if ((c = value.charAt(i++)) == 'u') {
                buffer.append(Character.toChars(Integer.parseInt(value.substring(i, i + 4), 16)));
                i += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new SerializationException("Illegal escaped character: \\" + c);
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

