/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.-Base64;
import okio.-Platform;
import okio.-Util;
import okio.ByteString;
import okio.Utf8;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0016\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0001H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0001H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u00020\u0013H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0013H\u0000\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u0013H\u0000\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u001d\u001a\u00020\u001b*\u00020\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u001eH\u0000\u001a\u0014\u0010\u001f\u001a\u00020 *\u00020\u00012\u0006\u0010!\u001a\u00020\tH\u0000\u001a\f\u0010\"\u001a\u00020\t*\u00020\u0001H\u0000\u001a\f\u0010#\u001a\u00020\t*\u00020\u0001H\u0000\u001a\f\u0010$\u001a\u00020\u0013*\u00020\u0001H\u0000\u001a\u001c\u0010%\u001a\u00020\t*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\tH\u0000\u001a\f\u0010'\u001a\u00020\u000b*\u00020\u0001H\u0000\u001a,\u0010(\u001a\u00020\u001b*\u00020\u00012\u0006\u0010)\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tH\u0000\u001a,\u0010(\u001a\u00020\u001b*\u00020\u00012\u0006\u0010)\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tH\u0000\u001a\u0014\u0010,\u001a\u00020\u001b*\u00020\u00012\u0006\u0010-\u001a\u00020\u000bH\u0000\u001a\u0014\u0010,\u001a\u00020\u001b*\u00020\u00012\u0006\u0010-\u001a\u00020\u0001H\u0000\u001a\u001c\u0010.\u001a\u00020\u0001*\u00020\u00012\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0000\u001a\f\u00101\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u00102\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u00103\u001a\u00020\u000b*\u00020\u0001H\u0000\u001a\f\u00104\u001a\u00020\u0013*\u00020\u0001H\u0000\u001a\f\u00105\u001a\u00020\u0013*\u00020\u0001H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00066"}, d2={"COMMON_EMPTY", "Lokio/ByteString;", "getCOMMON_EMPTY", "()Lokio/ByteString;", "COMMON_HEX_DIGITS", "", "getCOMMON_HEX_DIGITS", "()[C", "codePointIndexToCharIndex", "", "s", "", "codePointCount", "commonOf", "data", "decodeHexDigit", "c", "", "commonBase64", "", "commonBase64Url", "commonCompareTo", "other", "commonDecodeBase64", "commonDecodeHex", "commonEncodeUtf8", "commonEndsWith", "", "suffix", "commonEquals", "", "commonGetByte", "", "pos", "commonGetSize", "commonHashCode", "commonHex", "commonIndexOf", "fromIndex", "commonInternalArray", "commonRangeEquals", "offset", "otherOffset", "byteCount", "commonStartsWith", "prefix", "commonSubstring", "beginIndex", "endIndex", "commonToAsciiLowercase", "commonToAsciiUppercase", "commonToByteArray", "commonToString", "commonUtf8", "jvm"})
public final class ByteStringKt {
    @NotNull
    private static final char[] COMMON_HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    @NotNull
    private static final ByteString COMMON_EMPTY = ByteString.Companion.of(new byte[0]);

    @NotNull
    public static final String commonUtf8(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String result = $receiver.getUtf8$jvm();
        if (result == null) {
            result = -Platform.toUtf8String($receiver.getData$jvm());
            $receiver.setUtf8$jvm(result);
        }
        return result;
    }

    @NotNull
    public static final String commonBase64(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return -Base64.encodeBase64$default($receiver.getData$jvm(), null, 1, null);
    }

    @NotNull
    public static final String commonBase64Url(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return -Base64.encodeBase64($receiver.getData$jvm(), -Base64.getBASE64_URL_SAFE());
    }

    @NotNull
    public static final String commonHex(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        char[] result = new char[$receiver.getData$jvm().length * 2];
        int c = 0;
        for (byte b : $receiver.getData$jvm()) {
            int other$iv;
            byte $receiver$iv;
            int n = c++;
            byte by = b;
            int n2 = 4;
            char[] cArray = ByteString.Companion.getHEX_DIGITS$jvm();
            int n3 = n;
            char[] cArray2 = result;
            int n4 = $receiver$iv >> other$iv;
            cArray2[n3] = cArray[n4 & 0xF];
            int n5 = c++;
            $receiver$iv = b;
            other$iv = 15;
            cArray = ByteString.Companion.getHEX_DIGITS$jvm();
            n3 = n5;
            cArray2 = result;
            n4 = $receiver$iv & other$iv;
            cArray2[n3] = cArray[n4];
        }
        return -Platform.createString(result);
    }

    @NotNull
    public static final ByteString commonToAsciiLowercase(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        for (int i = 0; i < $receiver.getData$jvm().length; ++i) {
            byte c = $receiver.getData$jvm()[i];
            if (c < (byte)65 || c > (byte)90) {
                continue;
            }
            byte[] byArray = $receiver.getData$jvm();
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
            byte[] lowercase = byArray2;
            lowercase[i++] = (byte)(c - -32);
            while (i < lowercase.length) {
                c = lowercase[i];
                if (c < (byte)65 || c > (byte)90) {
                    ++i;
                    continue;
                }
                lowercase[i] = (byte)(c - -32);
                ++i;
            }
            return new ByteString(lowercase);
        }
        return $receiver;
    }

    @NotNull
    public static final ByteString commonToAsciiUppercase(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        for (int i = 0; i < $receiver.getData$jvm().length; ++i) {
            byte c = $receiver.getData$jvm()[i];
            if (c < (byte)97 || c > (byte)122) {
                continue;
            }
            byte[] byArray = $receiver.getData$jvm();
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
            byte[] lowercase = byArray2;
            lowercase[i++] = (byte)(c - 32);
            while (i < lowercase.length) {
                c = lowercase[i];
                if (c < (byte)97 || c > (byte)122) {
                    ++i;
                    continue;
                }
                lowercase[i] = (byte)(c - 32);
                ++i;
            }
            return new ByteString(lowercase);
        }
        return $receiver;
    }

    @NotNull
    public static final ByteString commonSubstring(@NotNull ByteString $receiver, int beginIndex, int endIndex) {
        boolean $i$a$2$require;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl2 = bl = beginIndex >= 0;
        if (!bl) {
            String string = "beginIndex < 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = endIndex <= $receiver.getData$jvm().length;
        if (!bl) {
            String string = "endIndex > length(" + $receiver.getData$jvm().length + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int subLen = endIndex - beginIndex;
        boolean bl4 = $i$a$2$require = subLen >= 0;
        if (!$i$a$2$require) {
            String string = "endIndex < beginIndex";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (beginIndex == 0 && endIndex == $receiver.getData$jvm().length) {
            return $receiver;
        }
        byte[] copy = new byte[subLen];
        -Platform.arraycopy($receiver.getData$jvm(), beginIndex, copy, 0, subLen);
        return new ByteString(copy);
    }

    public static final byte commonGetByte(@NotNull ByteString $receiver, int pos) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getData$jvm()[pos];
    }

    public static final int commonGetSize(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getData$jvm().length;
    }

    @NotNull
    public static final byte[] commonToByteArray(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = $receiver.getData$jvm();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return byArray2;
    }

    @NotNull
    public static final byte[] commonInternalArray(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getData$jvm();
    }

    public static final boolean commonRangeEquals(@NotNull ByteString $receiver, int offset, @NotNull ByteString other, int otherOffset, int byteCount) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.rangeEquals(otherOffset, $receiver.getData$jvm(), offset, byteCount);
    }

    public static final boolean commonRangeEquals(@NotNull ByteString $receiver, int offset, @NotNull byte[] other, int otherOffset, int byteCount) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return offset >= 0 && offset <= $receiver.getData$jvm().length - byteCount && otherOffset >= 0 && otherOffset <= other.length - byteCount && -Util.arrayRangeEquals($receiver.getData$jvm(), offset, other, otherOffset, byteCount);
    }

    public static final boolean commonStartsWith(@NotNull ByteString $receiver, @NotNull ByteString prefix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return $receiver.rangeEquals(0, prefix, 0, prefix.size());
    }

    public static final boolean commonStartsWith(@NotNull ByteString $receiver, @NotNull byte[] prefix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        return $receiver.rangeEquals(0, prefix, 0, prefix.length);
    }

    public static final boolean commonEndsWith(@NotNull ByteString $receiver, @NotNull ByteString suffix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return $receiver.rangeEquals($receiver.size() - suffix.size(), suffix, 0, suffix.size());
    }

    public static final boolean commonEndsWith(@NotNull ByteString $receiver, @NotNull byte[] suffix) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        return $receiver.rangeEquals($receiver.size() - suffix.length, suffix, 0, suffix.length);
    }

    /*
     * WARNING - void declaration
     */
    public static final int commonIndexOf(@NotNull ByteString $receiver, @NotNull byte[] other, int fromIndex) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int limit = $receiver.getData$jvm().length - other.length;
        int n = 0;
        int n2 = Math.max(fromIndex, n);
        int n3 = limit;
        if (n2 <= n3) {
            while (true) {
                void i;
                if (-Util.arrayRangeEquals($receiver.getData$jvm(), (int)i, other, 0, other.length)) {
                    return (int)i;
                }
                if (i == n3) break;
                ++i;
            }
        }
        return -1;
    }

    public static final boolean commonEquals(@NotNull ByteString $receiver, @Nullable Object other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return other == $receiver ? true : (other instanceof ByteString ? ((ByteString)other).size() == $receiver.getData$jvm().length && ((ByteString)other).rangeEquals(0, $receiver.getData$jvm(), 0, $receiver.getData$jvm().length) : false);
    }

    public static final int commonHashCode(@NotNull ByteString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        int result = $receiver.getHashCode$jvm();
        if (result != 0) {
            return result;
        }
        $receiver.setHashCode$jvm(-Platform.hashCode($receiver.getData$jvm()));
        return $receiver.getHashCode$jvm();
    }

    /*
     * WARNING - void declaration
     */
    public static final int commonCompareTo(@NotNull ByteString $receiver, @NotNull ByteString other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int sizeA = $receiver.size();
        int sizeB = other.size();
        int size = Math.min(sizeA, sizeB);
        for (int i = 0; i < size; ++i) {
            void $receiver$iv;
            void $receiver$iv2;
            byte by = $receiver.getByte(i);
            int other$iv = 255;
            int byteA = $receiver$iv2 & other$iv;
            other$iv = other.getByte(i);
            int other$iv2 = 255;
            int byteB = $receiver$iv & other$iv2;
            if (byteA == byteB) {
                continue;
            }
            return byteA < byteB ? -1 : 1;
        }
        if (sizeA == sizeB) {
            return 0;
        }
        return sizeA < sizeB ? -1 : 1;
    }

    @NotNull
    public static final char[] getCOMMON_HEX_DIGITS() {
        return COMMON_HEX_DIGITS;
    }

    @NotNull
    public static final ByteString getCOMMON_EMPTY() {
        return COMMON_EMPTY;
    }

    @NotNull
    public static final ByteString commonOf(@NotNull byte[] data) {
        ByteString byteString;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        byte[] byArray = data;
        ByteString byteString2 = byteString;
        ByteString byteString3 = byteString;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] byArray3 = byArray2;
        byteString2(byArray3);
        return byteString3;
    }

    @NotNull
    public static final ByteString commonEncodeUtf8(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ByteString byteString = new ByteString(-Platform.asUtf8ToByteArray($receiver));
        byteString.setUtf8$jvm($receiver);
        return byteString;
    }

    @Nullable
    public static final ByteString commonDecodeBase64(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] decoded = -Base64.decodeBase64ToArray($receiver);
        return decoded != null ? new ByteString(decoded) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ByteString commonDecodeHex(@NotNull String $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl2 = bl = $receiver.length() % 2 == 0;
        if (!bl) {
            String string = "Unexpected hex string: " + $receiver;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        byte[] result = new byte[$receiver.length() / 2];
        int $i$a$1$require = 0;
        int n = result.length;
        while ($i$a$1$require < n) {
            void i;
            int d1 = ByteStringKt.decodeHexDigit($receiver.charAt((int)(i * 2))) << 4;
            int d2 = ByteStringKt.decodeHexDigit($receiver.charAt((int)(i * 2 + true)));
            result[i] = (byte)(d1 + d2);
            ++i;
        }
        return new ByteString(result);
    }

    private static final int decodeHexDigit(char c) {
        int n;
        char c2 = c;
        char c3 = c2;
        if ('0' <= c3 && '9' >= c3) {
            n = c - 48;
        } else {
            c3 = c2;
            if ('a' <= c3 && 'f' >= c3) {
                n = c - 97 + 10;
            } else {
                c3 = c2;
                if ('A' <= c3 && 'F' >= c3) {
                    n = c - 65 + 10;
                } else {
                    throw (Throwable)new IllegalArgumentException("Unexpected hex digit: " + c);
                }
            }
        }
        return n;
    }

    @NotNull
    public static final String commonToString(@NotNull ByteString $receiver) {
        String text;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = $receiver.getData$jvm();
        if (byArray.length == 0) {
            return "[size=0]";
        }
        int i = ByteStringKt.codePointIndexToCharIndex($receiver.getData$jvm(), 64);
        if (i == -1) {
            return $receiver.getData$jvm().length <= 64 ? "[hex=" + $receiver.hex() + ']' : "[size=" + $receiver.getData$jvm().length + " hex=" + ByteStringKt.commonSubstring($receiver, 0, 64).hex() + "\u2026]";
        }
        String string = text = $receiver.utf8();
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, i);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String safeText = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null);
        return i < text.length() ? "[size=" + $receiver.getData$jvm().length + " text=" + safeText + "\u2026]" : "[text=" + safeText + ']';
    }

    public static final int codePointIndexToCharIndex(@NotNull byte[] s, int codePointCount) {
        int c;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        int charCount = 0;
        int j = 0;
        int length = s.length;
        for (int byteIndex = 0; byteIndex < length; byteIndex += Utf8.codePointByteCount(c)) {
            if (j == codePointCount) {
                return charCount;
            }
            c = Utf8.codePointAt(s, byteIndex);
            if (c != 10 && c != 13 && Utf8.isIsoControl(c) || c == 65533) {
                return -1;
            }
            ++j;
            charCount += Utf8.codePointCharCount(c);
        }
        return charCount;
    }
}

