/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import okio.-Util;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020!H\u0016J \u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u000fH\u0016J\b\u0010%\u001a\u00020!H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010&\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010'\u001a\u00020\rH\u0016J\u0010\u0010(\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020!H\u0016J\u0018\u0010(\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020\u001cH\u0016J\b\u0010+\u001a\u00020\u001cH\u0016J\b\u0010,\u001a\u00020\rH\u0016J\b\u0010-\u001a\u00020\rH\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020/H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0018\u00101\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000202H\u0016J\u0010\u00105\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u00106\u001a\u00020\u001cH\u0016J\n\u00107\u001a\u0004\u0018\u000102H\u0016J\b\u00108\u001a\u000202H\u0016J\u0010\u00108\u001a\u0002022\u0006\u00109\u001a\u00020\rH\u0016J\u0010\u0010:\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010;\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u000202H\u0016R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lokio/RealBufferedSource;", "Lokio/BufferedSource;", "source", "Lokio/Source;", "(Lokio/Source;)V", "buffer", "Lokio/Buffer;", "closed", "", "close", "", "exhausted", "indexOf", "", "b", "", "fromIndex", "toIndex", "bytes", "Lokio/ByteString;", "indexOfElement", "targetBytes", "inputStream", "Ljava/io/InputStream;", "isOpen", "rangeEquals", "offset", "bytesOffset", "", "byteCount", "read", "sink", "Ljava/nio/ByteBuffer;", "", "readAll", "Lokio/Sink;", "readByte", "readByteArray", "readByteString", "readDecimalLong", "readFully", "readHexadecimalUnsignedLong", "readInt", "readIntLe", "readLong", "readLongLe", "readShort", "", "readShortLe", "readString", "", "charset", "Ljava/nio/charset/Charset;", "readUtf8", "readUtf8CodePoint", "readUtf8Line", "readUtf8LineStrict", "limit", "request", "require", "select", "options", "Lokio/Options;", "skip", "timeout", "Lokio/Timeout;", "toString", "jvm"})
public final class RealBufferedSource
implements BufferedSource {
    @JvmField
    public boolean closed;
    @JvmField
    @NotNull
    public final Buffer buffer;
    @JvmField
    @NotNull
    public final Source source;

    @Override
    @NotNull
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public long read(@NotNull Buffer sink2, long byteCount) {
        long read;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        boolean bl2 = bl = byteCount >= 0L;
        if (!bl) {
            String string = "byteCount < 0: " + byteCount;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = !this.closed;
        if (!bl) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (this.buffer.size() == 0L && (read = this.source.read(this.buffer, 8192)) == -1L) {
            return -1L;
        }
        long l = this.buffer.size();
        long toRead = Math.min(byteCount, l);
        return this.buffer.read(sink2, toRead);
    }

    @Override
    public boolean exhausted() {
        boolean bl;
        boolean bl2 = bl = !this.closed;
        if (!bl) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.buffer.exhausted() && this.source.read(this.buffer, 8192) == -1L;
    }

    @Override
    public void require(long byteCount) {
        if (!this.request(byteCount)) {
            throw (Throwable)new EOFException();
        }
    }

    @Override
    public boolean request(long byteCount) {
        boolean bl;
        boolean bl2 = bl = byteCount >= 0L;
        if (!bl) {
            String string = "byteCount < 0: " + byteCount;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = !this.closed;
        if (!bl) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        while (this.buffer.size() < byteCount) {
            if (this.source.read(this.buffer, 8192) != -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte readByte() {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    @NotNull
    public ByteString readByteString() {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteString();
    }

    @Override
    @NotNull
    public ByteString readByteString(long byteCount) {
        this.require(byteCount);
        return this.buffer.readByteString(byteCount);
    }

    @Override
    public int select(@NotNull Options options) {
        int index;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        boolean bl2 = bl = !this.closed;
        if (!bl) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        block4: while (true) {
            index = this.buffer.selectPrefix$jvm(options, true);
            switch (index) {
                case -1: {
                    return -1;
                }
                case -2: {
                    if (this.source.read(this.buffer, 8192) != -1L) continue block4;
                    return -1;
                }
            }
            break;
        }
        int selectedSize = options.getByteStrings$jvm()[index].size();
        this.buffer.skip(selectedSize);
        return index;
    }

    @Override
    @NotNull
    public byte[] readByteArray() {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteArray();
    }

    @Override
    @NotNull
    public byte[] readByteArray(long byteCount) {
        this.require(byteCount);
        return this.buffer.readByteArray(byteCount);
    }

    @Override
    public int read(@NotNull byte[] sink2) {
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        return this.read(sink2, 0, sink2.length);
    }

    @Override
    public void readFully(@NotNull byte[] sink2) {
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        try {
            this.require(sink2.length);
        }
        catch (EOFException e) {
            int offset = 0;
            while (this.buffer.size() > 0L) {
                int read = this.buffer.read(sink2, offset, (int)this.buffer.size());
                if (read == -1) {
                    throw (Throwable)((Object)new AssertionError());
                }
                offset += read;
            }
            throw (Throwable)e;
        }
        this.buffer.readFully(sink2);
    }

    @Override
    public int read(@NotNull byte[] sink2, int offset, int byteCount) {
        long read;
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        -Util.checkOffsetAndCount(sink2.length, offset, byteCount);
        if (this.buffer.size() == 0L && (read = this.source.read(this.buffer, 8192)) == -1L) {
            return -1;
        }
        long b$iv = this.buffer.size();
        long l = byteCount;
        int toRead = (int)Math.min(l, b$iv);
        return this.buffer.read(sink2, offset, toRead);
    }

    @Override
    public int read(@NotNull ByteBuffer sink2) {
        long read;
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        if (this.buffer.size() == 0L && (read = this.source.read(this.buffer, 8192)) == -1L) {
            return -1;
        }
        return this.buffer.read(sink2);
    }

    @Override
    public void readFully(@NotNull Buffer sink2, long byteCount) {
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        try {
            this.require(byteCount);
        }
        catch (EOFException e) {
            sink2.writeAll(this.buffer);
            throw (Throwable)e;
        }
        this.buffer.readFully(sink2, byteCount);
    }

    @Override
    public long readAll(@NotNull Sink sink2) {
        Intrinsics.checkParameterIsNotNull((Object)sink2, (String)"sink");
        long totalBytesWritten = 0L;
        while (this.source.read(this.buffer, 8192) != -1L) {
            long emitByteCount = this.buffer.completeSegmentByteCount();
            if (emitByteCount <= 0L) continue;
            totalBytesWritten += emitByteCount;
            sink2.write(this.buffer, emitByteCount);
        }
        if (this.buffer.size() > 0L) {
            totalBytesWritten += this.buffer.size();
            sink2.write(this.buffer, this.buffer.size());
        }
        return totalBytesWritten;
    }

    @Override
    @NotNull
    public String readUtf8() {
        this.buffer.writeAll(this.source);
        return this.buffer.readUtf8();
    }

    @Override
    @NotNull
    public String readUtf8(long byteCount) {
        this.require(byteCount);
        return this.buffer.readUtf8(byteCount);
    }

    @Override
    @NotNull
    public String readString(@NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        this.buffer.writeAll(this.source);
        return this.buffer.readString(charset);
    }

    @Override
    @NotNull
    public String readString(long byteCount, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        this.require(byteCount);
        return this.buffer.readString(byteCount, charset);
    }

    @Override
    @Nullable
    public String readUtf8Line() {
        long newline = this.indexOf((byte)10);
        return newline == -1L ? (this.buffer.size() != 0L ? this.readUtf8(this.buffer.size()) : null) : this.buffer.readUtf8Line$jvm(newline);
    }

    @Override
    @NotNull
    public String readUtf8LineStrict() {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String readUtf8LineStrict(long limit) {
        EOFException eOFException;
        void b$iv;
        void a$iv;
        boolean bl;
        boolean bl2 = bl = limit >= 0L;
        if (!bl) {
            String string = "limit < 0: " + limit;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long scanLength = limit == Long.MAX_VALUE ? Long.MAX_VALUE : limit + 1L;
        long newline = this.indexOf((byte)10, 0L, scanLength);
        if (newline != -1L) {
            return this.buffer.readUtf8Line$jvm(newline);
        }
        if (scanLength < Long.MAX_VALUE && this.request(scanLength) && this.buffer.getByte(scanLength - 1L) == (byte)13 && this.request(scanLength + 1L) && this.buffer.getByte(scanLength) == (byte)10) {
            return this.buffer.readUtf8Line$jvm(scanLength);
        }
        Buffer data = new Buffer();
        int n = 32;
        long l = this.buffer.size();
        long l2 = 0L;
        Object object = data;
        Object object2 = this.buffer;
        long l3 = (long)a$iv;
        long l4 = Math.min(l3, (long)b$iv);
        ((Buffer)object2).copyTo((Buffer)object, l2, l4);
        long l5 = this.buffer.size();
        StringBuilder stringBuilder = new StringBuilder().append("\\n not found: limit=");
        object = eOFException;
        object2 = eOFException;
        long l6 = Math.min(l5, limit);
        ((EOFException)object)(stringBuilder.append(l6).append(" content=").append(data.readByteString().hex()).append("\u2026").toString());
        throw (Throwable)object2;
    }

    @Override
    public int readUtf8CodePoint() {
        this.require(1L);
        byte b0 = this.buffer.getByte(0L);
        if ((b0 & 0xE0) == 192) {
            this.require(2L);
        } else if ((b0 & 0xF0) == 224) {
            this.require(3L);
        } else if ((b0 & 0xF8) == 240) {
            this.require(4L);
        }
        return this.buffer.readUtf8CodePoint();
    }

    @Override
    public short readShort() {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLe() {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public int readInt() {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLe() {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public long readLong() {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLe() {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    @Override
    public long readDecimalLong() {
        this.require(1L);
        long pos = 0L;
        while (this.request(pos + 1L)) {
            byte b = this.buffer.getByte(pos);
            if (!(b >= (byte)48 && b <= (byte)57 || pos == 0L && b == (byte)45)) {
                NumberFormatException numberFormatException;
                if (pos != 0L) break;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Expected leading [0-9] or '-' character but was %#x";
                Object[] objectArray = new Object[]{b};
                NumberFormatException numberFormatException2 = numberFormatException;
                NumberFormatException numberFormatException3 = numberFormatException;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                numberFormatException2(string3);
                throw (Throwable)numberFormatException3;
            }
            long l = pos;
            pos = l + 1L;
        }
        return this.buffer.readDecimalLong();
    }

    @Override
    public long readHexadecimalUnsignedLong() {
        this.require(1L);
        int pos = 0;
        while (this.request(pos + 1)) {
            byte b = this.buffer.getByte(pos);
            if (!(b >= (byte)48 && b <= (byte)57 || b >= (byte)97 && b <= (byte)102 || b >= (byte)65 && b <= (byte)70)) {
                NumberFormatException numberFormatException;
                if (pos != 0) break;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Expected leading [0-9a-fA-F] character but was %#x";
                Object[] objectArray = new Object[]{b};
                NumberFormatException numberFormatException2 = numberFormatException;
                NumberFormatException numberFormatException3 = numberFormatException;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                String string3 = string2;
                numberFormatException2(string3);
                throw (Throwable)numberFormatException3;
            }
            ++pos;
        }
        return this.buffer.readHexadecimalUnsignedLong();
    }

    @Override
    public void skip(long byteCount) {
        long toSkip;
        boolean bl;
        boolean bl2 = bl = !this.closed;
        if (!bl) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        for (long byteCount2 = byteCount; byteCount2 > 0L; byteCount2 -= toSkip) {
            if (this.buffer.size() == 0L && this.source.read(this.buffer, 8192) == -1L) {
                throw (Throwable)new EOFException();
            }
            long l = this.buffer.size();
            toSkip = Math.min(byteCount2, l);
            this.buffer.skip(toSkip);
        }
    }

    @Override
    public long indexOf(byte b) {
        return this.indexOf(b, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte b, long fromIndex) {
        return this.indexOf(b, fromIndex, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte b, long fromIndex, long toIndex) {
        boolean bl;
        boolean bl2;
        long fromIndex2 = fromIndex;
        boolean bl3 = bl2 = !this.closed;
        if (!bl2) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        long l = fromIndex2;
        boolean bl4 = bl = 0L <= l && toIndex >= l;
        if (!bl) {
            String string = "fromIndex=" + fromIndex2 + " toIndex=" + toIndex;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        while (fromIndex2 < toIndex) {
            long l2;
            long result = this.buffer.indexOf(b, fromIndex2, toIndex);
            if (result != -1L) {
                return result;
            }
            long lastBufferSize = this.buffer.size();
            if (lastBufferSize >= toIndex || this.source.read(this.buffer, 8192) == -1L) {
                return -1L;
            }
            long l3 = fromIndex2;
            fromIndex2 = l2 = Math.max(l3, lastBufferSize);
        }
        return -1L;
    }

    @Override
    public long indexOf(@NotNull ByteString bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return this.indexOf(bytes, 0L);
    }

    @Override
    public long indexOf(@NotNull ByteString bytes, long fromIndex) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        long fromIndex2 = fromIndex;
        boolean bl2 = bl = !this.closed;
        if (!bl) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        long result;
        while ((result = this.buffer.indexOf(bytes, fromIndex2)) == -1L) {
            long lastBufferSize = this.buffer.size();
            if (this.source.read(this.buffer, 8192) == -1L) {
                return -1L;
            }
            long l = lastBufferSize - (long)bytes.size() + 1L;
            fromIndex2 = Math.max(fromIndex2, l);
        }
        return result;
    }

    @Override
    public long indexOfElement(@NotNull ByteString targetBytes) {
        Intrinsics.checkParameterIsNotNull((Object)targetBytes, (String)"targetBytes");
        return this.indexOfElement(targetBytes, 0L);
    }

    @Override
    public long indexOfElement(@NotNull ByteString targetBytes, long fromIndex) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)targetBytes, (String)"targetBytes");
        long fromIndex2 = fromIndex;
        boolean bl2 = bl = !this.closed;
        if (!bl) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        long result;
        while ((result = this.buffer.indexOfElement(targetBytes, fromIndex2)) == -1L) {
            long lastBufferSize = this.buffer.size();
            if (this.source.read(this.buffer, 8192) == -1L) {
                return -1L;
            }
            fromIndex2 = Math.max(fromIndex2, lastBufferSize);
        }
        return result;
    }

    @Override
    public boolean rangeEquals(long offset, @NotNull ByteString bytes) {
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        return this.rangeEquals(offset, bytes, 0, bytes.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean rangeEquals(long offset, @NotNull ByteString bytes, int bytesOffset, int byteCount) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        int n2 = n = !this.closed ? 1 : 0;
        if (n == 0) {
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (offset < 0L || bytesOffset < 0 || byteCount < 0 || bytes.size() - bytesOffset < byteCount) {
            return false;
        }
        n = 0;
        int n3 = byteCount;
        while (n < n3) {
            void i;
            long bufferOffset = offset + (long)i;
            if (!this.request(bufferOffset + 1L)) {
                return false;
            }
            if (this.buffer.getByte(bufferOffset) != bytes.getByte(bytesOffset + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    @NotNull
    public InputStream inputStream() {
        return new InputStream(this){
            final /* synthetic */ RealBufferedSource this$0;

            /*
             * WARNING - void declaration
             */
            public int read() {
                void $receiver$iv;
                long count22;
                if (this.this$0.closed) {
                    throw (Throwable)new IOException("closed");
                }
                if (this.this$0.buffer.size() == 0L && (count22 = this.this$0.source.read(this.this$0.buffer, 8192)) == -1L) {
                    return -1;
                }
                byte count22 = this.this$0.buffer.readByte();
                int other$iv = 255;
                return $receiver$iv & other$iv;
            }

            public int read(@NotNull byte[] data, int offset, int byteCount) {
                long count;
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                if (this.this$0.closed) {
                    throw (Throwable)new IOException("closed");
                }
                -Util.checkOffsetAndCount(data.length, offset, byteCount);
                if (this.this$0.buffer.size() == 0L && (count = this.this$0.source.read(this.this$0.buffer, 8192)) == -1L) {
                    return -1;
                }
                return this.this$0.buffer.read(data, offset, byteCount);
            }

            /*
             * WARNING - void declaration
             */
            public int available() {
                void a$iv;
                if (this.this$0.closed) {
                    throw (Throwable)new IOException("closed");
                }
                long l = this.this$0.buffer.size();
                int b$iv = Integer.MAX_VALUE;
                long l2 = b$iv;
                return (int)Math.min((long)a$iv, l2);
            }

            public void close() {
                this.this$0.close();
            }

            @NotNull
            public String toString() {
                return this.this$0 + ".inputStream()";
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.source.timeout();
    }

    @NotNull
    public String toString() {
        return "buffer(" + this.source + ')';
    }

    public RealBufferedSource(@NotNull Source source2) {
        Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
        this.source = source2;
        this.buffer = new Buffer();
    }
}

