/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.versatile;

import java.util.HashMap;
import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.data.MLData;
import org.encog.ml.data.versatile.ColumnDefinition;
import org.encog.ml.data.versatile.ColumnType;
import org.encog.ml.data.versatile.NormalizationStrategy;
import org.encog.ml.data.versatile.Normalizer;
import org.encog.ml.data.versatile.normalizers.OneOfNNormalizer;
import org.encog.ml.data.versatile.normalizers.RangeNormalizer;
import org.encog.ml.data.versatile.normalizers.RangeOrdinal;

public class BasicNormalizationStrategy
implements NormalizationStrategy {
    private final Map<ColumnType, Normalizer> inputNormalizers = new HashMap<ColumnType, Normalizer>();
    private final Map<ColumnType, Normalizer> outputNormalizers = new HashMap<ColumnType, Normalizer>();

    public BasicNormalizationStrategy() {
    }

    public BasicNormalizationStrategy(double inputLow, double inputHigh, double outputLow, double outputHigh) {
        this.assignInputNormalizer(ColumnType.continuous, (Normalizer)((Object)new RangeNormalizer(inputLow, inputHigh)));
        this.assignInputNormalizer(ColumnType.nominal, (Normalizer)((Object)new OneOfNNormalizer(inputLow, inputHigh)));
        this.assignInputNormalizer(ColumnType.ordinal, (Normalizer)((Object)new RangeOrdinal(inputLow, inputHigh)));
        this.assignOutputNormalizer(ColumnType.continuous, (Normalizer)((Object)new RangeNormalizer(outputLow, outputHigh)));
        this.assignOutputNormalizer(ColumnType.nominal, (Normalizer)((Object)new OneOfNNormalizer(outputLow, outputHigh)));
        this.assignOutputNormalizer(ColumnType.ordinal, (Normalizer)((Object)new RangeOrdinal(outputLow, outputHigh)));
    }

    public void assignInputNormalizer(ColumnType colType, Normalizer norm) {
        this.inputNormalizers.put(colType, norm);
    }

    public void assignOutputNormalizer(ColumnType colType, Normalizer norm) {
        this.outputNormalizers.put(colType, norm);
    }

    @Override
    public int calculateTotalRows(int analyzedRows) {
        return analyzedRows;
    }

    private Normalizer findNormalizer(ColumnDefinition colDef, boolean isInput) {
        Normalizer norm = null;
        if (isInput) {
            if (this.inputNormalizers.containsKey((Object)colDef.getDataType())) {
                norm = this.inputNormalizers.get((Object)colDef.getDataType());
            }
        } else if (this.outputNormalizers.containsKey((Object)colDef.getDataType())) {
            norm = this.outputNormalizers.get((Object)colDef.getDataType());
        }
        if (norm == null) {
            throw new EncogError("No normalizer defined for input=" + isInput + ", type=" + (Object)((Object)colDef.getDataType()));
        }
        return norm;
    }

    @Override
    public int normalizedSize(ColumnDefinition colDef, boolean isInput) {
        Normalizer norm = this.findNormalizer(colDef, isInput);
        return norm.outputSize(colDef);
    }

    @Override
    public int normalizeColumn(ColumnDefinition colDef, boolean isInput, String value, double[] outputData, int outputColumn) {
        Normalizer norm = this.findNormalizer(colDef, isInput);
        return norm.normalizeColumn(colDef, value, outputData, outputColumn);
    }

    @Override
    public int normalizeColumn(ColumnDefinition colDef, boolean isInput, double value, double[] outputData, int outputColumn) {
        Normalizer norm = this.findNormalizer(colDef, isInput);
        return norm.normalizeColumn(colDef, value, outputData, outputColumn);
    }

    public Map<ColumnType, Normalizer> getInputNormalizers() {
        return this.inputNormalizers;
    }

    public Map<ColumnType, Normalizer> getOutputNormalizers() {
        return this.outputNormalizers;
    }

    @Override
    public String denormalizeColumn(ColumnDefinition colDef, boolean isInput, MLData data, int dataColumn) {
        Normalizer norm = this.findNormalizer(colDef, isInput);
        return norm.denormalizeColumn(colDef, data, dataColumn);
    }
}

