/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.versatile;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.data.versatile.VersatileDataSource;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class CSVDataSource
implements VersatileDataSource {
    private ReadCSV reader;
    private final File file;
    private final boolean headers;
    private final CSVFormat format;
    private final Map<String, Integer> headerIndex = new HashMap<String, Integer>();

    public CSVDataSource(File file, boolean headers, char delim) {
        this.format = new CSVFormat(CSVFormat.getDecimalCharacter(), delim);
        this.headers = headers;
        this.file = file;
    }

    public CSVDataSource(File file, boolean headers, CSVFormat format) {
        this.file = file;
        this.headers = headers;
        this.format = format;
    }

    @Override
    public String[] readLine() {
        if (this.reader == null) {
            throw new EncogError("Please call rewind before reading the file.");
        }
        if (this.reader.next()) {
            int len = this.reader.getColumnCount();
            String[] result = new String[len];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.reader.get(i);
            }
            return result;
        }
        this.reader.close();
        return null;
    }

    @Override
    public void rewind() {
        this.reader = new ReadCSV(this.file, this.headers, this.format);
        if (this.headerIndex.size() == 0) {
            for (int i = 0; i < this.reader.getColumnNames().size(); ++i) {
                this.headerIndex.put(this.reader.getColumnNames().get(i), i);
            }
        }
    }

    @Override
    public int columnIndex(String name) {
        String name2 = name.toLowerCase();
        if (!this.headerIndex.containsKey(name2)) {
            return -1;
        }
        return this.headerIndex.get(name2);
    }
}

