/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.versatile;

import java.util.List;
import org.encog.EncogError;
import org.encog.mathutil.randomize.generate.GenerateRandom;
import org.encog.ml.data.versatile.MatrixMLDataSet;
import org.encog.ml.data.versatile.NormalizationHelper;
import org.encog.ml.data.versatile.columns.ColumnDefinition;
import org.encog.ml.data.versatile.columns.ColumnType;
import org.encog.ml.data.versatile.division.DataDivision;
import org.encog.ml.data.versatile.division.PerformDataDivision;
import org.encog.ml.data.versatile.normalizers.strategies.NormalizationStrategy;
import org.encog.ml.data.versatile.sources.VersatileDataSource;

public class VersatileMLDataSet
extends MatrixMLDataSet {
    private VersatileDataSource source;
    private NormalizationHelper helper = new NormalizationHelper();
    private int analyzedRows;

    public VersatileMLDataSet(VersatileDataSource theSource) {
        this.source = theSource;
    }

    private int findIndex(ColumnDefinition colDef) {
        if (colDef.getIndex() != -1) {
            return colDef.getIndex();
        }
        int index = this.source.columnIndex(colDef.getName());
        colDef.setIndex(index);
        if (index == -1) {
            throw new EncogError("Can't find column");
        }
        return index;
    }

    public void analyze() {
        ColumnDefinition colDef2;
        String[] line;
        this.source.rewind();
        int c = 0;
        while ((line = this.source.readLine()) != null) {
            ++c;
            for (int i = 0; i < this.helper.getSourceColumns().size(); ++i) {
                colDef2 = this.helper.getSourceColumns().get(i);
                int index = this.findIndex(colDef2);
                String value = line[index];
                colDef2.analyze(value);
            }
        }
        this.analyzedRows = c;
        for (ColumnDefinition colDef2 : this.helper.getSourceColumns()) {
            if (colDef2.getDataType() != ColumnType.continuous) continue;
            colDef2.setMean(colDef2.getMean() / (double)colDef2.getCount());
            colDef2.setSd(0.0);
        }
        this.source.rewind();
        while ((line = this.source.readLine()) != null) {
            for (int i = 0; i < this.helper.getSourceColumns().size(); ++i) {
                colDef2 = this.helper.getSourceColumns().get(i);
                String value = line[i];
                if (colDef2.getDataType() != ColumnType.continuous) continue;
                double d = this.helper.parseDouble(value);
                d = colDef2.getMean() - d;
                d *= d;
                colDef2.setSd(colDef2.getSd() + d);
            }
        }
        for (ColumnDefinition colDef2 : this.helper.getSourceColumns()) {
            if (colDef2.getDataType() != ColumnType.continuous) continue;
            colDef2.setSd(Math.sqrt(colDef2.getSd() / (double)colDef2.getCount()));
        }
    }

    public void normalize() {
        String[] line;
        NormalizationStrategy strat = this.helper.getNormStrategy();
        if (strat == null) {
            throw new EncogError("Please choose a model type first, with selectMethod.");
        }
        int normalizedInputColumns = this.helper.calculateNormalizedInputCount();
        int normalizedOutputColumns = this.helper.calculateNormalizedOutputCount();
        int normalizedColumns = normalizedInputColumns + normalizedOutputColumns;
        this.setCalculatedIdealSize(normalizedOutputColumns);
        this.setCalculatedInputSize(normalizedInputColumns);
        this.setData(new double[this.analyzedRows][normalizedColumns]);
        this.source.rewind();
        int row = 0;
        while ((line = this.source.readLine()) != null) {
            String value;
            int index;
            int column = 0;
            for (ColumnDefinition colDef : this.helper.getInputColumns()) {
                index = this.findIndex(colDef);
                value = line[index];
                column = this.helper.normalizeToVector(colDef, column, this.getData()[row], true, value);
            }
            for (ColumnDefinition colDef : this.helper.getOutputColumns()) {
                index = this.findIndex(colDef);
                value = line[index];
                column = this.helper.normalizeToVector(colDef, column, this.getData()[row], false, value);
            }
            ++row;
        }
    }

    public ColumnDefinition defineSourceColumn(String name, int index, ColumnType colType) {
        return this.helper.defineSourceColumn(name, index, colType);
    }

    public NormalizationHelper getNormHelper() {
        return this.helper;
    }

    public void setNormHelper(NormalizationHelper helper) {
        this.helper = helper;
    }

    public void divide(List<DataDivision> dataDivisionList, boolean shuffle, GenerateRandom rnd) {
        if (this.getData() == null) {
            throw new EncogError("Can't divide, data has not yet been generated/normalized.");
        }
        PerformDataDivision divide = new PerformDataDivision(shuffle, rnd);
        divide.perform(dataDivisionList, this, this.getCalculatedInputSize(), this.getCalculatedIdealSize());
    }

    public void defineOutput(ColumnDefinition col) {
        this.helper.getOutputColumns().add(col);
    }

    public void defineInput(ColumnDefinition col) {
        this.helper.getInputColumns().add(col);
    }

    public void defineSingleOutputOthersInput(ColumnDefinition outputColumn) {
        this.helper.clearInputOutput();
        for (ColumnDefinition colDef : this.helper.getSourceColumns()) {
            if (colDef == outputColumn) {
                this.defineOutput(colDef);
                continue;
            }
            if (colDef.getDataType() == ColumnType.ignore) continue;
            this.defineInput(colDef);
        }
    }

    public ColumnDefinition defineSourceColumn(String name, ColumnType colType) {
        return this.helper.defineSourceColumn(name, -1, colType);
    }
}

