/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.expvalue;

import java.io.Serializable;
import org.encog.ml.ea.exception.EARuntimeError;
import org.encog.ml.prg.expvalue.ValueType;

public class ExpressionValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final double floatValue;
    private final boolean boolValue;
    private final ValueType expressionType;
    private final long intValue;
    private final int enumType;

    public ExpressionValue(boolean theValue) {
        this.boolValue = theValue;
        this.expressionType = ValueType.booleanType;
        this.floatValue = 0.0;
        this.stringValue = null;
        this.intValue = 0L;
        this.enumType = -1;
    }

    public ExpressionValue(double theValue) {
        this.floatValue = theValue;
        this.expressionType = ValueType.floatingType;
        this.boolValue = false;
        this.stringValue = null;
        this.intValue = 0L;
        this.enumType = -1;
    }

    public ExpressionValue(ExpressionValue other) {
        this.expressionType = other.expressionType;
        switch (this.expressionType) {
            case booleanType: {
                this.boolValue = other.boolValue;
                this.floatValue = 0.0;
                this.stringValue = null;
                this.intValue = 0L;
                this.enumType = -1;
                break;
            }
            case floatingType: {
                this.floatValue = other.floatValue;
                this.boolValue = false;
                this.stringValue = null;
                this.intValue = 0L;
                this.enumType = -1;
                break;
            }
            case intType: {
                this.intValue = other.intValue;
                this.boolValue = false;
                this.floatValue = 0.0;
                this.stringValue = null;
                this.enumType = -1;
                break;
            }
            case stringType: {
                this.stringValue = other.stringValue;
                this.boolValue = false;
                this.floatValue = 0.0;
                this.intValue = 0L;
                this.enumType = -1;
                break;
            }
            case enumType: {
                this.intValue = other.intValue;
                this.boolValue = false;
                this.floatValue = 0.0;
                this.stringValue = null;
                this.enumType = other.enumType;
                break;
            }
            default: {
                throw new EARuntimeError("Unsupported type.");
            }
        }
    }

    public ExpressionValue(int enumType, long theValue) {
        this.intValue = theValue;
        this.expressionType = ValueType.enumType;
        this.boolValue = false;
        this.floatValue = 0.0;
        this.stringValue = null;
        this.enumType = enumType;
    }

    public ExpressionValue(long theValue) {
        this.intValue = theValue;
        this.expressionType = ValueType.intType;
        this.boolValue = false;
        this.floatValue = 0.0;
        this.stringValue = null;
        this.enumType = -1;
    }

    public ExpressionValue(String theValue) {
        this.stringValue = theValue;
        this.expressionType = ValueType.stringType;
        this.boolValue = false;
        this.floatValue = 0.0;
        this.intValue = 0L;
        this.enumType = -1;
    }

    public ExpressionValue(ValueType theType) {
        this.expressionType = theType;
        this.intValue = 0L;
        this.boolValue = false;
        this.floatValue = 0.0;
        this.stringValue = null;
        this.enumType = -1;
    }

    public int getEnumType() {
        return this.enumType;
    }

    public ValueType getExpressionType() {
        return this.expressionType;
    }

    public boolean isBoolean() {
        return this.expressionType == ValueType.booleanType;
    }

    public boolean isEnum() {
        return this.expressionType == ValueType.enumType;
    }

    public boolean isFloat() {
        return this.expressionType == ValueType.floatingType;
    }

    public boolean isInt() {
        return this.expressionType == ValueType.intType;
    }

    public boolean isNumeric() {
        return this.isFloat() || this.isInt();
    }

    public boolean isString() {
        return this.expressionType == ValueType.stringType;
    }

    public boolean toBooleanValue() {
        switch (this.expressionType) {
            case intType: {
                throw new EARuntimeError("Type Mismatch: can't convert " + this.intValue + " to boolean.");
            }
            case floatingType: {
                throw new EARuntimeError("Type Mismatch: can't convert " + this.floatValue + " to boolean.");
            }
            case booleanType: {
                return this.boolValue;
            }
            case stringType: {
                throw new EARuntimeError("Type Mismatch: can't convert " + this.stringValue + " to boolean.");
            }
            case enumType: {
                throw new EARuntimeError("Type Mismatch: can't convert enum to boolean.");
            }
        }
        throw new EARuntimeError("Unknown type: " + (Object)((Object)this.expressionType));
    }

    public double toFloatValue() {
        switch (this.expressionType) {
            case intType: {
                return this.intValue;
            }
            case floatingType: {
                return this.floatValue;
            }
            case booleanType: {
                throw new EARuntimeError("Type Mismatch: can't convert float to boolean.");
            }
            case stringType: {
                try {
                    return Double.parseDouble(this.stringValue);
                }
                catch (NumberFormatException ex) {
                    throw new EARuntimeError("Type Mismatch: can't convert " + this.stringValue + " to floating point.");
                }
            }
            case enumType: {
                throw new EARuntimeError("Type Mismatch: can't convert enum to float.");
            }
        }
        throw new EARuntimeError("Unknown type: " + (Object)((Object)this.expressionType));
    }

    public long toIntValue() {
        switch (this.expressionType) {
            case intType: {
                return this.intValue;
            }
            case floatingType: {
                return (int)this.floatValue;
            }
            case booleanType: {
                throw new EARuntimeError("Type Mismatch: can't convert int to boolean.");
            }
            case stringType: {
                try {
                    return Long.parseLong(this.stringValue);
                }
                catch (NumberFormatException ex) {
                    throw new EARuntimeError("Type Mismatch: can't convert " + this.stringValue + " to int.");
                }
            }
            case enumType: {
                return this.intValue;
            }
        }
        throw new EARuntimeError("Unknown type: " + (Object)((Object)this.expressionType));
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[ExpressionValue: ");
        result.append("type: ");
        result.append(this.getExpressionType().toString());
        result.append(", String Value: ");
        result.append(this.toStringValue());
        result.append("]");
        return result.toString();
    }

    public String toStringValue() {
        switch (this.expressionType) {
            case intType: {
                return "" + this.intValue;
            }
            case floatingType: {
                return "" + this.floatValue;
            }
            case booleanType: {
                return "" + this.boolValue;
            }
            case stringType: {
                return this.stringValue;
            }
            case enumType: {
                return "[" + this.enumType + ":" + this.intValue + "]";
            }
        }
        throw new EARuntimeError("Unknown type: " + (Object)((Object)this.expressionType));
    }
}

