/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.opp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.neural.neat.NEATGenomeFactory;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;

public class NEATCrossover
implements EvolutionaryOperator {
    private EvolutionaryAlgorithm owner;

    public void addNeuronID(long nodeID, List<NEATNeuronGene> vec, NEATGenome best, NEATGenome notBest) {
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.get(i).getId() != nodeID) continue;
            return;
        }
        vec.add(this.findBestNeuron(nodeID, best, notBest));
    }

    private NEATGenome favorParent(Random rnd, NEATGenome mom, NEATGenome dad) {
        if (mom.getScore() == dad.getScore()) {
            if (mom.getNumGenes() == dad.getNumGenes()) {
                if (rnd.nextDouble() < 0.5) {
                    return mom;
                }
                return dad;
            }
            if (mom.getNumGenes() < dad.getNumGenes()) {
                return mom;
            }
            return dad;
        }
        if (this.owner.getSelectionComparator().compare(mom, dad) < 0) {
            return mom;
        }
        return dad;
    }

    private NEATNeuronGene findBestNeuron(long nodeID, NEATGenome best, NEATGenome notBest) {
        NEATNeuronGene result = best.findNeuron(nodeID);
        if (result == null) {
            result = notBest.findNeuron(nodeID);
        }
        return result;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
        this.owner = theOwner;
    }

    @Override
    public int offspringProduced() {
        return 1;
    }

    @Override
    public int parentsNeeded() {
        return 2;
    }

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        NEATGenome mom = (NEATGenome)parents[parentIndex + 0];
        NEATGenome dad = (NEATGenome)parents[parentIndex + 1];
        NEATGenome best = this.favorParent(rnd, mom, dad);
        NEATGenome notBest = best != mom ? mom : dad;
        ArrayList<NEATLinkGene> selectedLinks = new ArrayList<NEATLinkGene>();
        ArrayList<NEATNeuronGene> selectedNeurons = new ArrayList<NEATNeuronGene>();
        int curMom = 0;
        int curDad = 0;
        NEATLinkGene selectedGene = null;
        int alwaysCount = ((NEATGenome)parents[0]).getInputCount() + ((NEATGenome)parents[0]).getOutputCount() + 1;
        for (int i = 0; i < alwaysCount; ++i) {
            this.addNeuronID(i, selectedNeurons, best, notBest);
        }
        while (curMom < mom.getNumGenes() || curDad < dad.getNumGenes()) {
            NEATLinkGene momGene = null;
            NEATLinkGene dadGene = null;
            long momInnovation = -1L;
            long dadInnovation = -1L;
            if (curMom < mom.getNumGenes()) {
                momGene = mom.getLinksChromosome().get(curMom);
                momInnovation = momGene.getInnovationId();
            }
            if (curDad < dad.getNumGenes()) {
                dadGene = dad.getLinksChromosome().get(curDad);
                dadInnovation = dadGene.getInnovationId();
            }
            if (momGene == null && dadGene != null) {
                if (best == dad) {
                    selectedGene = dadGene;
                }
                ++curDad;
            } else if (dadGene == null && momGene != null) {
                if (best == mom) {
                    selectedGene = momGene;
                }
                ++curMom;
            } else if (momInnovation < dadInnovation) {
                if (best == mom) {
                    selectedGene = momGene;
                }
                ++curMom;
            } else if (dadInnovation < momInnovation) {
                if (best == dad) {
                    selectedGene = dadGene;
                }
                ++curDad;
            } else if (dadInnovation == momInnovation) {
                selectedGene = Math.random() < 0.5 ? momGene : dadGene;
                ++curMom;
                ++curDad;
            }
            if (selectedGene == null) continue;
            if (selectedLinks.size() == 0) {
                selectedLinks.add(selectedGene);
            } else if (((NEATLinkGene)selectedLinks.get(selectedLinks.size() - 1)).getInnovationId() != selectedGene.getInnovationId()) {
                selectedLinks.add(selectedGene);
            }
            this.addNeuronID(selectedGene.getFromNeuronID(), selectedNeurons, best, notBest);
            this.addNeuronID(selectedGene.getToNeuronID(), selectedNeurons, best, notBest);
        }
        Collections.sort(selectedNeurons);
        NEATGenomeFactory factory = (NEATGenomeFactory)this.owner.getPopulation().getGenomeFactory();
        NEATGenome babyGenome = factory.factor(selectedNeurons, selectedLinks, mom.getInputCount(), mom.getOutputCount());
        babyGenome.setBirthGeneration(this.owner.getIteration());
        babyGenome.setPopulation(this.owner.getPopulation());
        babyGenome.sortGenes();
        offspring[offspringIndex] = babyGenome;
    }
}

