/*
 * Decompiled with CFR 0.152.
 */
package org.encog.platformspecific.j2se;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;
import org.encog.util.Format;

public class TrainingDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -6847676575773420316L;
    private JLabel labelError;
    private JLabel labelIterations;
    private JLabel labelTime;
    private JButton buttonStop;
    private boolean shouldStop = false;

    public TrainingDialog() {
        this.setSize(320, 100);
        this.setTitle("Training");
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel statsPanel = new JPanel();
        statsPanel.setLayout(new GridLayout(3, 2));
        statsPanel.add(new JLabel("Current Error:"));
        this.labelError = new JLabel("Starting...");
        statsPanel.add(this.labelError);
        statsPanel.add(new JLabel("Iterations:"));
        this.labelIterations = new JLabel("");
        statsPanel.add(this.labelIterations);
        statsPanel.add(new JLabel("Training Time:"));
        this.labelTime = new JLabel("");
        statsPanel.add(this.labelTime);
        this.buttonStop = new JButton("Stop");
        content.add((Component)this.buttonStop, "South");
        content.add((Component)statsPanel, "Center");
        this.buttonStop.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonStop) {
            this.buttonStop.setEnabled(false);
            this.buttonStop.setText("Stopping...");
            this.shouldStop = true;
        }
    }

    public void setError(double e) {
        this.labelError.setText(Format.formatPercent(e));
    }

    public void setIterations(int iteration) {
        this.labelIterations.setText(Format.formatInteger(iteration));
    }

    public void setTime(int seconds) {
        this.labelTime.setText(Format.formatTimeSpan(seconds));
    }

    public boolean shouldStop() {
        return this.shouldStop;
    }

    public static void trainDialog(MLTrain train, BasicNetwork network, MLDataSet trainingSet) {
        TrainingDialog dialog = new TrainingDialog();
        dialog.setVisible(true);
        long start = System.currentTimeMillis();
        do {
            train.iteration();
            int iteration = train.getIteration();
            long current = System.currentTimeMillis();
            long elapsed = (current - start) / 1000L;
            dialog.setIterations(iteration);
            dialog.setError(train.getError());
            dialog.setTime((int)elapsed);
        } while (!dialog.shouldStop());
        train.finishTraining();
        dialog.dispose();
    }

    public static void trainDialog(BasicNetwork network, MLDataSet trainingSet) {
        ResilientPropagation train = new ResilientPropagation(network, trainingSet);
        train.setThreadCount(0);
        TrainingDialog.trainDialog(train, network, trainingSet);
    }
}

