/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.EncogError;
import org.encog.util.csv.CSVError;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ParseCSVLine;

public class ReadCSV {
    private final DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private CSVFormat format;
    private final BufferedReader reader;
    private final Map<String, Integer> columns = new HashMap<String, Integer>();
    private String[] data;
    private List<String> columnNames = new ArrayList<String>();
    private ParseCSVLine parseLine;

    public static String displayDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static Date parseDate(String when) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return sdf.parse(when);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public ReadCSV(InputStream is, boolean headers, char delim) {
        CSVFormat format = new CSVFormat(CSVFormat.getDecimalCharacter(), delim);
        this.parseLine = new ParseCSVLine(format);
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.begin(headers, format);
    }

    public ReadCSV(InputStream is, boolean headers, CSVFormat format) {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.begin(headers, format);
    }

    public ReadCSV(File file, boolean headers, char delim) {
        try {
            CSVFormat format = new CSVFormat(CSVFormat.getDecimalCharacter(), delim);
            this.parseLine = new ParseCSVLine(format);
            this.reader = new BufferedReader(new FileReader(file));
            this.begin(headers, format);
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }

    public ReadCSV(String filename, boolean headers, char delim) {
        this(new File(filename), headers, delim);
    }

    public ReadCSV(String filename, boolean headers, CSVFormat format) {
        this(new File(filename), headers, format);
    }

    public ReadCSV(File file, boolean headers, CSVFormat format) {
        try {
            this.reader = new BufferedReader(new FileReader(file));
            this.parseLine = new ParseCSVLine(format);
            this.begin(headers, format);
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }

    private void begin(boolean headers, CSVFormat format) {
        try {
            this.parseLine = new ParseCSVLine(format);
            this.format = format;
            if (headers) {
                String line = this.reader.readLine();
                if (line == null) {
                    this.columnNames.clear();
                    return;
                }
                List<String> tok = this.parseLine.parse(line);
                int i = 0;
                this.columnNames.clear();
                for (String header : tok) {
                    this.columnNames.add(header.toLowerCase());
                    this.columns.put(header.toLowerCase(), i++);
                }
            }
            this.data = null;
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }

    public String get(int i) {
        if (i >= this.data.length) {
            throw new EncogError("Can't access column " + i + " in a file that has only " + this.data.length + " columns.");
        }
        return this.data[i];
    }

    public String get(String column) {
        Integer i = this.columns.get(column.toLowerCase());
        if (i == null) {
            return null;
        }
        return this.data[i];
    }

    public int getColumnCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public Date getDate(String column) {
        try {
            String str = this.get(column);
            return this.sdf.parse(str);
        }
        catch (ParseException e) {
            throw new EncogError(e);
        }
    }

    public double getDouble(int index) {
        String str = this.get(index);
        return this.format.parse(str);
    }

    public double getDouble(String column) {
        String str = this.get(column);
        return this.format.parse(str);
    }

    public int getInt(int i) {
        String str = this.get(i);
        try {
            return this.format.getNumberFormatter().parse(str).intValue();
        }
        catch (ParseException e) {
            throw new CSVError(e);
        }
    }

    private void initData(String line) {
        List<String> tok = this.parseLine.parse(line);
        this.data = new String[tok.size()];
    }

    public boolean next() {
        try {
            String line = null;
            while ((line = this.reader.readLine()) != null && line.trim().length() == 0) {
            }
            if (line == null) {
                return false;
            }
            if (this.data == null) {
                this.initData(line);
            }
            List<String> tok = this.parseLine.parse(line);
            int i = 0;
            for (String str : tok) {
                if (i >= this.data.length) continue;
                this.data[i++] = str;
            }
            return true;
        }
        catch (IOException e) {
            throw new EncogError(e);
        }
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    public boolean hasMissing() {
        for (int i = 0; i < this.data.length; ++i) {
            String s = this.data[i].trim();
            if (s.length() != 0 && !s.equals("?")) continue;
            return true;
        }
        return false;
    }
}

